package PROP::TestCommon;

use strict;
use PROP::DBH;
use PROP::Util;
use base qw/Exporter/;

our @EXPORT = qw/create_tables drop_tables populate_database create_links/;

sub create_tables {
    my $sth;

    my $dbh = PROP::DBH->get_handle();

    $sth = $dbh->prepare("create table Foo (\n" .
			 "foo int(10) NOT NULL auto_increment,\n" .
			 "bar int(10),\n" .
			 "baz varchar(80),\n" .
			 "primary key (foo))\n");

    $sth->execute();


    $sth = $dbh->prepare("create table Biz (\n" .
			 "biz int(10) NOT NULL auto_increment,\n" .
			 "boz int(10),\n" .
			 "buzz varchar(80),\n" .
			 "primary key (biz))\n");


    $sth->execute();

    $sth = $dbh->prepare("create table Fizz (\n" .
			 "fizz int(10) NOT NULL auto_increment,\n" .
			 "fuzz int(10),\n" .
			 "fozz varchar(80),\n" .
			 "primary key (fizz))\n");

    $sth->execute();    


    $sth = $dbh->prepare("create table LinkFooToBiz (\n" .
			 "foo_id int(10) NOT NULL,\n" .
			 "biz_id int(10) NOT NULL,\n" .
			 "c1 varchar(80),\n" .
			 "c2 varchar(80),\n" .
			 "c3 varchar(80),\n" .
			 "primary key (foo_id, biz_id))\n");

    $sth->execute();

    $sth = $dbh->prepare("create table LinkFooToFizz  (\n" .
			 "foo_id int(10) NOT NULL,\n" .
			 "fizz_id int(10) NOT NULL,\n" .
			 "c1 varchar(80),\n" .
			 "c2 varchar(80),\n" .
			 "c3 varchar(80),\n" .
			 "primary key (foo_id, fizz_id))\n");

    $sth->execute();
}

sub drop_tables {
    PROP::Util::drop_table('Foo');
    PROP::Util::drop_table('Biz');
    PROP::Util::drop_table('Fizz');
    PROP::Util::drop_table('LinkFooToBiz');
    PROP::Util::drop_table('LinkFooToFizz');
}

sub create_links {
    return [new PROP::Link('LinkFooToBiz', 'Dummy::Foo', 'Dummy::Biz'),
	    new PROP::Link('LinkFooToFizz', 'Dummy::Foo', 'Dummy::Fizz')];
}

sub populate_database {
    my (@f, @b, @fz);

    my $links = create_links();

    foreach (1..4) {
	my $f = new Dummy::Foo();
	$f->set_bar($_);
	$f->set_baz('blah' . $_);
	$f->save();
	push(@f, $f);
    }

    foreach (1..16) {
	my $b = new Dummy::Biz();
	$b->set_boz($_);
	$b->set_buzz('bleh' . $_);
	$b->save();
	push(@b, $b);
    }

    foreach (1..16) {
	my $fz = new Dummy::Fizz();
	$fz->set_fuzz($_ * 2);
	$fz->set_fozz('bleh' . ($_ * 2));
	$fz->save();
	push(@fz, $fz);
    }

    for(my $i = 0; $i < 4; ++$i) {
	for(my $j = 0; $j < 4; ++$j) {
	    $links->[0]->insert($f[$i]->get_pk_value(),
				$b[$j]->get_pk_value(),
				{'c1' => $i, 'c2' => $i * $j, 'c3' => 'meh'});
	}
    }

    for(my $i = 0; $i < 4; ++$i) {
	for(my $j = 0; $j < 4; ++$j) {
	    $links->[1]->insert($f[$i]->get_pk_value(),
				$fz[$j]->get_pk_value(),
				{'c1' => $i * 2, 'c2' => 2 * $i * $j , 'c3' => 'bleh'});
	}
    }

    return (\@f, \@b, \@fz, $links);
}

package Dummy::Foo;

use strict;
use base qw/PROP::Object/;

sub get_table_name {
    return 'Foo';
}

package Dummy::Biz;

use strict;
use base qw/PROP::Object/;

sub get_table_name {
    return 'Biz';
}

package Dummy::Fizz;

use strict;
use base qw/PROP::Object/;

sub get_table_name {
    return 'Fizz';
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
