/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CallStatementNode
extends DMLStatementNode {
    private String methodName;
    private ValueNode methodCall;
    private SubqueryList subqueries;
    private Vector aggregateVector;

    public void init(Object object, Object object2) throws StandardException {
        this.init(null);
        this.methodName = (String)object;
        this.methodCall = (ValueNode)object2;
        ((JavaToSQLValueNode)object2).getJavaValueNode().markForCallStatement();
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "CALL";
    }

    public void printSubNodes(int n) {
    }

    public QueryTreeNode bind() throws StandardException {
        this.subqueries = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.aggregateVector = new Vector();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.methodCall = this.methodCall.bindExpression((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), this.subqueries, this.aggregateVector);
        return this;
    }

    public QueryTreeNode optimize() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        this.methodCall = this.methodCall.preprocess(this.getCompilerContext().getNumTables(), (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        if (this.subqueries.size() >= 1) {
            this.subqueries.optimize(dataDictionary, 1.0);
            this.subqueries.modifyAccessPaths();
        }
        return this;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateParameterValueSet(activationClassBuilder);
        JavaValueNode javaValueNode = ((JavaToSQLValueNode)this.methodCall).getJavaValueNode();
        javaValueNode.markReturnValueDiscarded();
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun("void", 1);
        methodBuilder2.addThrownException("java.lang.Exception");
        javaValueNode.generate(activationClassBuilder, methodBuilder2);
        methodBuilder2.endStatement();
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getCallStatementResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        this.generateParameterHolders(activationClassBuilder);
    }

    public ResultDescription makeResultDescription() {
        return null;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        if (visitor.skipChildren(this)) {
            return visitor.visit(this);
        }
        Visitable visitable = super.accept(visitor);
        if (this.methodCall != null && !visitor.stopTraversal()) {
            this.methodCall = (ValueNode)this.methodCall.accept(visitor);
        }
        return visitable;
    }

    public MethodCallNode getMethodCallNode() {
        JavaToSQLValueNode javaToSQLValueNode = (JavaToSQLValueNode)this.methodCall;
        MethodCallNode methodCallNode = (MethodCallNode)javaToSQLValueNode.getJavaValueNode();
        return methodCallNode;
    }
}

