/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public final class InsertNode
extends DMLModStatementNode {
    public ResultColumnList targetColumnList;
    public boolean deferred;
    public ValueNode checkConstraints;
    public Properties targetProperties;
    public FKInfo fkInfo;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    protected RowLocation[] autoincRowLocation;

    public void init(Object object, Object object2, Object object3, Object object4) {
        super.init(object3, ReuseFactory.getInteger(InsertNode.getStatementType((Properties)object4)));
        this.setTarget((QueryTreeNode)object);
        this.targetColumnList = (ResultColumnList)object2;
        this.targetProperties = (Properties)object4;
        this.getResultSetNode().setInsertSource();
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "INSERT";
    }

    public void printSubNodes(int n) {
    }

    public QueryTreeNode bind() throws StandardException {
        int n;
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindResultSetsWithTables(dataDictionary);
        this.verifyTargetTable();
        if (this.targetProperties != null) {
            this.verifyTargetProperties(dataDictionary);
        }
        this.getResultColumnList();
        if (this.targetColumnList != null) {
            if (this.targetTableDescriptor != null) {
                this.targetColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
            } else {
                this.targetColumnList.bindResultColumnsByName(this.targetVTI.getResultColumns(), this.targetVTI, this);
            }
        }
        this.resultSet.replaceDefaults(this.targetTableDescriptor, this.targetColumnList);
        super.bindExpressions();
        if (this.targetColumnList != null) {
            if (this.resultSet.getResultColumns().size() > this.targetColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.targetColumnList);
            this.resultSet.setTableConstructorTypes(this.targetColumnList);
        } else {
            if (this.resultSet.getResultColumns().size() > this.resultColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.resultColumnList);
            this.resultSet.setTableConstructorTypes(this.resultColumnList);
        }
        this.resultSet.bindResultColumns(fromList);
        int n2 = this.resultSet.getResultColumns().size();
        DataDictionary dataDictionary2 = this.getDataDictionary();
        if (this.targetColumnList != null ? this.targetColumnList.size() != n2 : this.targetTableDescriptor != null && this.targetTableDescriptor.getNumberOfColumns() != n2) {
            throw StandardException.newException("42802");
        }
        boolean bl = true;
        int n3 = this.resultColumnList.size();
        int[] nArray = new int[n3];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        if (this.targetColumnList != null) {
            n = this.targetColumnList.size();
            int n4 = 0;
            while (n4 < n) {
                int n5 = ((ResultColumn)this.targetColumnList.elementAt((int)n4)).columnDescriptor.getPosition();
                if (n4 != n5 - 1) {
                    bl = false;
                }
                nArray[n5 - 1] = n4++;
            }
        } else {
            for (n = 0; n < this.resultSet.getResultColumns().size(); ++n) {
                nArray[n] = n;
            }
        }
        if (!bl || this.resultSet.resultColumns.size() < n3) {
            this.resultSet = this.resultSet.enhanceRCLForInsert(n3, nArray, dataDictionary, this.targetTableDescriptor, this.targetVTI);
        }
        if (this.resultSet instanceof UnionNode) {
            this.resultColumnList.checkAutoincrementUnion(this.resultSet);
        } else {
            this.resultColumnList.checkAutoincrement(this.resultSet.getResultColumns());
        }
        this.resultColumnList.checkStorableExpressions(this.resultSet.getResultColumns());
        if (!this.resultColumnList.columnTypesAndLengthsMatch(this.resultSet.getResultColumns())) {
            this.resultSet = this.resultSet.genNormalizeResultSetNode(this.resultSet, false);
            this.resultColumnList.copyTypesAndLengthsToSource(this.resultSet.getResultColumns());
        }
        if (this.targetTableDescriptor != null) {
            ResultColumnList resultColumnList = this.resultSet.getResultColumns();
            resultColumnList.copyResultColumnNames(this.resultColumnList);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, resultColumnList, null, null, false, true);
            if (this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
                if (this.bulkInsertReplace && this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true)) {
                    throw StandardException.newException("42Y38", this.targetTableDescriptor.getQualifiedName());
                }
            }
            this.getAffectedIndexes(this.targetTableDescriptor);
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = dataDictionary2.computeAutoincRowLocations(transactionController, this.targetTableDescriptor);
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(1, this.targetVTI, null, this.resultSet);
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        boolean bl = false;
        if (this.targetTableDescriptor != null) {
            bl = this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor());
        }
        if (!bl) {
            bl = this.resultSet.referencesSessionSchema();
        }
        return bl;
    }

    private void verifyTargetProperties(DataDictionary dataDictionary) throws StandardException {
        String string = this.targetProperties.getProperty("insertMode");
        if (string != null) {
            String string2 = StringUtil.SQLToUpperCase(string);
            if (!string2.equals("BULKINSERT") && !string2.equals("REPLACE")) {
                throw StandardException.newException("42X60", string, (Object)this.targetTableName);
            }
            if (!this.verifyBulkInsert(dataDictionary, string2)) {
                this.targetProperties.remove("insertMode");
            } else {
                int n;
                String string3;
                this.bulkInsert = true;
                if (string2.equals("REPLACE")) {
                    this.bulkInsertReplace = true;
                }
                if ((string3 = this.targetProperties.getProperty("bulkFetch")) != null && (n = this.getIntProperty(string3, "bulkFetch")) <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(n));
                }
            }
        }
    }

    private boolean verifyBulkInsert(DataDictionary dataDictionary, String string) throws StandardException {
        return true;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            long l = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            int n = this.targetTableDescriptor != null ? this.indexConglomerateNumbers.length : 0;
            StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[n];
            for (int i = 0; i < n; ++i) {
                staticCompiledOpenConglomInfoArray[i] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[i]);
            }
            if (this.bulkInsert || this.targetTableDescriptor.getLockGranularity() == 'T') {
                this.lockMode = 7;
            }
            return this.getGenericConstantActionFactory().getInsertConstantAction(this.targetTableDescriptor, l, transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.indexNames, this.deferred, false, this.targetTableDescriptor.getUUID(), this.lockMode, null, null, this.targetProperties, this.getFKInfo(), this.getTriggerInfo(), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.getIndexedCols(), null, null, null, this.resultSet.isOneRowResultSet(), this.autoincRowLocation);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(1, this.deferred);
    }

    public boolean[] getIndexedCols() throws StandardException {
        boolean[] blArray = new boolean[this.targetTableDescriptor.getNumberOfColumns()];
        for (int i = 0; i < this.indicesToMaintain.length; ++i) {
            int[] nArray = this.indicesToMaintain[i].getIndexDescriptor().baseColumnPositions();
            for (int j = 0; j < nArray.length; ++j) {
                blArray[nArray[j] - 1] = true;
            }
        }
        return blArray;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCodeForTemporaryTable(activationClassBuilder, methodBuilder);
        this.generateParameterValueSet(activationClassBuilder);
        if (this.targetTableDescriptor != null) {
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            this.resultSet.generate(activationClassBuilder, methodBuilder);
            this.generateCheckConstraints(this.checkConstraints, activationClassBuilder, methodBuilder);
            activationClassBuilder.pushThisAsActivation(methodBuilder);
            methodBuilder.callMethod((short)185, null, "getInsertResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
        } else {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
            this.resultSet.generate(activationClassBuilder, methodBuilder);
            this.targetVTI.generate(activationClassBuilder, methodBuilder);
            activationClassBuilder.pushThisAsActivation(methodBuilder);
            methodBuilder.callMethod((short)185, null, "getInsertVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
        }
        this.generateParameterHolders(activationClassBuilder);
    }

    protected final int getStatementType() {
        return 1;
    }

    static final int getStatementType(Properties properties) {
        String string;
        String string2;
        int n = 1;
        String string3 = string2 = properties == null ? null : properties.getProperty("insertMode");
        if (string2 != null && (string = StringUtil.SQLToUpperCase(string2)).equals("REPLACE")) {
            n = 2;
        }
        return n;
    }

    private void getAffectedIndexes(TableDescriptor tableDescriptor) throws StandardException {
        IndexLister indexLister = tableDescriptor.getIndexLister();
        this.indicesToMaintain = indexLister.getDistinctIndexRowGenerators();
        this.indexConglomerateNumbers = indexLister.getDistinctIndexConglomerateNumbers();
        this.indexNames = indexLister.getDistinctIndexNames();
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        CompilerContext compilerContext = this.getCompilerContext();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            compilerContext.createDependency(conglomerateDescriptorArray[i]);
        }
    }
}

