#!/usr/bin/perl -w

=head1 NAME

example-track2spline.pl - Geo::Spline example to insert spline points between a filtered GPS log

=cut

use strict;
use lib qw{./lib ../lib};
use Geo::Spline;

my $p0=undef();
while (<DATA>) {
  chomp;
  my @data=split(/\|/, $_);
  my $p1={time=>$data[6],
          lat=>$data[7],
          lon=>$data[8],
          speed=>$data[10],
          heading=>$data[11]};
  if (defined($p0)) {
    if ($p1->{'time'} > $p0->{'time'}) {
      my $spline=Geo::Spline->new($p0, $p1);
      my $list=$spline->pointlist(); #[{},{}]
      foreach (@$list) {
        print join("|", 0, "spline", "", "", "", "", $_->{'time'},
                        $_->{'lat'}, $_->{'lon'}, "", $_->{'speed'}, $_->{'heading'}), "\n";
      }
    }
  }  
  print "$_\n";
  $p0=$p1;
}

__DATA__
1|trackfactor|33|967.833788478911|296.520347204649||1161724387.97|38.475835|-77.399872||31.268|31.2200|
1|trackfactor|161.990000009537|4863.28839813225|438.315014440745||1161724549.96|38.514990|-77.374777||30.568|23.0100|
1|trackfactor|60|1875.03541681331|438.193713717276||1161724609.96|38.528572|-77.361965||31.890|42.5400|
1|trackfactor|96.9900000095367|2942.53206964414|449.243938569978||1161724706.95|38.550433|-77.342830||31.556|16.8400|
1|trackfactor|92.9900000095367|2630.47337532785|446.148436695078||1161724799.94|38.572163|-77.330742||29.447|39.6300|
1|trackfactor|82|2416.32253320186|414.768168588892||1161724881.94|38.591067|-77.316953||30.733|18.2100|
1|trackfactor|79.9900000095367|2455.55388165733|431.340871189083||1161724961.93|38.610558|-77.303580||31.896|41.1000|
1|trackfactor|58|1831.83778890663|456.641318252644||1161725019.93|38.625288|-77.294065||32.271|20.6500|
1|trackfactor|168.990000009537|5196.1793218452|462.352034590809||1161725188.92|38.667810|-77.269013||32.554|65.1200|
1|trackfactor|135.990000009537|4108.78190477002|458.405116574451||1161725324.91|38.685947|-77.227792||32.055|12.8400|
1|trackfactor|120|3681.70301080158|467.37848096599||1161725444.91|38.717228|-77.213645||33.017|50.4600|
1|trackfactor|84.9900000095367|2727.5332543373|470.481524151752||1161725529.90|38.735828|-77.193108||31.767|32.0400|
1|trackfactor|75|2226.73676726127|452.168319611761||1161725604.90|38.754507|-77.183725||29.709|8.6000|
1|trackfactor|144.990000009537|3893.36699794264|417.69782001435||1161725749.89|38.789132|-77.176428||24.827|11.0300|
1|trackfactor|32|859.616541434582|349.658299917071||1161725781.89|38.795477|-77.170742||29.627|38.7700|
1|trackfactor|86.9900000095367|2370.9372988202|417.459430302531||1161725868.88|38.810000|-77.150693||27.338|58.9100|
1|trackfactor|127.989999771118|3823.19740534259|383.066263200541||1161725996.87|38.829410|-77.114270||30.167|61.8200|
1|trackfactor|121|3219.34399241779|433.579915721133||1161726117.87|38.843495|-77.081810||21.576|35.7300|
1|trackfactor|36.9900000095367|490.124963840637|313.053812495627||1161726154.86|38.846835|-77.078110||12.192|199.8400|
1|trackfactor|13|126.048412045315|192.408814722948||1161726167.86|38.847112|-77.079520||15.593|328.8100|
1|trackfactor|75|1108.49336145497|218.92095292375||1161726242.86|38.854562|-77.088040||2.372|328.5000|
1|trackfactor|16|2.48592026124601|35.5157064256065||1161726258.86|38.854583|-77.088050||0|264.2800|
1|trackfactor|34|26.4701050567728|26.4701050567728||1161726292.86|38.854797|-77.088185||7.603|329.7300|
