package Socket;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
$VERSION = "1.7";
use Carp;
require Exporter;
require DynaLoader;
@ISA=qw(Exporter DynaLoader);
@EXPORT=qw(
  inet_aton inet_ntoa pack_sockaddr_in unpack_sockaddr_in
  pack_sockaddr_un unpack_sockaddr_un
  sockaddr_in sockaddr_un
  INADDR_ANY INADDR_BROADCAST INADDR_LOOPBACK INADDR_NONE
  AF_802
  AF_APPLETALK
  AF_CCITT
  AF_CHAOS
  AF_DATAKIT
  AF_DECnet
  AF_DLI
  AF_ECMA
  AF_GOSIP
  AF_HYLINK
  AF_IMPLINK
  AF_INET
  AF_LAT
  AF_MAX
  AF_NBS
  AF_NIT
  AF_NS
  AF_OSI
  AF_OSINET
  AF_PUP
  AF_SNA
  AF_UNIX
  AF_UNSPEC
  AF_X25
  MSG_CTLFLAGS
  MSG_CTLIGNORE
  MSG_CTRUNC
  MSG_DONTROUTE
  MSG_DONTWAIT
  MSG_EOF
  MSG_EOR
  MSG_ERRQUEUE
  MSG_FIN
  MSG_MAXIOVLEN
  MSG_NOSIGNAL
  MSG_OOB
  MSG_PEEK
  MSG_PROXY
  MSG_RST
  MSG_SYN
  MSG_TRUNC
  MSG_URG
  MSG_WAITALL
  PF_802
  PF_APPLETALK
  PF_CCITT
  PF_CHAOS
  PF_DATAKIT
  PF_DECnet
  PF_DLI
  PF_ECMA
  PF_GOSIP
  PF_HYLINK
  PF_IMPLINK
  PF_INET
  PF_LAT
  PF_MAX
  PF_NBS
  PF_NIT
  PF_NS
  PF_OSI
  PF_OSINET
  PF_PUP
  PF_SNA
  PF_UNIX
  PF_UNSPEC
  PF_X25
  SCM_CONNECT
  SCM_CREDENTIALS
  SCM_CREDS
  SCM_RIGHTS
  SCM_TIMESTAMP
  SOCK_DGRAM
  SOCK_RAW
  SOCK_RDM
  SOCK_SEQPACKET
  SOCK_STREAM
  SOL_SOCKET
  SOMAXCONN
  SO_ACCEPTCONN
  SO_BROADCAST
  SO_DEBUG
  SO_DONTLINGER
  SO_DONTROUTE
  SO_ERROR
  SO_KEEPALIVE
  SO_LINGER
  SO_OOBINLINE
  SO_RCVBUF
  SO_RCVLOWAT
  SO_RCVTIMEO
  SO_REUSEADDR
  SO_SNDBUF
  SO_SNDLOWAT
  SO_SNDTIMEO
  SO_TYPE
  SO_USELOOPBACK
);
@EXPORT_OK=qw(CR LF CRLF $CR $LF $CRLF);
%EXPORT_TAGS=(crlf=>[qw(CR LF CRLF $CR $LF $CRLF)],all=>[@EXPORT,@EXPORT_OK],);
BEGIN{sub CR (){"\015"}sub LF (){"\012"}sub CRLF (){"\015\012"}}*CR=\CR();
*LF=\LF();
*CRLF=\CRLF();
sub sockaddr_in{if(@_==6&&!wantarray){my($af,$port,@quad)=@_;
carp"6-ARG sockaddr_in call is deprecated" if$^W;
pack_sockaddr_in($port,inet_aton(join('.',@quad)));}elsif(wantarray){croak"usage:   (port,iaddr) = sockaddr_in(sin_sv)" unless@_==1;
unpack_sockaddr_in(@_);}else{croak"usage:   sin_sv = sockaddr_in(port,iaddr))" unless@_==2;
pack_sockaddr_in(@_);}}sub sockaddr_un{if(wantarray){croak"usage:   (filename) = sockaddr_un(sun_sv)" unless@_==1;
unpack_sockaddr_un(@_);}else{croak"usage:   sun_sv = sockaddr_un(filename)" unless@_==1;
pack_sockaddr_un(@_);}}sub AUTOLOAD{my($constname);
($constname=$AUTOLOAD)=~s/.*:://;
my$val=constant($constname,@_?$_[0]:0);
if($!!=0){my($pack,$file,$line)=caller;
croak"Your vendor has not defined Socket macro $constname, used";}eval"sub $AUTOLOAD { $val }";
goto&$AUTOLOAD;}bootstrap Socket$VERSION; 1;
