use strict;
use Test::More;

use File::Which qw(which);
plan skip_all => 'could not find git' unless which('git');

use Plack::Test;
use HTTP::Request::Common;
use Plack::App::GitSmartHttp;

my $app = Plack::App::GitSmartHttp->new(
    root          => "t/test_repos",
    upload_pack   => 1,
    received_pack => 1,
);

test_psgi $app, sub {
    my $cb  = shift;
    my $res = $cb->(
        POST "/repo1/git-receive-pack",
        "Content-Type" => "application/x-git-receive-pack-request"
    );
    is $res->code, 200;
    is $res->header("Content-Type"), 'application/x-git-receive-pack-result';
};

done_testing
