/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.UsernamePasswordCallbackHandler;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaslConfig
implements SaslConfig {
    private ConnectionFactory factory;
    private String authorizationId;
    private Map<String, ?> mechanismProperties;
    private CallbackHandler callbackHandler;

    public DefaultSaslConfig(ConnectionFactory factory) {
        this.factory = factory;
        this.callbackHandler = new UsernamePasswordCallbackHandler(factory);
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public void setMechanismProperties(Map<String, ?> mechanismProperties) {
        this.mechanismProperties = mechanismProperties;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public SaslClient getSaslClient(String[] mechanisms) throws SaslException {
        return Sasl.createSaslClient(mechanisms, this.authorizationId, "AMQP", this.factory.getHost(), this.mechanismProperties, this.callbackHandler);
    }
}

