#ifndef _nurbtype_
#define _nurbtype_

#define PC_MaxNetpts    200  /*Maximum number of points is a net*/
#define PC_NrbMax       50 /*Pseudo maximum number of control points*/
#define PC_NrbKmax      20   /*Maximum order of the splines*/

#define pfhx x
#define pfhy y
#define pfhz z
#define pfhw w
#define LONG_MAX 100000

typedef struct PR_stats {
  Pint pf_areqs;   /*Allocate requests*/
  Pint pf_dreqs;   /*deAllocate requests*/
  Pint pf_inuse;   /*Number in Use*/
  Pint pf_maxQlen; /*maximum queue length*/
  Pint pf_Qlen;    /*Queue length*/
  Pint pf_minBsize;/*minimum block size*/
  Pint pf_maxBsize;/*maximum block size*/
  Pint pf_nochange;/*Number of allocates that do nothing*/
  Pint pf_news;    /*Number of allocates that do Malloc*/
} PR_stats;

typedef struct PR_knots {
  struct PR_knots 	*pf_next;   /*Pointer to next one*/
  Pint 			pf_size;    /*Size of this one*/
  Pfloat 		knots[1];     /*Array of the knots*/
} PR_knots;

typedef struct PR_pts {
  struct PR_pts 	*pf_next; /*Pointer to next one*/
  Pint 			pf_size;  /*Size of this one*/
  Ppoint4 		pts[1];    /*Array of the Points*/
} PR_pts;

typedef struct PR_dir {
  Pint     pf_k;     /* order in x */
  Pint     pf_n;     /* number of vertices*/
  Pint     pf_nt;    /* number of knots  n+k*/
  PR_knots *pf_kk;   /* Pointer to knots*/
} PR_dir;


typedef struct PR_nurb {     /* tensor product surface */
  PR_dir         pf_u;       /* U and V stuff*/
  PR_dir         pf_v;
  PR_pts         *pf_ppp;    /*Pointer to control points*/
  struct PR_nurb *pf_next;   /*Pointer to next in free list*/
  struct PR_nurb *pf_prev;   /*Pointer to prev in free list*/
  Pint           pf_id;      /*Integer ID for user use!*/
} PR_nurb;

typedef enum {PVudir, PVvdir} PE_dir;

#define nrb_index(x,y,nx) ((x) + ((y) - 1) * (nx))
#define ni(x,y,nx)        ((x) + ((y) - 1) * (nx))

#endif
