#include "all.h"
#include <math.h>
#include <time.h>
extern int ngerror;
extern int in_recover;
extern int curx;
extern int cury;
extern int max_x,max_y;
#define tok(j) (tk[j])
#define dbg if (gle_debug>0)
extern char file_name[];
extern int iserr;
int gle_debug,changed;
extern int trace_on;
extern int exit_manip;
int isating;
int islogging;
int load_list;
int dpoints;
int outwidth1=8,outwidth2=8;
int getrange(char *s, double *min, double *max, double *step);
char *between=" ";
char strmiss[40];
int stripspace(char *s);
int getstr(char *s);
FILE *ip;
/*---------------------------------------------------------------------------*/
main(int argc, char *argv[])
{
	static char inbuff[200];
	static char *tk[500];
	static char tkbuff[500];
	char dfile[80];
	char bfile[80];
	char lfile[80];
	char xstr[90];

	char outstr[80];
	long pcode[200];
	int plen;
	int cp,pii;
	int vtype = 1;
	int i,al,ntok,f,nx,ny,xi,yi;
	FILE *fp;
	char space_str[] = " ";

	double xmin,xmax,xstep,v;
	double x,y,ymin,ymax,ystep;
	char exp[200];

	ngerror = 0;
	if (argc>1) {
		strcpy(lfile,argv[1]);
		if (strchr(lfile,'.')==NULL) strcat(lfile,".let");
		ip = fopen(lfile,"r");
		if (ip==NULL) {
			printf("Unable to open let file {%s} \n",lfile);
			exit(1);
		}
	} else ip = stdin;

indfile:
	printf("File to store data in ? "); getstr(dfile);
	if (strlen(dfile)==0) goto indfile;
	if (strchr(dfile,'.')!=NULL) *strchr(dfile,'.') = 0;
	strcpy(bfile,dfile);
	strcat(bfile,".let");
	strcat(dfile,".z");
	printf("Storing data in {%s} and commands in {%s} \n",dfile,bfile);

	printf("Enter xmin,xmax,xstep (on one line) [0,30,1] ? "); getstr(xstr);
	getrange(xstr,&xmin,&xmax,&xstep);

	printf("Enter ymin,ymax,ystep [0,30,1] ? "); getstr(xstr);
	getrange(xstr,&ymin,&ymax,&ystep);

	printf("\nFor y = %g to %g step %g\n",ymin,ymax,ystep);
	printf("For x = %g to %g step %g\n",xmin,xmax,xstep);

	printf("Valid funtions:  (trig functions use radians)\n");
	printf("	abs(), atn(), cos(), exp(), fix(),\n");
	printf("	int(), log(), log10(), rnd(), sgn(), sin(),\n");
	printf("	sqr(), sqrt(), tan(), PI, (x^3 = x*x*x) \n");
	printf("	e.g.	3*x^2+sin(y*180/pi)\n");

	var_findadd("X",&pii,&vtype);
	var_findadd("Y",&pii,&vtype);
	var_findadd("PI",&pii,&vtype);
	var_set(pii,3.141592654);
	token_space();

tryagain:;
	ngerror = 0;
	printf("Enter equation:   \n ? "); getstr(exp);
	vtype = 1; plen = 0;
	stripspace(exp);
	printf("z = %s \n",exp);
	polish(exp,(char *) pcode,&plen,&vtype);
	if (ngerror!=0) goto tryagain;

	fp = fopen(dfile,"w");
	if (fp==NULL) {
		printf("Unable to open {%s} \n",dfile);
		exit(1);
	}

	printf("\n");
	nx = (xmax-xmin)/xstep + 1;
	ny = (ymax-ymin)/ystep + 1;
	fprintf(fp,"! nx %d ny %d xmin %g xmax %g ymin %g ymax %g \n",nx,ny,xmin,xmax,ymin,ymax);

	printf("Y = ");
	for (y=ymin, yi=0; yi<ny ; yi++,y+=ystep) {
	  printf("%g ",y);
	  for (x=xmin, xi=0; xi<nx; xi++, x+=xstep) {
		eval_setxy(x,y);
		cp = 0;
		eval(pcode,&cp,&v,outstr,&vtype);
		fprintf(fp,"%g ",v);
	  }
	  fprintf(fp,"\n");
	}
	fclose(fp);
	fclose(ip);
	printf("\n");

	fp = fopen(bfile,"w");
	if (fp==NULL) {
		printf("Unable to open cmd file {%s} \n",bfile);
		exit(1);
	}
	fprintf(fp,"%s\n",dfile);
	fprintf(fp,"%g, %g, %g\n",xmin,xmax,xstep);
	fprintf(fp,"%g, %g, %g\n",ymin,ymax,ystep);
	fprintf(fp,"%s\n",exp);
	fclose(fp);
	printf("Use   LETZ %s   to remake the same data file\n",bfile);
}
getstr(char *s)
{
	char *ss;
	ss = fgets(s,200,ip);
	if (ss==NULL) {
		printf("\nERROR, End of input file \n");
		exit(1);
	}
	ss = strchr(s,'\n');
	if (ss!=NULL) *ss = 0;
	ss = strchr(s,'!');
	if (ss!=NULL) *ss = 0;
}
getrange(char *s, double *min, double *max, double *step)
{
	*min = 0; *max = 30; *step = 1;
	s = strtok(s,", :\n\t");
	if (s!=NULL) *min = atof(s);
	s = strtok(NULL,", :\n\t");
	if (s!=NULL) *max = atof(s);
	*step = (*max - *min) / 30.0;
	s = strtok(NULL,", :\n\t");
	if (s!=NULL) *step = atof(s);
}
gle_abort(char *s)
{
	printf("Aborting %s\n",s);
	exit(1);
}
stripspace(char *ss)
{
	char buff[300],*b,*s=ss;
	b = buff;
	for (; *s!=0; s++)
		 if (*s!=' ' && *s!='\t') *b++ = *s;
	*b++ = 0;
	strcpy(ss,buff);
}
tt_inkey()
{}
#ifdef unix
getch(){}
#endif
