/* This is the surface command which translates to run the individual
   surface programs:
	  surface myfile -dps       ---> surf_ps myfile
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#define false 0
#define true (!false)
main(int argc,char *argv[])
{
	static char buff[200];
	static char restofline[200];
	static char surfacefile[200];
	static char device[200];
	static char outfile[200];
	static char bindir[200];
	char *s;
	int i;

/*  Get the directory containing the gle_* binaries */
	s = getenv("SURF_TOP");
	if (s!=NULL) {
	    strcpy(bindir,s);
	} else {
	    strcpy(bindir,GLEBINS);
	}
	if (bindir[strlen(bindir)-1] != '/')
	    strcat(bindir,"/");

	if (argc<2) {
	  printf("Usage: surface filename.gle -ddevice\n");
	  printf("    surface test        (Dumb terminal) \n");
	  printf("    surface test -dx    (Xwindows) \n");
	  printf("    surface test -dtek  (TEK4010) \n");
	  printf("    surface test -dhpgl (HP Plotters) \n");
	  printf("    surface test -dps   (PostScript) \n");
	  printf("To find out what drivers are available type in:\n");
	  printf("         ls %ssurf_* \n", bindir);
	  printf(" \n");
	  return 0;
	}
	strcpy(device,"vt");
	for (i=1;i<argc;i++) {
		if (strncmp(argv[i],"-d",2)==0) strcpy(device,argv[i]+2);
		else if (isalnum(*argv[i])) strcpy(surfacefile,argv[i]);
		else {
			strcat(restofline," ");
			strcat(restofline,argv[i]);
		}
	}
	strcpy(outfile,surfacefile);
	s = strchr(outfile,'.');
	if (s!=NULL) *s = 0;
	strcat(outfile,".");
	strcat(outfile,device);
	sprintf(buff,"%ssurf_",bindir); /* , GLEBINSOD); */
	strcat(buff,device);
	strcat(buff," ");
	strcat(buff,surfacefile);
	strcat(buff," /output=");
	strcat(buff,outfile);
	strcat(buff,restofline);
	printf("%s\n",buff);
	execlp("sh","sh","-c", buff,0);
}

