#include "all.h"
#include "axis.h"
#include "mygraph.h"
#include <math.h>

#ifdef VAXC 		/* because it won't fit on the PC */
#define HERROR 1		/* because it won't fit on the PC */
#endif
#define HERROR 1 /* only uses about 2k more */

#define BEGINDEF extern
#include "begin.h"

/* for key command and gx(), gy() */

#define dbg if ((gle_debug & 64)>0)
#define LARGE_NUM 1E30
extern int gle_debug;

int graph_init(void);
int graph_free(void);
int iffree(void *p,char *s);
int setrange(double x, double y, int m);
int gdraw_key(double koffsetx, double koffsety, char *kpos, double khei, int knobox);
int copy_default(int d);
int do_dataset(int d);
int draw_errbar(double x, double y, double eup, double ewid);
int fill_vec(double x1, double y1, double x2, double y2);
int do_smooth(void);
int window_set(void);
int draw_bars(void);
int draw_lines(void);
int draw_fills(void);
int draw_err(void);
int do_let(char *s);
int request(void);
int draw_axis(void *axis);
int draw_bar(double x, double yf, double yt, double wd,double x3d,double y3d,long sidecolor, long topcolor, int notop);
int doskip(char *s,int *ct);
double get_next_exp(TOKENS tk,int *ntk,int *curtok);

/* #define fnx(vv)  (((vv-wxmin)/(wxmax-wxmin)) * xlength + xbl) */
/* #define fny(vv)  (((vv-wymin)/(wymax-wymin)) * ylength + ybl) */
#define kw(ss) if (strcmp(tk[ct],ss)==0)
#define true (!false)
#define false 0

int var_find_dn(int *idx, int *vara, int *nd);
char *un_quote(char *ct);

#define skipspace doskip(tk[ct],&ct)
#define tok(n)  (*tk)[n]
#define next_exp (get_next_exp((TOKENS) tk,&ntk,&ct))
#define next_font ((ct+=1),pass_font(tk[ct]))
#define next_marker ((ct+=1),pass_marker(tk[ct]))
#define next_color ((ct+=1),pass_color(tk[ct]))
#define next_fill ((ct+=1),pass_color(tk[ct]))
#define next_str(s)  (ct+=1,skipspace,strcpy(s,tk[ct]))
#define next_vstr(s)  (ct+=1,skipspace,mystrcpy(&s,tk[ct]))
#define next_vquote(s) (ct+=1,skipspace,mystrcpy(&s,un_quote(tk[ct])))
#define next_quote(s) (ct+=1,skipspace,strcpy(s,un_quote(tk[ct])))
#define ifer if (erflg)

extern long *(*gpcode)[];   /* gpcode is a pointer to an array of poiter to long */
extern long (*gplen)[];   /* gpcode is a pointer to an array of long */
extern int ngpcode;

struct fill_data {
	int da,db;	/* fill from, too */
	int type; 	/* 1= x1,d1, 2=d1,x2, 3=d1,d2, 4=d1 */
	long color;
	double xmin,ymin,xmax,ymax;
};
struct data_struct {
	double *xv;	/* from zero */
	double *yv;
	int *miss;
	int nomiss;
	int np,autoscale;
	char lstyle[9];
	char *bigfile;	/* for datasets too big for memory */
	char *key_name;
	long key_fill;
	char errup[9],errdown[9];
	double errwidth;
#ifdef HERROR 		/* because it won't fit on the PC */
	char herrup[9],herrdown[9];
	double herrwidth;
#endif
	double msize,lwidth;
	int marker, smooth, smoothm;
	int mdata;
	long color;
	double scale_ax, scale_bx, scale_ay, scale_by;
	double xmin,ymin,xmax,ymax;
	double mscale;
	int line;
	double rx1,ry1,rx2,ry2;
};
struct bar_struct {
	int ngrp;
	int from[20];
	int to[20];
	double width,dist;
	double lwidth[20];
	char lstyle[20][9];
	long fill[20];
	long color[20];
	long side[20];
	long top[20];
	int notop;
	double x3d,y3d;
};

#ifdef __TURBOC__
#define MAXTEMP 2000
#else
#define MAXTEMP 10000
#endif

#ifdef GRAPHDEF
#else
#define GRAPHDEF
#endif

GRAPHDEF double range_x1,range_y1,range_x2,range_y2;  /* graph unist */
GRAPHDEF double graph_x1,graph_y1,graph_x2,graph_y2;  /* in cm */
GRAPHDEF double graph_xmin,graph_ymin,graph_xmax,graph_ymax; /* graph units */
GRAPHDEF double *tmpf;  /* [MAXTEMP+10]; */
GRAPHDEF int *tmpmiss; /*  [MAXTEMP+10]; */
GRAPHDEF int ntmp_alloc; /*  [MAXTEMP+10]; */
GRAPHDEF char ebuff[400];
GRAPHDEF int etype,eplen;
GRAPHDEF double wxmin,wymin,wxmax,wymax; /* in axis units the bounds of the graph */
GRAPHDEF double xbl,ybl;
GRAPHDEF double xlength,ylength;
GRAPHDEF double g_xsize,g_ysize,g_hscale,g_vscale,g_fontsz;
GRAPHDEF double last_vecx,last_vecy;
GRAPHDEF int ndata,g_nobox,done_line;
GRAPHDEF double sizex,sizey;
GRAPHDEF double vscale,hscale;

GRAPHDEF struct fill_data *fd[20];
GRAPHDEF int nfd;
GRAPHDEF int gntmp;

GRAPHDEF struct data_struct *dp[101];
GRAPHDEF struct data_struct *dpp;

GRAPHDEF int g_nbar;
GRAPHDEF struct bar_struct *br[20];
GRAPHDEF struct axis_struct xx[5];
int vinit_axis(int i);














