#define PWIDTH 32   /* puts it on a boundary so far pointers work better */
typedef struct s_run {
	unsigned char *alloc; /* Array, Num of allocated bytes for row */
	unsigned char *used; /* Number currently used */
	int *(*row)[];  /* Pointer, to array of pointers to row count data */
} Run;

typedef unsigned char *ucharp;
typedef int *(*typrow)[];
typedef struct bitmap {
	char *(*data)[];
        int compress;
	int nx,ny;
	int x1,y1,sx,sy,lddy,sddy,lendx,lendy,ssx,ssy;
	Run clip;
	int clipping;
	int *lastclip;
	Run paint;
	Run horiz;
	int painty1,painty2;
	long lstyle,lstyle_mask;
        int lstyle_dotlen, lstyle_dotpix;
	int lwidth;
	char ink[16][16];
} Bitmap;



Bitmap *bmp_open(int xsize,int ysize,int depth,int bmp_compression);
int iffree(void *block);
int bmp_close(Bitmap *b);
int bmp_line(Bitmap *b,int x1,int y1,int x2,int y2);
int bmp_pixel(Bitmap *b,int x, int y);
int bmp_paintrange(Bitmap *b,int y, int x1, int x2);
int bmp_invis(Bitmap *b, int x, int y);
int bmp_pmove(Bitmap *b,int x1,int y1);
int bmp_pline(Bitmap *b,int x2,int y2);
int bmp_clipline(Bitmap *b,int *x1, int *y1, int *x2, int *y2);
int doclip(int min, int max, int *v);
int bmp_minmax(Bitmap *b,int y);
int bmp_paintx(Bitmap *b, int x, int y);
int bmp_newpath(Bitmap *b);
int bmp_paintsort(int *p, int np);
int bmp_fill(Bitmap *b);
int bmp_copy(Bitmap *b,char *bitmap,int nx,int ny);
int bmp_clip(Bitmap *b);
int bmp_newclip(Bitmap *b);
int bmp_saveclip(Bitmap *b);
int bmp_restoreclip(Bitmap *b);
int bmp_color(Bitmap *b,int colindex);
int bmp_lwidth(Bitmap *b,int x);
int bmp_lstyle(Bitmap *b,long n,int l);
int bmp_pattern(Bitmap *b,char *pat,int nxbytes,int nybytes,int depth);
char *bmp_row(Bitmap *b,int y);
int bmp_die(char *s);
