#include "defines.h"

/****************************************************************/
/*	Graph Traversal Routines
/****************************************************************/
#define MAX_STACK 100000

static int ptr = 0;
static EDGE_PTR elts[MAX_STACK] ;

push_edge(edge)
EDGE_PTR edge;
{
    if ( ptr == MAX_STACK ) {
        printf("push_edge():  stack overflow ( MAX_STACK = %d )\n",MAX_STACK);
    }
    else {
	elts[++ptr] = edge;
    }
}

EDGE_PTR pop_edge()
{
    return( ptr>0 ? elts[ptr--] : -1 );
}

zero_seen()
{
    int i;

    for (i=0; i<3*n_sites; i++)
	ei[i].see = 0;

    ptr = 0;
    push_edge(One_bndry_edge);
}

zero_seen_int()
{
    EDGE_PTR nex;

    zero_seen();
    for_rring_a(One_bndry_edge,nex)
	seen(nex) |= dir_see(sym(nex));
    end_rring_a(One_bndry_edge,nex)
}

push_sym_ring(edge)
EDGE_PTR edge;
{
    EDGE_PTR e;

    for_oring_o(edge,e)
	seen(e) |= dir_see(e);
	push_edge(sym(e));
    end_oring_o(edge,e)
    seen(edge) |= dir_see(edge);
}
