/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "vcs.h"
#include "queue.h"
def_q(facet_edge);

/*
** this will find each face of the cell around s, and call
**      func(face,s)
*/

void
trace_faces_of_cell(s,func)
site s;
void (*func)();
{
    struct q_of_facet_edge q;
    bool mark_dir;
    register facet_edge fe,swung;

    empty(q);
    mark_dir = !marked(s->one_fe);
    enq(q,s->one_fe,facet_edge);

    while non_empty(q)
    {
	deq(q,fe,facet_edge);
	if (marked(fe) == mark_dir)
	    continue;	/* it has been marked since it was queued */

	for_edges(fe,e)
	    marked(e) = mark_dir;
	end_edges(fe,e)

	(*func)(fe,s);

	for_other_edges(fe,e)
	    if(marked(swung=swing(e,s)) != mark_dir)
		enq(q,swung,facet_edge);
	end_edges(fe,e)
    }
}

void
trace_edges_of_cell(s,func)
site s;
void (*func)();
{
    struct q_of_facet_edge q;
    bool mark_dir;
    register facet_edge fe,swung;

    empty(q);
    mark_dir = !marked(s->one_fe);
    enq(q,s->one_fe,facet_edge);

    while non_empty(q)
    {
	deq(q,fe,facet_edge);
	if (marked(fe) == mark_dir)
	    continue;	/* it has been marked since it was queued */

	swung = swing(fe,s);
	marked(fe) = marked(swung) = mark_dir; (*func)(fe,s);

	if (marked(fe->nextedge) != mark_dir)
	    enq(q,fe->nextedge,facet_edge);
	if (marked(swung->nextedge) != mark_dir)
	    enq(q,swung->nextedge,facet_edge);
    }
}

void
trace_wings_of_vertex(c,func)
corner c;
void (*func)();
{
    struct q_of_facet_edge q;
    bool mark_dir;
    register facet_edge fe,swung;

    empty(q);
    mark_dir = !marked(c->one_fe);
    enq(q,c->one_fe,facet_edge);

    while non_empty(q)
    {
	deq(q,fe,facet_edge);
	if (marked(fe) == mark_dir)
	    continue;	/* it has been marked since it was queued */

	for_facets(fe,f)
	    marked(f) = mark_dir;
	end_facets(fe,f)

	(*func)(fe,c);

	for_other_facets(fe,f)
	    if(marked(swung=eswing(f,c)) != mark_dir)
		enq(q,swung,facet_edge);
	end_facets(fe,f)
    }
}

void
trace_4wings_of_vertex(c,func)
corner c;
void (*func)();
{
    register facet_edge fe,swung;

    fe = c->one_fe;
    (*func)(fe,c);
    for_facets(fe,f)
	(*func)(eswing(f,c),c);
    end_facets(fe,f)
}

void
trace_all_faces(func)
void (*func)();
{
    register facet_edge fe;
    struct q_of_facet_edge q;
    register bool mark_dir;
    register facet_edge next;
    site s;
#ifdef DEBUG
    int count = 1, mx = 1;
#endif

    empty(q);
    for_sites(s)
	if (fe=s->one_fe)
	    break;
    if (!fe)
	return;
    mark_dir = !marked(fe);
    enq(q,fe,facet_edge);

    while non_empty(q)
    {
	deq(q,fe,facet_edge);
	DBG(1,count--);
	if (marked(fe) == mark_dir)
	    continue;	/* it has been marked since it was queued */

	for_edges(fe,e)
	    marked(e) = mark_dir;
	end_edges(fe,e)

	(*func)(fe);

	for_edges(fe,e)
	    if(marked(next=e->nextfacet) != mark_dir)
	    {
		DBG(1,mx = (++count>mx? count : mx));
		enq(q,next,facet_edge);
	    }
	end_edges(fe,e)
    }
    DBG(1, printf("Maximum queue size in trace_all_faces was %d\n",mx));
}

void
trace_all_edges(func)
void (*func)();
{
    register facet_edge fe;
    struct q_of_facet_edge q;
    register bool mark_dir;
    register facet_edge next;
    site s;

    empty(q);
    for_sites(s)
	if (fe=s->one_fe)
	    break;
    if (!fe)
	return;
    mark_dir = !marked(fe);
    enq(q,fe,facet_edge);

    while non_empty(q)
    {
	deq(q,fe,facet_edge);
	if (marked(fe) == mark_dir)
	    continue;	/* it has been marked since it was queued */

	for_facets(fe,f)
	    marked(f) = mark_dir;
	end_facets(fe,f)

	DBG(3, print_face(fe));

	(*func)(fe);

	for_facets(fe,f)
	    if(marked(next=f->nextedge) != mark_dir)
		enq(q,next,facet_edge);
	end_facets(fe,f)
    }
}

void
no_op(x,y)
facet_edge x;
{
    return;
}
