/* Copyright 1988 John M. Sullivan.  See main program for details. */
#include "vcs.h"

double
n_dot(a,b,n)
register double *a,*b;
register int *n;
{
    register double dt;
    register int m;

    dt = 0.;
    for(m = *n; m; --m)
	dt += *b++ * *a++;
    return dt;
}

double
n_dot_after_sub_mult(a,xptr,b,c,n)	/* c dot (a = a-xb) */
register double *a,*xptr,*b,*c;
register int *n;
{
    register double dt;
    register double x = *xptr;
    register int m;

    if (x == 0.)
	return n_dot(a,c,n);
    dt = 0.;
    for(m = *n; m; --m)
    {
	*a -= x*(*b++);
	dt += *c++ * *a++;
	/* dt += *c++ * (*a++ -= x*(*b++)); */
	/* the second gives less optimized code, and also actually gives **
	** undefined result if c===a */
    }
    return dt;
}

int
get4lp(array,nptr,i1ptr,i2ptr,i3ptr,area321,v0ptr,ccra,bdaptr,tolerptr)
point_with_norm2 array;
int *nptr,*i1ptr,*i2ptr,*i3ptr;
register point area321;
real *v0ptr,*bdaptr,*tolerptr;
register point_with_norm2 ccra;
{
    register real vh = HUGE, newvol, newheight;
    register real vol0 = *v0ptr, bda = *bdaptr, toler = *tolerptr;
    register point_with_norm2 p;
    register int i,i4 = -1;
    register int i1 = *i1ptr, i2 = *i2ptr, i3 = *i3ptr;

    for(i = *nptr-1, p = array+i; i >= 0; --i,--p)
    {
	if (i == i1 || i == i2 || i == i3)
	    continue;
	if ((newvol = dot_q(area321,pnt(p))-vol0) < toler)
	    continue;	/* candidate was in wrong half plane */
	if ((newheight = (dot_4(ccra,p) + bda) / newvol) < vh)
	    i4 = i, vh = newheight; /* dot_4 is dot(cxa,p)+ada*p^2 */
    }
    return i4;
}
