/****
   usage.c:  defualt usage message for "omni_interp".
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


#include <stdio.h>
#include "globals.h"

usage ()
{
  fprintf (stderr, "Usage: %s <options> file1 ... filen outfile\n", progname);
  fprintf (stderr, "  options:\n");
  fprintf (stderr, "    -LINEAR      (Linear interpolation)\n");
  fprintf (stderr, "    -CARDINAL    (Cardinal spline interpolation\n");
#ifdef USER_FUN
  fprintf (stderr, "    -USER        (User-defined interpolation\n");
  fprintf (stderr, "		     (default = USER)\n");
#else /* not USER_FUN */
  fprintf (stderr, "                 (default = LINEAR)\n");
#endif /* not USER_FUN */
  fprintf (stderr, "    -ASCII       (ASCII data files)\n");
  fprintf (stderr, "    -BINARY      (BINARY data files)\n");
  fprintf (stderr, "                 (default = ASCII)\n");
  fprintf (stderr, "    -number nnn  (nnn = number output files.)\n");
  fprintf (stderr, "                 (default = 10)\n");
  fprintf (stderr, "    -all         (regard integers as floating point.)\n");
  fprintf (stderr, "    -skip nnn  (nnn = number lines to skip (ASCII))\n");
  fprintf (stderr, "               (nnn = number bytes to skip (BINARY))\n");
  fprintf (stderr, "               (default = 0)\n");
  fprintf (stderr, "    -in_time n time1 time2 ... timen\n");
  fprintf (stderr, "            (n = number of times, timei = times\n");
  fprintf (stderr, "            (default = uniform by number of input files)\n");
  fprintf (stderr, "    -out_time n time1 time2 ... timen\n");
  fprintf (stderr, "             (n = number of times, timei = times\n");
  fprintf (stderr, "             (default = uniform by number of output files)\n");
  fprintf (stderr, "    -suffix strng  (strng appended to output names)\n");
  fprintf (stderr, "    -format string (printf-like format for file names)\n");
  fprintf (stderr, "    -data_chunk nnn  (group data nnn items at a time)\n");
  fprintf (stderr, "                     (default = 1)\n");
  fprintf (stderr, "    -file_chunk nnn  (buffer nnn items of data from data file)\n");
  fprintf (stderr, "                     (default = 1000)\n");
#ifdef USER_FUN
  fprintf (stderr, "    -N nnn (where N = A, B, ..., F)\n");
  fprintf (stderr, "           (set internal parameter to given value)\n");
#endif /* USER_FUN */
  fprintf (stderr, "    -read filename  (read command line options from file)\n");
}

