/****
   gravity.c:  sample user-defined interpolation function
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

#include "omni_interp.h"

/*	This function interpolates between two data files which are
 *	assumed to represent coordinates of points in space.  One
 *	point goes to another by means of a parabolic arc, as if the
 *	point jumped into the air subject to a given gravity, given
 *	as parameter A.
 */

void
user_interp (time, in , out, file_pos, data_pos)
     double time;			/* Time of this interpolation. */
     double **in;			/* Input data. */
     double *out;			/* Interpolated data. */
     int file_pos;			/* Position of this data chunk */
					/* in whole data file. */
     int data_pos;			/* Position of this interpolation */
					/* time among data indices. */
{
  double v[3];
  int i;

  if(data_chunk < 3) {
     fprintf(stderr,"%s: data_chunk must be at least 3!\n", progname);
     exit(0);
    }

  for(i=0;i<3;++i) v[i] = in[1][i] - in[0][i];
  v[1] += 0.5 * A;
  for(i=0;i<3;++i) out[i] = in[0][i] + time*v[i];
  out[1] -= 0.5 * A * time * time; 
  for (i = 3; i < data_chunk; i++)
    out[i] = in[0][i];
}
