#include <stdio.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"

LinkButtonPress(gnrc,event)

LinkStatus *gnrc;
XEvent *event;

{
  int x,y,x1,y1,delta_x,delta_y;
  LinkPointList *pnt,*tmp_pnt,*prev_pnt;
  LinkCrossingList *crssng;
  LinkList *lnk;
  XEvent evnt;
  double temp,scale;
  int x0,y0,width,height;
  int xcoord,ycoord,xsize,ysize;
  Window root,child;  /* Junk for XQueryPointer */
  int root_x,root_y;
  unsigned int buttons;

  x = event->xbutton.x; y = event->xbutton.y;
  switch(gnrc->choice[0]) {

     case LINK_MOVE_POINT:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No point chosen. Try again.");
          break;
         }
       if((pnt = LinkFindPoint(gnrc,lnk,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No point chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       x1 = x; y1 = y;
       while(1) {
           if(XCheckMaskEvent(dpy,ButtonReleaseMask,&evnt)) break;
           /* Draw feedback line */
           if(XQueryPointer(dpy,gnrc->TopWindow,&root,&child,
                            &root_x,&root_y,&x1,&y1,&buttons)) {
              if(pnt->previous != &(lnk->point)) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                          pnt->previous->dcx,pnt->previous->dcy,x1,y1);
                }
              else if(lnk->closed) {
                      prev_pnt = &(lnk->point);
                      while(prev_pnt->next != NULL) prev_pnt = prev_pnt->next;
                      XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                             prev_pnt->dcx,prev_pnt->dcy,x1,y1);
                     }

              if(pnt->next != NULL) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                         pnt->next->dcx,pnt->next->dcy,x1,y1);
                }
              else if(lnk->closed) {
                      XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                         lnk->point.next->dcx,lnk->point.next->dcy,x1,y1);
                     }
              XFlush(dpy);
              LinkPause(LINK_PAUSE);
              if(pnt->previous != &(lnk->point)) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                          pnt->previous->dcx,pnt->previous->dcy,x1,y1);
                }
              else if(lnk->closed) {
                      prev_pnt = &(lnk->point);
                      while(prev_pnt->next != NULL) prev_pnt = prev_pnt->next;
                      XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                             prev_pnt->dcx,prev_pnt->dcy,x1,y1);
                     }

              if(pnt->next != NULL) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                         pnt->next->dcx,pnt->next->dcy,x1,y1);
                }
              else if(lnk->closed) {
                      XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                         lnk->point.next->dcx,lnk->point.next->dcy,x1,y1);
                     }
             }
          }
       x1 = evnt.xbutton.x; y1 = evnt.xbutton.y;
       pnt->dcx = x1; pnt->dcy = y1;
       LinkComputePointWorldCoords(gnrc,pnt);

       LinkReComputeEdgeCrossings(gnrc,lnk,pnt);
       if(pnt->previous != &(lnk->point))
          LinkReComputeEdgeCrossings(gnrc,lnk,pnt->previous);
       else
          if(lnk->closed) {  /* Recompute edge from last point */
             prev_pnt = &(lnk->point);
             while(prev_pnt->next != NULL) prev_pnt = prev_pnt->next;
             LinkReComputeEdgeCrossings(gnrc,lnk,prev_pnt);
            }

       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may move another point.");
       break;

     case LINK_ADD_POINT:
       LinkAddPoint(gnrc,x,y);
       break;

     case LINK_DELETE_POINT:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No point chosen. Try again.");
          break;
         }
       if((pnt = LinkFindPoint(gnrc,lnk,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No point chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       LinkDeletePoint(gnrc,lnk,pnt);

       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may delete another point.");
       break;

     case LINK_FLIP_CROSSING:
       if((crssng = LinkFindCrossing(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No crossing chosen. Try again.");
          break;
         }

       if(crssng->z > 0.0) {
          crssng->z = -1.0; crssng->crossing->z = 1.0;
         }
       else {
          crssng->z = 1.0; crssng->crossing->z = -1.0;
         }
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       
       LinkPrintMessage(gnrc,"You may flip another crossing.");
       break;

     case LINK_SELECT_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No link chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       
       LinkPrintMessage(gnrc,"You may select a different link.");
       break;

     case LINK_HIDE_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No link chosen. Try again.");
          break;
         }
       lnk->visible = LINK_HIDE; 
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       
       LinkPrintMessage(gnrc,"You may hide another strand.");
       break;

     case LINK_JOIN_SELECT_HEAD:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       if(lnk->closed) {
          LinkPrintMessage(gnrc,"Strand must be open.\n");
          break;
         }
       /* If user chose actual start, reverse link */
       if((pnt = LinkFindPoint(gnrc,lnk,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       if(pnt == lnk->point.next) {
          LinkReverseArrows(gnrc,lnk);
         }

       if(gnrc->current_link != lnk) {
          gnrc->current_link = lnk;
          XClearWindow(dpy,gnrc->TopWindow);
          ReDrawLinkTopWindow(gnrc);
         }
       gnrc->choice[0] = LINK_JOIN_SELECT_TAIL;
       LinkPrintMessage(gnrc,"Select start of second link.");
       break;

     case LINK_JOIN_SELECT_TAIL:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       if(lnk == gnrc->current_link) {
          LinkPrintMessage(gnrc,"Select strand other than current one.");
          break;
         }
       if(lnk->closed) {
          LinkPrintMessage(gnrc,"Strand must be open.\n");
          break;
         }
       /* if user chose actual end, reverse link */
       if((pnt = LinkFindPoint(gnrc,lnk,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       if(pnt != lnk->point.next) {  /* Check if last one chosen */
          tmp_pnt = &(lnk->point);
          while(tmp_pnt->next != NULL) tmp_pnt = tmp_pnt->next;
          if(tmp_pnt == pnt) LinkReverseArrows(gnrc,lnk);
         }
       LinkJoinLinks(gnrc,gnrc->current_link,lnk);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);

       gnrc->choice[0] = LINK_JOIN_SELECT_HEAD;
       LinkPrintMessage(gnrc,
                   "You may join two more strands. Select the first...");
       break;

     case LINK_REVERSE_ARROWS:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       LinkReverseArrows(gnrc,lnk);
       gnrc->current_link = lnk;
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may reverse another strand.");
       break;

     case LINK_OPEN_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       LinkOpenCurrentLink((VOID *) gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may open another strand.");
       break;

     case LINK_DELETE_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       LinkDeleteCurrentSelection((VOID *) gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may delete another strand.");
       break;

     case LINK_CLOSE_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       gnrc->current_link = lnk;
       LinkCloseCurrentLink((VOID *) gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may close another strand.");
       break;

     case LINK_TRANSLATE_LINK:
       if((lnk = LinkFindLink(gnrc,x,y)) == NULL) {
          LinkPrintMessage(gnrc,"No strand chosen. Try again.");
          break;
         }
       while(1) {
           if(XCheckMaskEvent(dpy,ButtonReleaseMask,&evnt)) break;
           /* Draw feedback link */
           if(XQueryPointer(dpy,gnrc->TopWindow,&root,&child,
                            &root_x,&root_y,&x1,&y1,&buttons)) {
              if((pnt = lnk->point.next) == NULL) continue;
              while(pnt->next != NULL) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                          pnt->dcx + x1-x,pnt->dcy + y1-y,
                          pnt->next->dcx + x1-x, pnt->next->dcy + y1-y);
                 pnt = pnt->next;
                }
              if(lnk->closed) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                     pnt->dcx + x1-x,pnt->dcy + y1-y,
                    lnk->point.next->dcx + x1-x, lnk->point.next->dcy + y1-y);
                }
              XFlush(dpy);
              LinkPause(LINK_PAUSE);
              if((pnt = lnk->point.next) == NULL) continue;
              while(pnt->next != NULL) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                          pnt->dcx + x1-x,pnt->dcy + y1-y,
                          pnt->next->dcx + x1-x, pnt->next->dcy + y1-y);
                 pnt = pnt->next;
                }
              if(lnk->closed) {
                 XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                     pnt->dcx + x1-x,pnt->dcy + y1-y,
                    lnk->point.next->dcx + x1-x, lnk->point.next->dcy + y1-y);
                }
             }
          }
       delta_x = evnt.xbutton.x - x; delta_y = evnt.xbutton.y - y;
       LinkDCTranslateLink(gnrc,lnk,delta_x,delta_y);
       gnrc->current_link = lnk;
       
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"Click and drag to translate another link.");
       break;

/***
     case LINK_ROTATE_LINK:
       break;
***/

     case LINK_SHIFT_VIEW:
       while(1) {
           if(XCheckMaskEvent(dpy,ButtonReleaseMask,&evnt)) break;
           /* Draw feedback line */
           if(XQueryPointer(dpy,gnrc->TopWindow,&root,&child,
                            &root_x,&root_y,&x1,&y1,&buttons)) {
              XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                          x,y,x1,y1);
              XFlush(dpy);
              LinkPause(LINK_PAUSE);
              XDrawLine(dpy,gnrc->TopWindow,gnrc->xor_gc,
                         x,y,x1,y1);

             }
          }
       delta_x = evnt.xbutton.x - x; delta_y = evnt.xbutton.y - y;
       gnrc->origin.dcx += delta_x; 
       gnrc->origin.dcy += delta_y;
       LinkComputeDeviceCoords(gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"Click and drag to shift view.");
       break;

     case LINK_ZOOM_VIEW:
       width = (int) ((double) (gnrc->width) * LINK_FEEDBACK_XFRACTION);
       height = (int) ((double) (gnrc->height) * LINK_FEEDBACK_YFRACTION);
       x0 = gnrc->width/2 - width/2;
       y0 = gnrc->height/2 - height/2;
       XDrawRectangle(dpy,gnrc->TopWindow,gnrc->gc,x0,y0,
                    width,height); 
       while(1) {
           if(XCheckMaskEvent(dpy,ButtonReleaseMask,&evnt)) break;
           /* Draw feedback rectangle */
           if(XQueryPointer(dpy,gnrc->TopWindow,&root,&child,
                            &root_x,&root_y,&x1,&y1,&buttons)) {

              xcoord = x0 - x1 + x;
              xsize = width + 2*(x1-x);
              if(xsize < 1) xsize = 1;
              scale =  (double) xsize/(double) width;

              ysize = (int) (0.5 + scale * (double) height);
              ycoord = gnrc->height/2 - ysize/2;
              if(ysize < 1) ysize = 1;

              XDrawRectangle(dpy,gnrc->TopWindow,gnrc->xor_gc,
                              xcoord,ycoord,xsize,ysize);
              XFlush(dpy);
              LinkPause(LINK_PAUSE);
              XDrawRectangle(dpy,gnrc->TopWindow,gnrc->xor_gc,
                              xcoord,ycoord,xsize,ysize);
             }
          }

       gnrc->xscale /= scale; 
       gnrc->yscale /= scale; 
       LinkComputeDeviceCoords(gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may zoom view again.");
       break;

/***

     case LINK_SCALE_LINK:
       while(1) {
           XNextEvent(dpy,&evnt);
           if(evnt.type == ButtonRelease) break;
          }
       temp = LINK_X_SCALE*(double) (evnt.xbutton.x - x)/xppmm; 
       xscale = (temp < 0) ? 1.0/(1.0-temp): 1.0 + temp;

       temp = LINK_Y_SCALE*(double) (y-evnt.xbutton.y)/yppmm;
       yscale = (temp < 0) ? 1.0/(1.0-temp): 1.0 + temp;
       pnt = gnrc->point.next;
       while(pnt != NULL) {
          pnt->x *= xscale; pnt->y *= yscale;
          pnt = pnt->next;
         }
       LinkComputeDeviceCoords(gnrc);
       XClearWindow(dpy,gnrc->TopWindow);
       ReDrawLinkTopWindow(gnrc);
       LinkPrintMessage(gnrc,"You may scale link again.");
       break;
*****/

    }
}
