#ifndef VOID
#define VOID void
#endif

#define BOX_NO 0
#define BOX_YES 1

#define BOX_PAD   2
#define BOX_BORDER   5

#define BOX_NORMAL_VIDEO   0
#define BOX_REVERSE_VIDEO  1

#define BOX_X_FRACTION 0.5
#define BOX_Y_FRACTION 0.5
#define BOX_X_OFFSET   0.1
#define BOX_Y_OFFSET   0.1

#define BOX_FOR_SHOW   0
#define BOX_MENU       1
#define BOX_TOGGLE     2
#define BOX_TEXT_ENTRY 3
#define BOX_HORIZONTAL_SLIDER 4
#define BOX_VERTICAL_SLIDER   5

#define BOX_FLASH_COUNT   10000

/*   Structures used */

struct box_attribute_list_struct {
  int id;
  GC gc,reverse_gc;
  XFontStruct *fontstruct;
  int fth,fg,bg,linewidth,linestyle;
  struct box_attribute_list_struct *next;
 };

typedef struct box_attribute_list_struct BoxAttributeList;

struct text_list_struct {
  char text[40];
  int x,y;
  BoxAttributeList *attr;
  struct text_list_struct *next;
 };

typedef struct text_list_struct TextList;

struct bitmap_list_struct {
  int type;
  int x,y,width,height;
  BoxAttributeList *attr;
  VOID *data;
  struct bitmap_list_struct *next;
 };

typedef struct bitmap_list_struct BitmapList;

struct design_list_struct {
  int type;
  int x,y;
  BoxAttributeList *attr;
  VOID *data;
  struct design_list_struct *next;
 };

typedef struct design_list_struct DesignList;


struct box_list_struct {
   int x,y,width,height;  /* Pixel coordinates */
   int type,id,generation,
       state,visible,border;
   int exclusive,always_visible,
       induce_state_change,cleanup,stop_cleanup;
   char key;

   struct box_list_struct *next,*parent,*child,
                          *sibling,*friend;

   VOID *data;
   double value;
   TextList prompt,dflt;
   TextList txt;
   BitmapList btmp;
   DesignList dsn;
   int (*local_callback)(),
       (*global_callback)(),
       (*continuous_local_callback)(),
       (*continuous_global_callback)();
   VOID *global_arg;  /* For global callbacks;if not NULL overrides gnrc->arg */
  };

typedef struct box_list_struct BoxList;
  

typedef struct {    /* Run time data */
  Window TopWindow;         /* Top level window */
  Window TitleWindow;       /* Title bar */
  Window MessageWindow;     /* For messages */
  Window UrgentWindow;      /* For urgent messages */
  char title[40];
  char message[80];
  GC gc,reverse_gc;
  XFontStruct *fontstruct;
  int fth;

  BoxList *select_box;       /* Selection triggering state change */ 
  BoxList box,*current_box;
  BoxAttributeList attribute,*current_attribute;
  VOID *arg;                 /* Global callback argument */
  int state_change;          /* Has state changed since last checked? */
  
 } BoxStatus;

typedef struct {   /* initialization data */
  char title[40];
  char message[80];
  char font[40];
  double x,y,width,height;   /* Size and offset in millimeters */ 
  Window root;
  int border;
  int title_present,message_present,urgent_present;
  int do_not_map;  /* Map TopWindow on initialization ? */

  VOID *arg;           /* Callback argument */
 } BoxData;

BoxList *FindBoxByPosition();
BoxList *FindBoxByID();
BoxAttributeList *FindBoxAttributeByID();

