#include <stdio.h>
#include <X11/Xlib.h>
#include "box_types.h"
#include "box_global.h"

BoxKeyPressEvent(gnrc,event)

BoxStatus *gnrc;
XEvent *event;

{
  char key,strng[2];

  if(XLookupString(&(event->xkey),strng,1,NULL,NULL) == 0) {
     BoxPrintMessage(gnrc,"Can't handle that key!");
     return(-1);
    }
  key = strng[0];
  BoxKeyPress(gnrc,key);
}

BoxKeyPress(gnrc,key)

BoxStatus *gnrc;
char key;

{
  BoxList *bx;

  if(gnrc->current_box->type == BOX_TEXT_ENTRY) {
     BoxTextEntryKey(gnrc,gnrc->current_box,key);
     /* Do continuous callbacks */
     bx = gnrc->current_box;
     if(bx->continuous_local_callback != NULL) 
           (*(bx->continuous_local_callback))(gnrc,bx);
     if(bx->continuous_global_callback != NULL) 
           (*(bx->global_callback))(gnrc->arg,(VOID *)gnrc,bx->id);
     return(0);
    }

  /* else check if keypress matches any valid box keycode */

  bx = gnrc->box.next;
  while(bx != NULL) {
     if(bx->key == key) {
        if(BoxIsValidChoice(gnrc,bx)) break;
       }
     bx = bx->next;
    }

  if(bx == NULL) {
     BoxPrintMessage(gnrc,"No valid choice with that keycode.");
     return(0);
    }
   if(bx->visible == BOX_NO && bx->always_visible == BOX_NO) {
     /* Can`t select with key an invisible box! */
     BoxPrintMessage(gnrc,"No valid choice with that keycode.");
     return(0);
    }
  BoxSelect(gnrc,bx);
}

BoxTextEntryKey(gnrc,bx,key)

BoxStatus *gnrc;
BoxList *bx;
char key;

{

  int pstn;
  char *strng;
  BoxList *child;

  if(bx->type != BOX_TEXT_ENTRY || bx->state != BOX_YES) return(0);

  strng = bx->dflt.text;
  pstn = strlen(strng);

  if((key >= 32) && (key <= 126)) {
     strng[pstn] = key; strng[pstn+1] = '\0';
     DrawBox(gnrc,bx);
    }

  if((key == 8) || (key == 127)) {
     if(pstn > 0) {
        strng[pstn-1] = '\0';
        DrawBox(gnrc,bx);
       }
    }

  if(key == '\r') {

     /* Do callbacks */
     if(bx->local_callback != NULL) {
        (*(bx->local_callback))(gnrc,bx);
       }
     if(bx->global_callback != NULL) {
        (*(bx->global_callback))(gnrc->arg,(VOID *)gnrc,bx->id);
       }

     /* draw children */
      child = bx->child;
      while(child != NULL) {
         child->visible = BOX_YES; DrawBox(gnrc,child);
         child = child->sibling;
        }

      if(bx->induce_state_change == BOX_YES) {
         gnrc->state_change = BOX_YES;
         gnrc->select_box = bx;
        }
      if(bx->cleanup == BOX_YES)  BoxCleanup(gnrc,bx);
    }
}

