/*
Initialize all parameters for a given dynamical system to be installed
Parameters are assigned to the default values before this program is called.
-----------------------------------------------------------------------
This is a GENERIC subroutine. If you want, you can change
the name string "userds1" to a proper one globally in this program
but then you need to change the same strings in the header file defining
the current class of dynamical systems.
*/

/*
Example 1: vector field with no periodic variable
*/

#include "model.h"

int userds1_init()
{

	/* title label */
	title_label = "Coupled Henon Map";

	/* mapping toggle: 1: map, 0: vector field */
	mapping_on = 1;
	/* inverse toggle: vector field: always 1,
	   maps: 1=explicit inverse is defined, 0=otherwise  */      /* mrm  (2/6/90) */
	inverse_on = 1;
	/* jacobian toggle: 1=Jacobian is explicitly given, 0=otherwise */
	fderiv_on = 0;
	/* polar toggle: 1=enable polar coordinate feature, 0=otherwise */
	enable_polar = 0;
	/* period toggle: 1=enable periodicity of phase space, 0=otherwise */
	enable_period = 0;

	/* phase space dimension */
	var_dim = 4;
	/* parameter space dimension */
	param_dim = 3;
	/* function space dimension */
	func_dim = 2;

	(void) malloc_init();

	/* primary phase space variable label (DIM=var_dim)*/
	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "u";
	var_label[3] = "v";
	/* parameter variable label (DIM=param_dim)*/
	param_label[0] = "b";
	param_label[1] = "k";
	param_label[2] = "c";
	/* function variable label (DIM=func_dim)*/
	func_label[0] = "Undefined";
	func_label[1] = "Undefined";

	/* starting parameter values (DIM=param_dim)*/
	param[0] = 0;
	param[1] = 1.3;
	param[2] = 0.01;

	/* starting primary phase space variable values (DIM=param_dim)*/
	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;

	/* starting bounds of parameter window box */
	param_min[0]= 0; param_max[0]= 1;
	param_min[1]= 0; param_max[1]= 5;
	param_min[1]= 0; param_max[1]= 1;

	/* starting bounds of primary phase space window box */
	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	/* dynamical system and function pointer assignments */
	f_p = userds1_f;
	func_p = userds1_func;
}
/*
second user dynamical system 
*/
	
int userds1_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	if(index==1){
		f[0] = -p[0] * x[1] - p[1] * x[0] - (1 + p[1]) * x[0] * x[0] + p[2] * x[2];;
		f[2] = -p[0] * x[3] - p[1] * x[2] - (1 + p[1]) * x[2] * x[2] + p[2] * x[0];;
		f[1] = x[0] + p[1] * f[0] + (1 + p[1]) * f[0] * f[0] - p[2] * f[2];;
		f[3] = x[2] + p[1] * f[2] + (1 + p[1]) * f[2] * f[2] - p[2] * f[0];;
	}
	else if (index==0){
		f[0] = -p[0] * x[1] - p[1] * x[0] - (1 + p[1]) * x[0] * x[0] + p[2] * x[2];;
		f[2] = -p[0] * x[3] - p[1] * x[2] - (1 + p[1]) * x[2] * x[2] + p[2] * x[0];;
		f[1] = x[0] + p[1] * f[0] + (1 + p[1]) * f[0] * f[0] - p[2] * f[2];;
		f[3] = x[2] + p[1] * f[2] + (1 + p[1]) * f[2] * f[2] - p[2] * f[0];;
	}
}
/*
second user function subroutine
*/

int userds1_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = 0;
	f[1] = 0;
}
