/*
### create panel for displaying system information ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include "../modellib/class_kaos_def.h"

void create_system_info_panel()
{
	int i,ipanel_row = 0,px,py;
	void     system_info_panel_quit_proc();
	extern Frame frame,system_info_frame;
	extern Panel system_info_panel;
	extern Pixfont *boldfont;
	extern Panel_item system_info_panel_quit_item,average_return_time_item, n_displayed_data0_item,n_displayed_data1_item;
	extern Panel_item *func_i_item,*func_f_item;
	extern short system_info_panel_show;
	extern int panel_colormap_on;
	extern int mapping_on,draw_all,more_digits_on,func_dim,p_l_margin,n_displayed_data1,n_displayed_data0;
	extern double average_return_time,*func_i,*func_f;
	extern char string[], string2[],**func_label;
	
	if(system_info_panel_show){
		window_set(system_info_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		system_info_panel_show = 1;
	px =  (int) window_get(frame,WIN_X) + 300;
	py =  (int) window_get(frame,WIN_Y);
	system_info_frame = window_create(frame, FRAME,
		FRAME_NO_CONFIRM, TRUE,
		FRAME_LABEL, "system-info",
		FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW, TRUE,
		WIN_X, px,
		WIN_Y, py,
		WIN_FONT, boldfont,
		0);
	if(system_info_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		system_info_panel_show = 0;
		return;
	}
	system_info_panel = window_create(system_info_frame, PANEL,
		WIN_FONT, boldfont,
		0);
	if(system_info_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_system_info_panel();
		return;
	}
	system_info_panel_quit_item = panel_create_item(system_info_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(system_info_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, system_info_panel_quit_proc,
		0);
	if(!mapping_on && !draw_all){
		sprintf(string, "%lg", average_return_time);
		average_return_time_item = panel_create_item(system_info_panel, PANEL_TEXT,
			PANEL_LABEL_X, ATTR_COL(30),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 11,
			PANEL_LABEL_STRING, "Return time:",
			0);
	}
	sprintf(string, "%d", n_displayed_data1);
	n_displayed_data1_item = panel_create_item(system_info_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_LABEL_STRING, "Displayed V:",
		0);
	sprintf(string, "%d", n_displayed_data0);
	n_displayed_data0_item = panel_create_item(system_info_panel, PANEL_TEXT,
		PANEL_LABEL_X, ATTR_COL(30),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_LABEL_STRING, "Displayed  P:",
		0);
	if(more_digits_on){
		for(i=0;i<func_dim;i++){
			sprintf(string, "%.14lg", func_i[i]);
			sprintf(string2, "%s_i:",func_label[i]);
			func_i_item[i] = panel_create_item(system_info_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 22,
				PANEL_LABEL_STRING, string2,
				0);
			sprintf(string, "%.14lg", func_f[i]);
			sprintf(string2, "%s_f:",func_label[i]);
			func_f_item[i] = panel_create_item(system_info_panel, PANEL_TEXT,
				PANEL_LABEL_X, ATTR_COL(42),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 22,
				PANEL_LABEL_STRING, string2, 
				0);
		}
	}
	else {
		for(i=0;i<func_dim;i++){
			sprintf(string, "%lg", func_i[i]);
			sprintf(string2, "%s_i:",func_label[i]);
			func_i_item[i] = panel_create_item(system_info_panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
				PANEL_LABEL_X, ATTR_COL(0),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 16,
				PANEL_LABEL_STRING, string2,
				0);
			sprintf(string, "%lg", func_f[i]);
			sprintf(string2, "%s_f:",func_label[i]);
			func_f_item[i] = panel_create_item(system_info_panel, PANEL_TEXT,
				PANEL_LABEL_X, ATTR_COL(30),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 16,
				PANEL_LABEL_STRING, string2, 
				0);
		}
	}
	window_fit(system_info_panel);
	window_fit(system_info_frame);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(system_info_panel,WIN_PIXWIN),"system_info_panel_cms");
}
