/*
### create panel for saving and loading data (interaction with on-line database) ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_save_load_panel()
{
	int i, ipanel_row = 0,px,py;
	void     save_load_panel_quit_proc();
	void     save_data_proc(), load_data_proc();
	void     save_option_proc();
	extern Frame frame,save_load_frame;
	extern Panel save_load_panel,system_info_panel;
	extern Pixfont *boldfont;
	extern Panel_item save_load_panel_quit_item,save_data_item,load_data_item;
	extern Panel_item save_option_item,file_name_item,dir_name_item;
	extern short save_load_panel_show;
	extern int panel_colormap_on;
	extern int p_l_margin, save_option;
	extern char dir_name[],file_name[];

	if(save_load_panel_show){
		window_set(save_load_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		save_load_panel_show = 1;
	px =  (int) window_get(frame,WIN_X);
	py =  (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT);
	if(py > 950 - 100)
		py = 950 - 100;
	save_load_frame = window_create(frame, FRAME,
		FRAME_NO_CONFIRM, TRUE,
		FRAME_LABEL, "save/load",
		FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW, TRUE,
		WIN_X, px,
		WIN_Y, py,
		WIN_FONT, boldfont,
		0);
	if(save_load_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		save_load_panel_show = 0;
		return;
	}
	save_load_panel = window_create(save_load_frame, PANEL,
		WIN_FONT, boldfont,
		0);
	if(save_load_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_save_load_panel();
		return;
	}
	save_load_panel_quit_item = panel_create_item(save_load_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(save_load_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, save_load_panel_quit_proc,
		0);
	save_data_item = panel_create_item(save_load_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(save_load_panel, "Save", 5, boldfont),
		PANEL_NOTIFY_PROC, save_data_proc,
		0);
	load_data_item = panel_create_item(save_load_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(save_load_panel, "Load", 5, boldfont),
		PANEL_NOTIFY_PROC, load_data_proc,
		0);
	save_option_item = panel_create_item(save_load_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Save Option:",
		PANEL_CHOICE_STRINGS,	"kaos: Window Environment Only (rw)",
					"kaos: 2-D Projected Data (rw)",
					"kaos: Full Data (rw)",
					"Non-kaos: 2-column Data (ro)",
					"Non-kaos: Full Data (ro)",
					"kaos+Extended: Window Environment only (rw)",
					"kaos+Extended: 2-D Projected Data (rw)",
					"kaos+Extended: Full Data (rw)",
					0,
		PANEL_VALUE, save_option,
		PANEL_NOTIFY_PROC, save_option_proc,
		0);
	file_name_item = panel_create_item(save_load_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, file_name,
		PANEL_VALUE_DISPLAY_LENGTH, 36,
		PANEL_LABEL_STRING, "File:",
		0);
	dir_name_item = panel_create_item(save_load_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, dir_name,
		PANEL_VALUE_DISPLAY_LENGTH, 36,
		PANEL_LABEL_STRING, "Dir:",
		0);
	window_fit(save_load_panel);
	window_fit(save_load_frame);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(save_load_panel,WIN_PIXWIN),"save_load_panel_cms");
}
