/*
### create main panel ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include "../modellib/class_kaos_def.h"

void create_main_panel()
{
	int i,px,py;
	int ipanel_row = 0;
	void main_panel_quit_proc(),reset_proc(),print_proc(),open_proc(),user_proc(),forward_proc(),backward_proc();
	void continue_proc(), batch_proc(),top_proc(),add_point_proc(),remove_point_proc();
	void model_proc(),button_event_proc();
	extern Frame frame,main_frame;
	extern Panel panel;
	extern Pixfont *boldfont;
	extern Panel_item quit_item,reset_item,print_item,open_item;
	extern Panel_item user_item,forward_item,backward_item;
	extern Panel_item continue_item,batch_item;
	extern Panel_item top_item,add_point_item,remove_point_item;
	extern Panel_item model_item;
	extern Panel_item *param_item,*var_i_item;
	extern Panel_item i_start_item,i_step_item,i_max_item;
	extern Panel_item time_step_item;
	extern short main_panel_show;
	extern int panel_colormap_on;
	extern int model,mapping_on,p_l_margin,p_b_margin,ycanvas,param_dim,mode,var_dim,i_start,i_max,i_step,more_digits_on;
	extern double time_step,*param,*win_var_i;
	extern char  string[],string2[];
	extern char **win_var_label,**param_label;

	if(main_panel_show){
		window_set(main_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		main_panel_show = 1;

	px =  (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH);
	if(px > 1152 - 200)
		px = 1152 - 200;
	py =  (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) - 380;
	if(py > 950 - 300)
		py = 950 - 300;

	main_frame = window_create(frame, FRAME,
		FRAME_LABEL, "main",
		FRAME_SHOW_LABEL, TRUE,
		FRAME_NO_CONFIRM, TRUE,
		WIN_X, px,
		WIN_Y, py, 
		WIN_SHOW, TRUE,
		WIN_FONT, boldfont,
		0);
	if(main_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		main_panel_show = 0;
		return;
	}
	/* Create and set panel */
	panel = window_create(main_frame, PANEL,
		WIN_FONT, boldfont,
		WIN_CONSUME_KBD_EVENTS, WIN_ASCII_EVENTS,WIN_TOP_KEYS,WIN_RIGHT_KEYS,0,
		0);
	if(panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_main_panel();
		return;
	}

	/* Create Panel_Button_items */
	quit_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Quit", 6, boldfont),
		PANEL_NOTIFY_PROC, main_panel_quit_proc,
		0);
	open_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Open", 6, boldfont),
		PANEL_EVENT_PROC, button_event_proc,
		PANEL_NOTIFY_PROC, open_proc,
		0);
	reset_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Reset", 6, boldfont),
		PANEL_NOTIFY_PROC, reset_proc,
		0);
	print_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Print", 6, boldfont),
		PANEL_NOTIFY_PROC, print_proc,
		0);
	batch_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Batch", 6, boldfont),
		PANEL_NOTIFY_PROC, batch_proc,
		0);
	top_item= panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Top", 6, boldfont),
		PANEL_NOTIFY_PROC, top_proc,
		0);
	forward_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Forw", 6, boldfont),
		PANEL_NOTIFY_PROC, forward_proc,
		0);
	backward_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Back", 6, boldfont),
		PANEL_NOTIFY_PROC, backward_proc,
		0);
	continue_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Cont", 6, boldfont),
		PANEL_NOTIFY_PROC, continue_proc,
		0);
	add_point_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Add pt", 6, boldfont),
		PANEL_NOTIFY_PROC, add_point_proc,
		0);
	remove_point_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Rm pt", 6, boldfont),
		PANEL_NOTIFY_PROC, remove_point_proc,
		0);
	user_item = panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "User", 6, boldfont),
		PANEL_NOTIFY_PROC, user_proc,
		0);

	/* Create PANEL_CYCLE_items */
	model_item = panel_create_item(panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_VALUE, model,
		PANEL_NOTIFY_PROC, model_proc,
		PANEL_LABEL_STRING, "Model:",
		PANEL_CHOICE_STRINGS, MODEL_LABELS,0,
		0);

	/* Create Panel_Text_items */
	if(more_digits_on){
		for (i = 0; i < param_dim; i++){
			sprintf(string, "%.14lg", param[i]);
			sprintf(string2, "%s:", param_label[i]);
			param_item[i] = panel_create_item(panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row + i / 2),
				PANEL_LABEL_X, ATTR_COL((i % 2) * 32),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 22,
				PANEL_LABEL_STRING, string2,
				0);
		}
	}
	else {
		for (i = 0; i < param_dim; i++){
			sprintf(string, "%lg", param[i]);
			sprintf(string2, "%s:", param_label[i]);
			param_item[i] = panel_create_item(panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row + i / 2),
				PANEL_LABEL_X, ATTR_COL((i % 2) * 24),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 15,
				PANEL_LABEL_STRING, string2,
				0);
		}
	}
	ipanel_row += (param_dim + 1) / 2;
	if(more_digits_on){
		for (i = 0; i < var_dim; i++){
			sprintf(string, "%.12lg", win_var_i[i]);
			sprintf(string2, "%s_i:", win_var_label[i]);
			var_i_item[i] = panel_create_item(panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row + i / 2),
				PANEL_LABEL_X, ATTR_COL((i % 2) * 32),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 22,
				PANEL_LABEL_STRING, string2,
				0);
		}
	}
	else {
		for (i = 0; i < var_dim; i++) {
			sprintf(string, "%lg", win_var_i[i]);
			sprintf(string2, "%s_i:", win_var_label[i]);
			var_i_item[i] = panel_create_item(panel, PANEL_TEXT,
				PANEL_LABEL_Y, ATTR_ROW(ipanel_row + i / 2),
				PANEL_LABEL_X, ATTR_COL((i % 2) * 24),
				PANEL_VALUE, string,
				PANEL_VALUE_DISPLAY_LENGTH, 15,
				PANEL_LABEL_STRING, string2,
				0);
		}
	}
	ipanel_row += (var_dim + 1) / 2;
	sprintf(string, "%d", i_start);
	i_start_item = panel_create_item(panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 9,
		PANEL_LABEL_STRING, "Start:",
		0);
	sprintf(string, "%d", i_max);
	i_max_item = panel_create_item(panel, PANEL_TEXT,
		PANEL_LABEL_X, ATTR_COL(24),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 9,
		PANEL_LABEL_STRING, "End:",
		0);
	sprintf(string, "%d", i_step);
	i_step_item = panel_create_item(panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_LABEL_STRING, "Step:",
		0);
	if(!mapping_on){
		sprintf(string, "%lg", time_step);
		time_step_item = panel_create_item(panel, PANEL_TEXT,
			PANEL_LABEL_X, ATTR_COL(24),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 11,
			PANEL_LABEL_STRING, "Time Step:",
			0);
	}
	window_fit(panel);
	window_fit(main_frame);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(panel,WIN_PIXWIN),"panel_cms");
}
