/*
### create a scanunov window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_scan_windows()
{
	void scan_quit_proc(),scan_go_proc(),scan_clear_proc(),scan_get_proc(),scan_show_proc();
	void scan_list_type_proc(),scan_algorithm_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,scan_frame;
	extern Panel scan_panel;
	extern Pixfont *boldfont;
	extern Panel_item scan_quit_item,scan_get_item,scan_go_item,scan_clear_item,scan_show_item;
	extern Panel_item scan_list_type_item,scan_algorithm_option_item,scan_n_stored_item;
	extern Panel_item scan_xgrid_item[];
	extern Panel_item scan_xmin_item[],scan_xmax_item[];
	extern short scan_panel_show;
	extern int panel_colormap_on;
	extern int scan_list_type,scan_grid_dim,scan_algorithm_option;
	extern int scan_mdim,scan_n_stored,scan_n_max;
	extern int scan_xgrid[];
	extern double scan_xmin[],scan_xmax[];
	extern char string[],string2[];
	
	/* Turn on the flag */	
	if(scan_panel_show){
		window_set(scan_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		scan_panel_show = 1;

	px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
	py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2;
	/* Create tser frame */
	scan_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "scan",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(scan_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		scan_panel_show = 0;
		return;
	}
	/* Create Panel */
	scan_panel = window_create(scan_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(scan_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_scan_windows();
		return;
	}
	/* Create panel items */
	scan_quit_item= panel_create_item(scan_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(scan_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, scan_quit_proc,
		0);
	scan_get_item= panel_create_item(scan_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(scan_panel, "Get", 5, boldfont),
		PANEL_NOTIFY_PROC, scan_get_proc,
		0);
	scan_go_item= panel_create_item(scan_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(scan_panel, "Go", 5, boldfont),
		PANEL_NOTIFY_PROC, scan_go_proc,
		0);
        scan_clear_item= panel_create_item(scan_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(scan_panel,"Clear",0,boldfont),
                PANEL_NOTIFY_PROC,scan_clear_proc,
                0);
        scan_show_item= panel_create_item(scan_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(scan_panel,"Show-Hide",0,boldfont),
                PANEL_NOTIFY_PROC, scan_show_proc,
                0);

	scan_list_type_item= panel_create_item(scan_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Scan List Type: ",
		PANEL_CHOICE_STRINGS,
			"A Point",
			"Line",
			"Rectagular Grid",
			"3-d Cube",
			"Tabulated list",
			0,
		PANEL_VALUE, scan_list_type,
		PANEL_NOTIFY_PROC, scan_list_type_proc,
		0);
	scan_algorithm_option_item= panel_create_item(scan_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Algorithm: ",
		PANEL_CHOICE_STRINGS,
			"Fft",
			"Lyapunov",
			"Dimension",
			"Auto Correlation",
			0,
		PANEL_VALUE, scan_algorithm_option,
		PANEL_NOTIFY_PROC, scan_algorithm_option_proc,
		0);
        
        sprintf(string,"%d",scan_n_stored);
        scan_n_stored_item= panel_create_item(scan_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 8,
                PANEL_LABEL_STRING, "# scanned pt:",
                0);
	for(i=0;i<scan_grid_dim;i++){
        	sprintf(string,"%d",scan_xgrid);
        	sprintf(string2,"# grid [%d]:",i);
        	scan_xgrid_item[i]= panel_create_item(scan_panel,PANEL_TEXT,
                	PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                	PANEL_LABEL_X,  ATTR_COL(0),
                	PANEL_VALUE,    string,
                	PANEL_VALUE_DISPLAY_LENGTH, 8,
                	PANEL_LABEL_STRING, string2,
                	0);
	}
	for(i=0;i<scan_grid_dim;i++){
		sprintf(string,"%.11lg",scan_xmin[i]);
		sprintf(string2,"min [%d]:",i);
		scan_xmin_item[i]= panel_create_item(scan_panel,PANEL_TEXT,
			PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X,  ATTR_COL(0),
			PANEL_VALUE,    string,
			PANEL_VALUE_DISPLAY_LENGTH, 14,
			PANEL_LABEL_STRING, string2,
			0);
		sprintf(string,"%.11lg",scan_xmax[i]);
		sprintf(string2,"max [%d]:",i);
		scan_xmax_item[i]=panel_create_item(scan_panel,PANEL_TEXT,
			PANEL_LABEL_X,  ATTR_COL(24),
			PANEL_VALUE,    string,
			PANEL_VALUE_DISPLAY_LENGTH, 14,
			PANEL_LABEL_STRING, string2,
			0);
	}
	window_fit(scan_panel);
	window_fit(scan_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(scan_panel,WIN_PIXWIN),"scan_panel_cms");
}
