
int taylorcouette_init()
{
	title_label = "D4 Symmetry Broken Oscillator - General";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	
	var_dim = 6;
	param_dim = 16;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x0";
	var_label[1] = "y0";
	var_label[2] = "x1";
	var_label[3] = "y1";
	param_label[0] = "cr1";
	param_label[1] = "cr2";
	param_label[2] = "pr1";
	param_label[3] = "pr2";
	param_label[4] = "crho";
	param_label[5] = "cn";
	param_label[6] = "c2";
	param_label[7] = "c3";
	param_label[8] = "prho";
	param_label[9] = "pn";
	param_label[10] = "p2";
	param_label[11] = "q2";
	param_label[12] = "p3";
	param_label[13] = "q3";
	param_label[14] = "mu1";
	param_label[15] = "mu2";
	func_label[0] = "t";
	func_label[1] = "~";

	param[0] = 2;
	param[1] = 0;
	param[2] = 0;
	param[3] = 0;
	param[4] = 0;
	param[5] = 0;
	param[6] = 0;
	param[7] = 0;
	param[8] = 0;
	param[9] = 0;
	param[10] = 0;
	param[11] = 0;
	param[12] = 0;
	param[13] = 0;
	param[14] = 0;
	param[15] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_i[4] = 0;
	var_i[5] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	param_min[4]= -5; param_max[4]= 5;
	param_min[5]= -5; param_max[5]= 5;
	param_min[6]= -5; param_max[6]= 5;
	param_min[7]= -5; param_max[7]= 5;
	param_min[8]= -5; param_max[8]= 5;
	param_min[9]= -5; param_max[9]= 5;
	param_min[10]= -5; param_max[10]= 5;
	param_min[11]= -5; param_max[11]= 5;
	param_min[12]= -5; param_max[12]= 5;
	param_min[13]= -5; param_max[13]= 5;
	param_min[14]= -5; param_max[14]= 5;
	param_min[15]= -5; param_max[15]= 5;
	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;
	var_min[4]= -5; var_max[4]= 5;
	var_min[5]= -5; var_max[5]= 5;
	func_min[0]= -5; func_max[0]= 5;

	f_p = taylorcouette_f;
	func_p = taylorcouette_func;
}
int taylorcouette_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double cr1,cr2,pr1,pr2,crho,cn,c2,c3,prho,pn,p2,q2,p3,q3,mu1,mu2;
	double x0,y0,x1,y1,x2,y2,dx0,dy0,dx1,dy1,dx2,dy2;
	double x0sq,x1sq,x0cub,x1cub,x2sq,x2cub,y0sq,y1sq,y2sq,y2cub,y0cub,y1cub;
	cr1 = p[0];
	cr2 = p[1];
	pr1 = p[2];
	pr2 = p[3];
	crho = p[4];
	cn = p[5];
	c2 = p[6];
	c3 = p[7];
	prho = p[8];
	pn = p[9];
	p2 = p[10];
	q2 = p[11];
	p3 = p[12];
	q3 = p[13];
	mu1= p[14];
	mu2 = p[15];
	x0 = x[0];
	y0 = x[1];
	x1 = x[2];
	y1 = x[3];
	x2 = x[4];
	y2 = x[5];
	x0sq=x0*x0;
	x1sq=x1*x1;
	x2sq=x2*x2;
	x0cub=x0*x0sq;
	x1cub=x1*x1sq;
	x2cub=x2*x2sq;
	y0sq=y0*y0;
	y1sq=y1*y1;
	y2sq=y2*y2;
	y0cub=y0*y0sq;
	y1cub=y1*y1sq;
	y2cub=y2*y2sq;

	dx0 = mu1*cr1*x0 + mu2*cr2*x0 + crho*x0cub +
	cn*x0*x1sq + c3*x0*x1*x2 + cn*x0*x2sq +
	c2*x1sq*y0 - c2*x2sq*y0 + crho*x0*y0sq
	+ c3*x2*y0*y1 + cn*x0*y1sq + c2*y0*y1sq -
	c3*x1*y0*y2 + c3*x0*y1*y2 + cn*x0*y2sq -
	c2*y0*y2sq;

	dy0 = -(c2*x0*x1sq) + c2*x0*x2sq + mu1*cr1*y0
	+ mu2*cr2*y0 + crho*x0sq*y0 + cn*x1sq*y0 -
	c3*x1*x2*y0 + cn*x2sq*y0 + crho*y0cub +
	c3*x0*x2*y1 - c2*x0*y1sq + cn*y0*y1sq -
	c3*x0*x1*y2 - c3*y0*y1*y2 + c2*x0*y2sq +
	cn*y0*y2sq;

	dx1 = mu1*pr1*x1 + mu2*pr2*x1 + prho*x0sq*x1 -
	p2*x1cub + pn*x1cub + p3*x0sq*x2 +
	p2*x1*x2sq + pn*x1*x2sq - 2*q3*x0*x2*y0 +
	prho*x1*y0sq - p3*x2*y0sq + q2*x1sq*y1
	- q2*x2sq*y1 - p2*x1*y1sq + pn*x1*y1sq
	+ q2*y1cub - q3*x0sq*y2 - 2*p3*x0*y0*y2 +
	q3*y0sq*y2 + p2*x1*y2sq + pn*x1*y2sq -
	q2*y1*y2sq;

	dy1 = -(q2*x1cub) + q3*x0sq*x2 +
	q2*x1*x2sq + 2*p3*x0*x2*y0
	- q3*x2*y0sq + mu1*pr1*y1 + mu2*pr2*y1 +
	prho*x0sq*y1 - p2*x1sq*y1 + pn*x1sq*y1
	+ p2*x2sq*y1 + pn*x2sq*y1 +
	prho*y0sq*y1 - q2*x1*y1sq - p2*y1cub +
	pn*y1cub + p3*x0sq*y2 - 2*q3*x0*y0*y2 -
	p3*y0sq*y2 + q2*x1*y2sq + p2*y1*y2sq
	+ pn*y1*y2sq;

	dx2 = p3*x0sq*x1 + mu1*pr1*x2 + mu2*pr2*x2 +
	prho*x0sq*x2 + p2*x1sq*x2 + pn*x1sq*x2
	- p2*x2cub + pn*x2cub + 2*q3*x0*x1*y0 -
	p3*x1*y0sq + prho*x2*y0sq - q3*x0sq*y1
	+ 2*p3*x0*y0*y1
	+ q3*y0sq*y1 + p2*x2*y1sq + pn*x2*y1sq
	- q2*x1sq*y2
	+ q2*x2sq*y2 - q2*y1sq*y2 - p2*x2*y2sq
	+ pn*x2*y2sq
	+ q2*y2cub;

	dy2 = q3*x0sq*x1 + q2*x1sq*x2 - q2*x2cub
	- 2*p3*x0*x1*y0 - q3*x1*y0sq + p3*x0sq*y1 +
	2*q3*x0*y0*y1 - p3*y0sq*y1 + q2*x2*y1sq +
	mu1*pr1*y2 + mu2*pr2*y2 + prho*x0sq*y2 +
	p2*x1sq*y2 + pn*x1sq*y2 - p2*x2sq*y2 +
	pn*x2sq*y2 + prho*y0sq*y2 + p2*y1sq*y2
	+ pn*y1sq*y2 - q2*x2*y2sq - p2*y2cub
	+ pn*y2cub;

	f[0]=dx0;
	f[1]=dy0;
	f[2]=dx1;
	f[3]=dy1;
	f[4]=dx2;
	f[5]=dy2;
}
int taylorcouette_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
}
