/*		###  Main program for kaos ###
--------------------------------------------------------------------------------

				kaos

		general purpose dynamical system toolkit

--------------------------------------------------------------------------------

			alpha test version 
	by Swan Kim and John Guckenheimer,POSTECH & Cornell U

	Copyright by the Authors. All rights reserved.
	A copy can be only obtained through authors. Though a modification
	to the package is allowed, a copy of the modified program
	should also be sent to authors with a note about changes.

--------------------------------------------------------------------------------

	First written by Swan Kim 3/30/1988.
	Modified by Swan Kim 4/29/1988.
	Modified by Swan Kim 4/30/1989. 
		Integrated functions to variables.
	Modified by Swan Kim 8/31/1989
		Introduced mapping forward and backward subroutines
		Introduced periodicity. Introduced function arrays.
		Beefed up the auxiliary windows.
		Installed notifier based piping.
	Modified by Swan Kim 10/31/1989
		Dynamic Memory allocation
		Division of phase space, parameter space, main panel windows
		Added AUTO ouput piping
		Installed Notifier based interrupt
		Set up the user supplied dynamical system facility
	Modified by Swan Kim 11/1/1989
		Added many symplectic integration schemes
		Overhauled batching routines
		Created printing window (can print both raster and postscript files)
	Modified by Swan Kim 11/10/1989
		Added general eigenvalue routines
		Extended the periodic orbit and manifold computation to arbitrary dimensions
		Added Help window
	Modified by Swan Kim 12/1/1989
		Created windows for Fourier Spectra,Lyapunov Exponents,Dimensions
		Partially installed a scan window
		Split main routine into a smaller modules.
--------------------------------------------------------------------------------
*/

#include "include/kaos.h"

main(argc,argv)
int argc;
char **argv;
{
	/* print a startup message on the screen */
	printf("\n");
	printf("%s\n",startup_message);
	printf("\n");

	/* reset a directory to a current working directory */
	(char *) getwd(dir_name);
	
	/* set a signal function */
	notify_set_signal_func(frame,my_signal_handler,SIGURG, NOTIFY_ASYNC);
		
	/* command line argument interpretation */
	(void) handle_command_line_args(argc,argv);

	/* initialization of the model */
	(void) initialize_model(model);

	/* reset all labels and window parameters */
	reset_params();

	/* initial memory allocations for kaos data */
	(void) alloc_memory();

	/* initialize the window configuration */
	window_init();
	
	/* get fonts */
	(void) get_fonts();

	/* Create Icon */
	icon = icon_create(ICON_IMAGE,&kaos_icon,0);

	/* Create a base frame*/
	(void) create_base_frame();
	
	/* Create a cursor */
	(void) create_base_cursor();
	
	/* create a base canvas */
	(void) create_base_canvas();

	/* initialize the color graphics on the base window */
	(void) initialize_graphics();

	/* create all menus */
	(void) create_all_menus();

	/* create a startup window configuration */
	(void) create_startup_windows();

	/* Transfer control to Notifier*/
	window_main_loop(frame);
}
