/*====================================================================
  Initial.c   This file contains the functions that build up the  
  the initial tetrahedron.
  ===================================================================*/

#include "structs.h"
#include "macros.h"

/*-----------------------------------------------------------------------
   Init_tet builds the initial tetrahedron.  It first finds 3 non-colinear
 points and makes a face out of them.   It next finds a fourth point that
 is not co-planar with the face.  The vertices are stored in the face
 structure in counter clockwise order so that the volume between the face
 and the point is negative. Lastly, the 3 newfaces to the fourth point
 are made and the data structures are cleaned up. 
 -----------------------------------------------------------------------*/
init_tet()
{
	register struct tvertex *v1, *v4, *t;
	register struct tface *f;
         	struct tface *make_face(), *make_structs();
	register struct tedge *e1, *e2, *e3, *s;
         	struct tedge *make_edge();
	double vol;
	
	v1 = vertices;

	/* find 3 non-colinear points */
	while ( co_linear( v1, v1->next, v1->next->next ) ) 
      	      if ( ( v1 = v1->next ) == vertices ) {
         	     printf("There are no 3 non-colinear points.\n");
         	     exit(0);
         	     } 
	
	/* mark the original vertices as used */
	v1->mark = MARKED;  v1->next->mark = MARKED; 
	v1->next->next->mark = MARKED;              
                                               
	/* make the edges of the original triangle */
	e1 = make_edge(); 
	e2 = make_edge();
	e3 = make_edge();
	e1->endpts[0] = v1;              e1->endpts[1] = v1->next;
	e2->endpts[0] = v1->next;        e2->endpts[1] = v1->next->next;
	e3->endpts[0] = v1->next->next;  e3->endpts[1] = v1;

	/* make the face of the original triangle */
	f = make_face();   
	f->edg[0] = e1;   f->edg[1] = e2;   f->edg[2] = e3;
	f->vert[0] = v1;  f->vert[1] = v1->next;
	f->vert[2] = v1->next->next;

	/* set the adjacent faces */
	e1->adjface[0] = e2->adjface[0] = e3->adjface[0] = f; 
	
	v4 = v1->next->next->next;
	pre_vol (f);
	
	/* find a fourth non-coplanar point */
	volume( vol, f, v4 );
	while ( vol <= 0.0 )   {
      		if ( ( v4 = v4->next ) == v1 ) {
         	       printf("There are no 4 non-coplanar points.\n");
         	       exit(0);
                       } 
       		volume( vol, f, v4 );
       	        }
	v4->mark = MARKED;

	/* store points in counter clockwise order */
	if( vol < 0 ) {
            swap( t, f->vert[0], f->vert[1] );
            swap( s, f->edg[1], f->edg[2] );
  	    }

	pre_vol( f );
	
	/* make the faces and edges between the original
   	   triangle and the fourth point. */
	e1->adjface[1] = make_structs( e1, v4 );
	e2->adjface[1] = make_structs( e2, v4 );
	e3->adjface[1] = make_structs( e3, v4 );
	
	clean_up();
	
	if ( debug )  print_out( v4 );
	
}
