/* ================================================================== 
    Data.c   This file contains the functions that take care of
    the data structures-  reading the information in, storing it,
    and printing it out.         
   ==================================================================*/

#include "structs.h"
#include "macros.h"

/*--------------------------------------------------------------------
     Read_vertices reads the vertices in and puts them in a circular,
  doubly linked list of tvertex structures.  The duplicate pointer is
  set to NULL and the active flag is set off.  
  --------------------------------------------------------------------*/ 
read_vertices()
{

	register struct tvertex *new;
	double x, y, z;

	while ( scanf ("%lf%lf%lf", &x, &y, &z ) != EOF )  {
                ALLOCATE( new, struct tvertex );
                new->v[X] = x;
                new->v[Y] = y;
                new->v[Z] = z;
                new->vnum = 0;
                new->duplicate = NULL;
                new->active = !ACTIVE;
                new->mark = !MARKED;
                ADD_QUEUE( vertices, new );
                }

}

/*--------------------------------------------------------------------
       Print prints the output in correct format.  It first determines
  the total number of vertices and prints that number out.  Then the
  x, y, and z coordinates of each vertex are printed.  Next it finds
  the total number of faces and then for each face it prints out the
  cooresponding vertices.  It also finds the total number of edges
  and calls the routines that check the number of edges and faces.
  --------------------------------------------------------------------*/
print()
{
	register struct tvertex *temp_v;
	register struct tface   *temp_f;
	register int i = 0, j = 0 ;

	printf("\n");
        /* total the vertices, then total the faces and print header line */
	temp_v = vertices; 
        temp_f = faces   ;
             do {                                 
                temp_v->vnum = i++;           
                temp_v = temp_v->next;
                } while ( temp_v != vertices );
             do {
                ++j;                              
                temp_f  = temp_f ->next;
                } while ( temp_f  != faces );
       	     printf("%d %d %d\n", i,j, (i+j-2)  );
        
	/* print the vertices and print out each face's vertices */
	temp_v = vertices; 
        temp_f = faces   ;
     	     do {                                 
                printf("%g %g %g\n", temp_v->v[X],
                         temp_v->v[Y], temp_v->v[Z] );
                temp_v = temp_v->next;
                } while ( temp_v != vertices );
             do {                           
                printf("3%5d%6d%6d\n", temp_f->vert[0]->vnum,
                        temp_f->vert[1]->vnum, temp_f->vert[2]->vnum );
                temp_f = temp_f->next;
                } while ( temp_f != faces );
}
