 /*=====================================================================
    Checks.c   This file is used whenever the test flag is set.
    These checks are done after the hull has been made.
   =====================================================================*/

#include "macros.h"
#include "structs.h"


/*------------------------------------------------------------------------
      Consistency runs through the edge list and checks that all
  adjacent faces have their endpoints in opposite order.  This verifies
  that the vertices are in counter clockwise order.
  -----------------------------------------------------------------------*/
consistency()
{
	register struct tedge *e;
	register int i, j;

	e = edges;

	do {
    	   /* find index of endpoint[0] in adjacent face[0] */
           for ( i = 0; e->adjface[0]->vert[i] != e->endpts[0]; ++i )
                 ;
   
   	   /* find index of endpoint[0] in adjacent face[1] */
   	   for ( j = 0; e->adjface[1]->vert[j] != e->endpts[0]; ++j )
         	 ;

           /* check if the endpoints occur in opposite order */
           if ( !( e->adjface[0]->vert[ (i+1) % 3 ] ==
                   e->adjface[1]->vert[ (j+2) % 3 ] ||
                   e->adjface[0]->vert[ (i+2) % 3 ] ==
                   e->adjface[1]->vert[ (j+1) % 3 ] )  )
               break;
           e = e->next;

           } while ( e != edges );

        if ( e != edges )
             fprintf( stderr, "Edges are NOT consistent.\n");

}

/*----------------------------------------------------------------------
       Convexity checks that the volume between every face and every
  point is negative.  This shows that each point is inside every face
  and therefore the hull is convex.
  ---------------------------------------------------------------------*/
convexity()
{
	register struct tface *f;
        register struct tvertex *v;
        int vol;

        f = faces;

        do {
              v = vertices;
              do {
                   volume( vol, f, v );
                   if ( vol < 0 )
                        break;
                   v = v->next;
                   } while ( v != vertices );
              if ( v != vertices )
                   break;
            } while ( f != faces );

        if ( f != faces )
           fprintf( stderr, "It is NOT convex.\n");
        
}

/*----------------------------------------------------------------------
     Check_faces checks that the number of faces is correct according
 to the number of vertices that are in the hull.
  ---------------------------------------------------------------------*/
check_faces(verts, faces )
int verts, faces;
{

	if ( faces != 2 * verts - 4 ) 
             fprintf( stderr, "The number of faces is NOT correct\n");

}

/*----------------------------------------------------------------------
      Check_edges checks that the number of edges is correct according
  to the number of  vertices that are in the hull.
  ---------------------------------------------------------------------*/
check_edges( verts, edges )
int verts, edges;
{

	if ( 2 * edges != 3 * verts ) 
	     fprintf( stderr, "The number of edges is NOT correct.\n");
}
/*-----------------------------------------------------------------------*/
checks()
{
	consistency();
	convexity();
}
