/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  main_draw.c: Functions to draw edges of planes.              */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "source/Hcad.h"
#include <stdio.h>

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : show_object(FILE *)

-------------------------------------------------------------*/
show_object(fp)
FILE *fp;
{
	int flg[4];

	if(fp!=0){
		fprintf(fp,"0.1 0.1 scale\n"); 
		if(pr_header == TRUE){
			fprintf(fp,"/Times-Bold findfont\n");
			fprintf(fp,"400 scalefont setfont\n");
			fprintf(fp,"2000 7000 moveto (H c a d 3 D) show\n");
			fprintf(fp,"/Times-BoldItalic findfont\n");
			fprintf(fp,"200 scalefont setfont\n");
			fprintf(fp,"1500 6600 moveto (File:%s%s) show\n",file_path,file_name);
		}
		flg[0] = disp_coord_flg;
		disp_coord_flg = pr_coord_flg;
		flg[1] = disp_unit_flg;
		disp_unit_flg = pr_unit_flg;
		flg[2] = shadow_flg;
		shadow_flg = pr_shadow_flg;
		flg[3] = draw_pattern;
		draw_pattern = print_pattern;
	}
	if(disp_coord_flg == TRUE){
		show_coordinate(fp);
	}
	if(disp_unit_flg == TRUE){ 
		show_unit_ball(fp);
	}
	if(shadow_flg == ON){
		draw_plane(fp);
	}
	if(draw_pattern != 4){  
		draw_line(fp);
	}
	if(fp!=0){
		disp_coord_flg = flg[0];
		disp_unit_flg = flg[1];
		shadow_flg = flg[2];
		draw_pattern = flg[3];
	}
}

/*------------------------------------------------------------

  Function : show_coordinate(FILE *)

-------------------------------------------------------------*/
show_coordinate(fp)
FILE *fp;
{
	int i,cx,cy;

	if(fp == 0){
		XSetLineAttributes(disp,dragc,0,LineOnOffDash,CapNotLast,JoinMiter);
		for(i=0;i<3;i++){
			cx = (int)(DR * coord[i].x * magnification);
			cy = (int)(DR * coord[i].y * magnification);
			XDrawLine(disp,drawin,dragc,DX + cx,DY - cy
			    ,DX - cx,DY + cy);
		}
		XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
	}
	else{
		for(i=0;i<3;i++){
			cx = (int)(PDR * coord[i].x * magnification);
			cy = (int)(PDR * coord[i].y * magnification);
			fprintf(fp,"newpath %d %d moveto %d %d lineto closepath\nstroke\n",
			PDX+cx,PDY+cy,PDX-cx,PDY-cy);
		}
	}
}



/*------------------------------------------------------------

  Function : show_unit_ball(FILE *)

-------------------------------------------------------------*/
show_unit_ball(fp)
FILE *fp;
{
	int rt;
	int ix,iy;

	if(fp==0){
		XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);

		rt = (int)(unit_ball.r * DR * magnification);
		ix = DX  - rt;
		iy = DY  - rt;

		XDrawArc(disp,drawin,dragc,ix,iy,2*rt,2*rt,0,360*64);
	}
	else{
		rt = (int)(unit_ball.r * PDR * magnification);
		fprintf(fp,"newpath %d 3800 moveto 2900 3800 %d 0 360 arc closepath\nstroke\n",
		PDX+rt,rt);
	}
}


/*------------------------------------------------------------

  Function : check_point(HPoint)

-------------------------------------------------------------*/
int check_point(pt)
HPoint pt;
{
	/*      Inside area return TRUE      */
	/*      Outside area return FALSE    */
	int i;
	double dis;

	if(pt.x*pt.x + pt.y*pt.y + pt.z*pt.z > 1.0+ZERO){
		return(FALSE);
	}
	for(i = 0;i<total_plane;i++){
		dis = sqrt(pow(plane[i].x-pt.x,2.0)+pow(plane[i].y-pt.y,2.0)+
		    pow(plane[i].z-pt.z,2.0));
		switch(plane[i].side)
		{
		case OUTSIDE:
			if(dis < plane[i].r - ZERO){
				return(FALSE);
			}
			break;
		case INSIDE:
			if(dis > plane[i].r + ZERO){
				return(FALSE);
			}
			break;
		default:
			break;
		}
	}
	return(TRUE);
}

/*------------------------------------------------------------

  Function : make_cross(HPoint *,int,int,int)
            
             plane[id1],plane[id2] and plane[id3] cross at pnt. 

-------------------------------------------------------------*/
int make_cross(pnt,id1,id2,id3)
HPoint *pnt;
int id1;
int id2;
int id3;
{
	double x1,x2,x3,y1,y2,y3,z1,z2,z3;
	double k1,k2;
	double a,b,a1,a2,b1,b2,c1,c2;
	HPoint p1,p2;
	int pat;

	x1 = plane[id1].x;
	y1 = plane[id1].y;
	z1 = plane[id1].z;

	x2 = plane[id2].x;
	y2 = plane[id2].y;
	z2 = plane[id2].z;

	x3 = plane[id3].x;
	y3 = plane[id3].y;
	z3 = plane[id3].z;

	a1 = x1 - x2;
	b1 = y1 - y2;
	c1 = z1 - z2;

	a2 = x1 - x3;
	b2 = y1 - y3;
	c2 = z1 - z3;

	if(fabs(b1 * c2 - b2 * c1) >= ZERO){
		pat = 1;
	}
	else{
		if(fabs(a2 * c1 - a1 * c2) >= ZERO){
			pat = 2;
		}
		else{
			pat = 3;
		}
	}
	switch(pat){
	case 1:
		k1 = (a2*c1 - a1*c2)/(b1*c2 - b2*c1);
		k2 = (a1*b2 - a2*b1)/(b1*c2 - b2*c1);
		/* a x^2 + b x - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = x2 + k1*y2 + k2*z2;

		if(b*b - a < 0.0){
			return(FALSE);
		}
		p1.x = (b + sqrt(b*b - a))/a;
		p1.y = k1 * p1.x;
		p1.z = k2 * p1.x;

		p2.x = (b - sqrt(b*b - a))/a;
		p2.y = k1 * p2.x;
		p2.z = k2 * p2.x;
		break;
	case 2:
		k1 = (b1*c2 - b2*c1)/(a2*c1 - a1*c2);
		k2 = (a1*b2 - a2*b1)/(a2*c1 - a1*c2);
		/* a y^2 + b y - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = k1*x2 + y2 + k2*z2;

		if(b*b - a < 0.0){
			return(FALSE);
		}
		p1.y = (b + sqrt(b*b - a))/a;
		p1.x = k1 * p1.y;
		p1.z = k2 * p1.y;

		p2.y = (b - sqrt(b*b - a))/a;
		p2.x = k1 * p2.y;
		p2.z = k2 * p2.y;
		break;

	case 3:
		k1 = (b1*c2 - b2*c1)/(a1*b2 - a2*b1);
		k2 = (a2*c1 - a1*c2)/(a1*b2 - a2*b1);
		/* a z^2 + b z - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = k1*x2 + k2*y2 + z2;

		if(b*b - a < 0.0){
			return(FALSE);
		}
		p1.z = (b + sqrt(b*b - a))/a;
		p1.x = k1 * p1.z;
		p1.y = k2 * p1.z;

		p2.z = (b - sqrt(b*b - a))/a;
		p2.x = k1 * p2.z;
		p2.y = k2 * p2.z;
		break;

	}

	if((p1.x*p1.x + p1.y*p1.y + p1.z*p1.z) <= 1.0){
		pnt->x = p1.x;
		pnt->y = p1.y;
		pnt->z = p1.z;
	}
	else{
		pnt->x = p2.x;
		pnt->y = p2.y;
		pnt->z = p2.z;
	}
	return(TRUE);
}

/*------------------------------------------------------------

  Function : unit_cross(HPoint *,HPoint *,int,int)

             plane[id1] and plane[id2] cross at pnt1 and pnt2 on S^3.
-------------------------------------------------------------*/
int unit_cross(pnt1,pnt2,id1,id2)
HPoint *pnt1;
HPoint *pnt2;
int id1;
int id2;
{
	double k1,k2,j1,j2;
	double a,b,c,a1,a2,b1,b2,c1,c2;
	HPoint p1,p2;
	int pat;

	a1 = plane[id1].x;
	b1 = plane[id1].y;
	c1 = plane[id1].z;

	a2 = plane[id2].x;
	b2 = plane[id2].y;
	c2 = plane[id2].z;

	if(fabs(b1 * c2 - b2 * c1) >= ZERO){
		pat = 1;
	}
	else{
		if(fabs(a2 * c1 - a1 * c2) >= ZERO){
			pat = 2;
		}
		else{
			pat = 3;
		}
	}
	switch(pat){
	case 1:
		k1 = (a2*c1 - a1*c2)/(b1*c2 - b2*c1);
		k2 = (a1*b2 - a2*b1)/(b1*c2 - b2*c1);
		j1 = (c2 - c1)/(b1*c2 - b2*c1);
		j2 = (b1 - b2)/(b1*c2 - b2*c1);
		/* a x^2 + b x - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = k1 * j1 + k2 * j2;
		c = j1*j1 + j2*j2 - 1.0;

		if(b*b - a*c < 0.0){
			return(FALSE);
		}
		p1.x = (-b + sqrt(b*b - a*c))/a;
		p1.y = k1 * p1.x + j1;
		p1.z = k2 * p1.x + j2;

		p2.x = (-b - sqrt(b*b - a*c))/a;
		p2.y = k1 * p2.x + j1;
		p2.z = k2 * p2.x + j2;
		break;
	case 2:
		k1 = (b1*c2 - b2*c1)/(a2*c1 - a1*c2);
		k2 = (a1*b2 - a2*b1)/(a2*c1 - a1*c2);
		j1 = (c1 - c2)/(a2*c1 - a1*c2);
		j2 = (a2 - a1)/(a2*c1 - a1*c2);
		/* a y^2 + b y - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = k1 * j1 + k2 * j2;
		c = j1*j1 + j2*j2 - 1.0;

		if(b*b - a*c < 0.0){
			return(FALSE);
		}
		p1.y = (-b + sqrt(b*b - a*c))/a;
		p1.x = k1 * p1.y + j1;
		p1.z = k2 * p1.y + j2;

		p2.y = (-b - sqrt(b*b - a*c))/a;
		p2.x = k1 * p2.y + j1;
		p2.z = k2 * p2.y + j2;
		break;

	case 3:
		k1 = (b1*c2 - b2*c1)/(a1*b2 - a2*b1);
		k2 = (a2*c1 - a1*c2)/(a1*b2 - a2*b1);
		j1 = (b2 - b1)/(a1*b2 - a2*b1);
		j2 = (a1 - a2)/(a1*b2 - a2*b1);
		/* a z^2 + b z - 1 = 0 */
		a = 1.0 + k1*k1 + k2*k2;
		b = k1 * j1 + k2 * j2;
		c = j1*j1 + j2*j2 - 1.0;

		if(b*b - a*c < 0.0){
			return(FALSE);
		}
		p1.z = (-b + sqrt(b*b - a*c))/a;
		p1.x = k1 * p1.z + j1;
		p1.y = k2 * p1.z + j2;

		p2.z = (-b - sqrt(b*b - a*c))/a;
		p2.x = k1 * p2.z + j1;
		p2.y = k2 * p2.z + j2;
		break;

	}
	pnt1->x = p1.x;
	pnt1->y = p1.y;
	pnt1->z = p1.z;
	pnt2->x = p2.x;
	pnt2->y = p2.y;
	pnt2->z = p2.z;
	return(TRUE);
}

/*------------------------------------------------------------

  Function : near_point(HPoint,HPoint)

-------------------------------------------------------------*/
int near_point(p1,p2)
HPoint p1;
HPoint p2;
{
	if(pow(p1.x-p2.x,2.0) + pow(p1.y-p2.y,2.0) + pow(p1.z-p2.z,2.0) < ZERO){
		return(TRUE);
	}
	else{
		return(FALSE);
	}
}

/*------------------------------------------------------------

  Function : point_to_up()
             Change p1 to p2.
             p1 is a coordinate in S^3.
             p2 is a coordinate in upper half space.
-------------------------------------------------------------*/
int point_to_up(p1,p2)
HPoint p1;
HPoint *p2;
{
	double k;

	if(fabs(1.0 - p1.z) < 0.000001){
		return(FALSE);
	}
	k = p1.x * p1.x + p1.y * p1.y + pow(1.0 - p1.z,2.0);
	p2->x = 2.0 * p1.x / k;
	p2->y = 2.0 * p1.y / k;
	p2->z = (1.0 - p1.x * p1.x - p1.y * p1.y - p1.z * p1.z)/k;
	return(TRUE);
}

/*------------------------------------------------------------

  Function : up_to_point()
             Change p1 to p2.
             p1 is a coordinate in upper half space.
             p2 is a coordinate in S^3.

-------------------------------------------------------------*/
int up_to_point(p1,p2)
HPoint p1;
HPoint *p2;
{
	double k;

	k = p1.x * p1.x + p1.y * p1.y + pow(1.0 + p1.z,2.0);
	p2->x = 2.0 * p1.x / k;
	p2->y = 2.0 * p1.y / k;
	p2->z = (p1.x * p1.x + p1.y * p1.y + p1.z * p1.z - 1.0)/k;
	return(TRUE);
}


/*------------------------------------------------------------

  Function : hyp_distance()
              
             Calculate a hyperbolic distance between p1 and p2.
             
-------------------------------------------------------------*/
double hyp_distance(p1,p2)
HPoint p1,p2;
{
	HPoint q1,q2,t1,t2,u1,u2;
	double cos1,sin1,dis;

	if((fabs(p1.x)>0.000001) || (fabs(p1.y)>0.000001)){
		q1.x = 0.0;
		q1.y = sqrt(p1.x * p1.x + p1.y * p1.y);
		q1.z = p1.z;
		cos1 = p1.y/q1.y;
		sin1 = p1.x/q1.y;
		q2.x = cos1 * p2.x - sin1 * p2.y;
		q2.y = sin1 * p2.x + cos1 * p2.y;
		q2.z = p2.z;
	}
	else{
		q1.x = 0.0;
		q1.y = 0.0;
		q1.z = p1.z;
		q2.x = p2.x;
		q2.y = p2.y;
		q2.z = p2.z;
	}   
	if((fabs(q1.y)>0.000001) || (fabs(q1.z)>0.000001)){
		t1.x = 0.0;
		t1.y = 0.0;
		t1.z = sqrt(q1.y * q1.y + q1.z * q1.z);
		cos1 = q1.z/t1.z;
		sin1 = q1.y/t1.z;
		t2.x = q2.x;
		t2.y = cos1 * q2.y - sin1 * q2.z;
		t2.z = sin1 * q2.y + cos1 * q2.z;
	}
	else{
		t1.x = 0.0;
		t1.y = 0.0;
		t1.z = 0.0;
		t2.x = q2.x;
		t2.y = q2.y;
		t2.z = q2.z;
	}   
	if(point_to_up(t1,&u1)==FALSE || point_to_up(t2,&u2) == FALSE){
		return(-1.0);
	}
	u2.x = u2.x / u1.z;
	u2.y = u2.y / u1.z;
	u2.z = u2.z / u1.z;
	up_to_point(u2,&t2);
	dis = sqrt(t2.x * t2.x + t2.y * t2.y + t2.z * t2.z);
	if(fabs(1.0-dis) < 0.000001){
		return(-1.0);
	}
	else{
		return(log((1.0 + dis)/(1.0 - dis)));
	}   
}
/*------------------------------------------------------------

  Function : make_line()

             Make edgees from planes' data.

-------------------------------------------------------------*/
int make_line(){

	int i,j,k,s,t,u;
	int near_flg;
	HPoint vt[CROSS_MAX];
	int vnum;
	int lnum = 0;
	HLine *lp;
	HPoint vect;
	double r1,k1,x1,x2,y1,y2,z1,z2,dist;
	double ang;

	/*-------------- Making p1,p2 ------------*/
	total_line = 0;
	for(i = 0;i<LINE_MAX;i++){
		line1[i].id = i;
	}
	for(i = 0;i < total_plane; i++){
		for(j = 0; j < CROSS_MAX; j++){
			if(plane[i].cross[j] == -1){
				break;
			}
			if(plane[i].cross[j] <= plane[i].id){
				continue;
			}
			k = plane[i].cross[j];
			vnum = 0;
			for(s = 0; s < CROSS_MAX; s++){
				if(plane[i].cross[s] == -1){
					break;
				}
				for(t = 0; t < CROSS_MAX; t++){
					if(plane[k].cross[t] == -1){
						break;
					}
					if(plane[i].cross[s] == plane[k].cross[t]){
						if(make_cross(&vt[vnum],i,k,plane[i].cross[s]) == TRUE){
							vnum++;
						}
					}
					if(vnum >= CROSS_MAX){
						total_line = 0;
						return(FALSE);
					}
				}
			}
			t = 0;
			for(s = 0;s<vnum;s++){
				if(check_point(vt[s]) == TRUE){
					vt[t].x = vt[s].x;
					vt[t].y = vt[s].y;
					vt[t].z = vt[s].z;
					t++;
				}
			}
			if((t == 2)&&(near_point(vt[0],vt[1])==FALSE)){
				line1[lnum].bip[0].x = vt[0].x;
				line1[lnum].bip[0].y = vt[0].y;
				line1[lnum].bip[0].z = vt[0].z;
				line1[lnum].bip[16].x = vt[1].x;
				line1[lnum].bip[16].y = vt[1].y;
				line1[lnum].bip[16].z = vt[1].z;
				line1[lnum].id1 = i;
				line1[lnum].id2 = k;
				total_line++;
				lnum++;
			}
			else{
				if(unit_cross(&vt[t],&vt[t+1],i,k)==TRUE){
					vnum = t+2;
				}
				t = 0;
				for(s = 0;s<vnum;s++){
					if(check_point(vt[s]) == TRUE){
						near_flg = FALSE;
						for(u = 0;u<t;u++){
							if(near_point(vt[u],vt[s])==TRUE){
								near_flg = TRUE;
							}
						}
						if(near_flg == FALSE){
							vt[t].x = vt[s].x;
							vt[t].y = vt[s].y;
							vt[t].z = vt[s].z;
							t++;
						}
					}
				}
				switch(t){
				case 2:
					line1[lnum].bip[0].x = vt[0].x;
					line1[lnum].bip[0].y = vt[0].y;
					line1[lnum].bip[0].z = vt[0].z;
					line1[lnum].bip[16].x = vt[1].x;
					line1[lnum].bip[16].y = vt[1].y;
					line1[lnum].bip[16].z = vt[1].z;
					line1[lnum].id1 = i;
					line1[lnum].id2 = k;
					total_line++;
					lnum++;
					break;

				case 3:
					line1[lnum].bip[0].x = vt[1].x;
					line1[lnum].bip[0].y = vt[1].y;
					line1[lnum].bip[0].z = vt[1].z;
					line1[lnum].bip[16].x = vt[2].x;
					line1[lnum].bip[16].y = vt[2].y;
					line1[lnum].bip[16].z = vt[2].z;
					line1[lnum].id1 = i;
					line1[lnum].id2 = k;
					total_line++;
					lnum++;
					break;

				case 4:
					line1[lnum].bip[0].x = vt[0].x;
					line1[lnum].bip[0].y = vt[0].y;
					line1[lnum].bip[0].z = vt[0].z;
					line1[lnum].bip[16].x = vt[1].x;
					line1[lnum].bip[16].y = vt[1].y;
					line1[lnum].bip[16].z = vt[1].z;
					line1[lnum].id1 = i;
					line1[lnum].id2 = k;
					total_line++;
					lnum++;
					break;
				default:
					break;

				}
			}
		}
	}
	line1[lnum].id1 = -1;
	line1[lnum].id2 = -1;

	/*---------------- Making pc pr --------------*/
	lp = &line1[0];
	for(i = 0;i<total_line;i++){
		x1 = plane[lp->id1].x;
		y1 = plane[lp->id1].y;
		z1 = plane[lp->id1].z;
		x2 = plane[lp->id2].x;
		y2 = plane[lp->id2].y;
		z2 = plane[lp->id2].z;

		vect.x = x2-x1;
		vect.y = y2-y1;
		vect.z = z2-z1;

		r1 = vect.x * vect.x + vect.y * vect.y + vect.z * vect.z;
		k1 = -(vect.x * x1 + vect.y * y1 + vect.z * z1)/r1;
		lp->pc.x = x1 + k1*vect.x;
		lp->pc.y = y1 + k1*vect.y;
		lp->pc.z = z1 + k1*vect.z;

		lp->pr = sqrt(pow(lp->pc.x - lp->bip[0].x,2.0) 
		    + pow(lp->pc.y - lp->bip[0].y,2.0)
		    +pow(lp->pc.z - lp->bip[0].z,2.0));

		lp++;
	}

	/* Making bip[17] pnum */
	lp = &line1[0];

	for(i = 0;i<total_line;i++){
		dist = sqrt(pow(lp->bip[0].x - lp->bip[16].x,2.0) 
		    + pow(lp->bip[0].y - lp->bip[16].y,2.0)
		    +pow(lp->bip[0].z - lp->bip[16].z,2.0)) * magnification; 
		if(dist>0.5){
			bisect(&(lp->bip[8]),lp->bip[0],lp->bip[16],lp->pc,lp->pr);
			bisect(&(lp->bip[4]),lp->bip[0],lp->bip[8],lp->pc,lp->pr);
			bisect(&(lp->bip[12]),lp->bip[8],lp->bip[16],lp->pc,lp->pr);
			bisect(&(lp->bip[2]),lp->bip[0],lp->bip[4],lp->pc,lp->pr);
			bisect(&(lp->bip[6]),lp->bip[4],lp->bip[8],lp->pc,lp->pr);
			bisect(&(lp->bip[10]),lp->bip[8],lp->bip[12],lp->pc,lp->pr);
			bisect(&(lp->bip[14]),lp->bip[12],lp->bip[16],lp->pc,lp->pr);
			bisect(&(lp->bip[1]),lp->bip[0],lp->bip[2],lp->pc,lp->pr);
			bisect(&(lp->bip[3]),lp->bip[2],lp->bip[4],lp->pc,lp->pr);
			bisect(&(lp->bip[5]),lp->bip[4],lp->bip[6],lp->pc,lp->pr);
			bisect(&(lp->bip[7]),lp->bip[6],lp->bip[8],lp->pc,lp->pr);
			bisect(&(lp->bip[9]),lp->bip[8],lp->bip[10],lp->pc,lp->pr);
			bisect(&(lp->bip[11]),lp->bip[10],lp->bip[12],lp->pc,lp->pr);
			bisect(&(lp->bip[13]),lp->bip[12],lp->bip[14],lp->pc,lp->pr);
			bisect(&(lp->bip[15]),lp->bip[14],lp->bip[16],lp->pc,lp->pr);

			lp->pnum = 17;
		}
		else{
			if(dist > 0.1){ 
				lp->bip[8].x = lp->bip[16].x;
				lp->bip[8].y = lp->bip[16].y;
				lp->bip[8].z = lp->bip[16].z;

				bisect(&(lp->bip[4]),lp->bip[0],lp->bip[8],lp->pc,lp->pr);
				bisect(&(lp->bip[2]),lp->bip[0],lp->bip[4],lp->pc,lp->pr);
				bisect(&(lp->bip[6]),lp->bip[4],lp->bip[8],lp->pc,lp->pr);
				bisect(&(lp->bip[1]),lp->bip[0],lp->bip[2],lp->pc,lp->pr);
				bisect(&(lp->bip[3]),lp->bip[2],lp->bip[4],lp->pc,lp->pr);
				bisect(&(lp->bip[5]),lp->bip[4],lp->bip[6],lp->pc,lp->pr);
				bisect(&(lp->bip[7]),lp->bip[6],lp->bip[8],lp->pc,lp->pr);
				lp->pnum = 9;
			}
			else{
				lp->bip[4].x = lp->bip[16].x;
				lp->bip[4].y = lp->bip[16].y;
				lp->bip[4].z = lp->bip[16].z;

				bisect(&(lp->bip[2]),lp->bip[0],lp->bip[4],lp->pc,lp->pr);
				bisect(&(lp->bip[1]),lp->bip[0],lp->bip[2],lp->pc,lp->pr);
				bisect(&(lp->bip[3]),lp->bip[2],lp->bip[4],lp->pc,lp->pr);
				lp->pnum = 5;
			}
		}
		lp++;
	}

	/*-------- Calculate angle and distance ----------*/
	lp = &line1[0];

	for(i = 0;i<total_line;i++){
		dist = sqrt(pow(plane[lp->id1].x - plane[lp->id2].x,2.0) 
		    +pow(plane[lp->id1].y - plane[lp->id2].y,2.0) 
		    +pow(plane[lp->id1].z - plane[lp->id2].z,2.0));
		ang = acos(-(pow(plane[lp->id1].r,2.0) + pow(plane[lp->id2].r,2.0)
		    - pow(dist,2.0))/(2.0 * plane[lp->id1].r * plane[lp->id2].r));
		lp->angle = 180.0 * ang / PIE;
		if(plane[lp->id1].side == INSIDE){
			lp->angle = 180.0 - lp->angle;
		}
		if(plane[lp->id2].side == INSIDE){
			lp->angle = 180.0 - lp->angle;
		}
		lp->length = hyp_distance(lp->bip[0],lp->bip[16]);
		lp++;
	}     
	if(select_line >= total_line){
		select_l_flg = OFF;
		select_line = -1;
	}
	return(TRUE);
}



/*------------------------------------------------------------

  Function : search_cross()
             
-------------------------------------------------------------*/
int search_cross(){
	int i,j,cnt;
	double dis;

	for(i = 0;i<total_plane;i++){
		cnt = 0;
		for(j = 0;j<total_plane;j++){
			if(i != j){
				dis = sqrt(pow(plane[i].x-plane[j].x,2.0)+pow(plane[i].y-plane[j].y,2.0)+
				    pow(plane[i].z-plane[j].z,2.0));
				if((dis > ZERO)&&(dis < (plane[i].r + plane[j].r))){
					plane[i].cross[cnt] = plane[j].id;
					cnt++;
				}
			}
			if(cnt >= CROSS_MAX){
				return(FALSE);
			}
		}
		plane[i].cross[cnt] = -1;
	}
	if(make_line()==FALSE){
		return(FALSE);
	}
	return(TRUE);
}


/*------------------------------------------------------------

  Function : bisect(HPoint *,HPoint,HPoint,HPoint,double)

-------------------------------------------------------------*/
bisect(pnt,p1,p2,pc,r)
HPoint *pnt;
HPoint p1;
HPoint p2;
HPoint pc;
double r;
{
	double k,dv;
	HPoint vec1,vec2;

	vec1.x = p1.x - pc.x;
	vec1.y = p1.y - pc.y;
	vec1.z = p1.z - pc.z;
	vec2.x = p2.x - pc.x;
	vec2.y = p2.y - pc.y;
	vec2.z = p2.z - pc.z;

	dv = sqrt(pow(vec1.x + vec2.x,2.0) + pow(vec1.y + vec2.y,2.0)
	    + pow(vec1.z + vec2.z,2.0));

	k =  r / dv;
	pnt->x = pc.x + k*(vec1.x + vec2.x);
	pnt->y = pc.y + k*(vec1.y + vec2.y);
	pnt->z = pc.z + k*(vec1.z + vec2.z);
}

/*------------------------------------------------------------

  Function : check_hide(HPoint *)

-------------------------------------------------------------*/
int check_hide(pt)
HPoint *pt;
{
	int i;
	double b,c,x2,y2,z2,k1,k2,dt;
	HPoint cp;

	dt = pt->x * pt->x + pt->y * pt->y + pt->z * pt->z;
	for(i = 0; i<total_plane; i++){
		x2 = plane[i].x;
		y2 = plane[i].y;
		z2 = plane[i].z;
		b = (pt->x - x2)*view_vect.x + (pt->y - y2)*view_vect.y 
		    + (pt->z - z2)*view_vect.z;
		c =  dt - 2.0 * (pt->x * x2 + pt->y * y2 + pt->z * z2) + 1.0;

		if(b*b - c < 0.0){
			continue;
		}
		k1 = -b + sqrt(b*b - c);
		k2 = -b - sqrt(b*b - c);
		if((k1>=ZERO)&&(k1<=2.0)){
			cp.x = pt->x + k1 * view_vect.x;
			cp.y = pt->y + k1 * view_vect.y;
			cp.z = pt->z + k1 * view_vect.z;
			if(check_point(cp) == TRUE){
				return(FALSE);
			}
		}
		if((k2>=ZERO)&&(k2<=2.0)){
			cp.x = pt->x + k2 * view_vect.x;
			cp.y = pt->y + k2 * view_vect.y;
			cp.z = pt->z + k2 * view_vect.z;
			if(check_point(cp) == TRUE){
				return(FALSE);
			}
		}
	}
	return(TRUE);
}


/*------------------------------------------------------------

  Function : draw_segments(HPoint *,int,int)

-------------------------------------------------------------*/
draw_segments(pnt,num,width)
HPoint *pnt;
int num;
int width;
{
	XPoint dp[20];
	XPoint *dptr;
	int hd[20];
	int cnt;
	int i;
	int hflg = FALSE;

	for(i = 0;i<num;i++){
		hd[i] = check_hide(pnt);
		dp[i].x = (int)(DR * (coord[0].x * pnt->x + coord[1].x * pnt->y 
		    + coord[2].x * pnt->z) * magnification) + DX;
		dp[i].y = (int)(-DR * (coord[0].y * pnt->x + coord[1].y * pnt->y 
		    + coord[2].y * pnt->z) * magnification) + DY;

		pnt++;
	}
	if(draw_pattern == 1){
		XSetLineAttributes(disp,dragc,width,LineSolid,CapNotLast,JoinMiter);
		XDrawLines(disp,drawin,dragc,dp,num,CoordModeOrigin);
		XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
	}
	else{
		dptr = &dp[0];
		cnt = 1;
		if(hd[0] * hd[1] == TRUE){
			hflg = TRUE;
		}
		for(i = 0;i<num-1;i++){
			switch(hflg){
			case TRUE:
				if(hd[i]*hd[i+1] == FALSE){
					XSetLineAttributes(disp,dragc,width,LineSolid,CapNotLast,JoinMiter);
					XDrawLines(disp,drawin,dragc,dptr,cnt,CoordModeOrigin);
					XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
					dptr = &dp[i];
					cnt = 2;
					hflg = FALSE;
				}
				else{
					cnt++;
				}
				break;

			case FALSE:
				if(hd[i]*hd[i+1] == TRUE){
					if(draw_pattern == 2){
						XSetLineAttributes(disp,dragc,width,LineOnOffDash
						    ,CapNotLast,JoinMiter);
						XDrawLines(disp,drawin,dragc,dptr,cnt,CoordModeOrigin);
						XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
					}
					dptr = &dp[i];
					cnt = 2;
					hflg = TRUE;
				}
				else{
					cnt++;
				}
				break;
			}
		}
		if(hflg == TRUE){
			XSetLineAttributes(disp,dragc,width,LineSolid,CapNotLast,JoinMiter);
			XDrawLines(disp,drawin,dragc,dptr,cnt,CoordModeOrigin);
			XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
		}
		else{
			if(draw_pattern == 2){
				XSetLineAttributes(disp,dragc,width,LineOnOffDash,CapNotLast,JoinMiter);
				XDrawLines(disp,drawin,dragc,dptr,cnt,CoordModeOrigin);
				XSetLineAttributes(disp,dragc,0,LineSolid,CapNotLast,JoinMiter);
			}
		}
	}
}

/*------------------------------------------------------------

  Function : print_segments(FILE *,HPoint *,int)

-------------------------------------------------------------*/
print_segments(fp,pnt,num)
FILE *fp;
HPoint *pnt;
int num;
{
	XPoint dp[20];
	XPoint *dptr;
	int hd[20];
	int cnt;
	int i,j;
	int hflg = FALSE;

	for(i = 0;i<num;i++){
		hd[i] = check_hide(pnt);
		dp[i].x = (int)(PDR * (coord[0].x * pnt->x + coord[1].x * pnt->y 
		    + coord[2].x * pnt->z) * magnification) + PDX;
		dp[i].y = (int)(PDR * (coord[0].y * pnt->x + coord[1].y * pnt->y 
		    + coord[2].y * pnt->z) * magnification) + PDY;

		pnt++;
	}
	if(draw_pattern == 1){
		fprintf(fp,"newpath %d %d moveto\n",dp[0].x,dp[0].y);
		for(i = 1;i<num;i++){    
			fprintf(fp,"%d %d lineto\n",dp[i].x,dp[i].y); 
		}
		fprintf(fp,"stroke\n");
	}
	else{
		dptr = &dp[0];
		cnt = 1;
		if(hd[0] * hd[1] == TRUE){
			hflg = TRUE;
		}
		for(i = 0;i<num-1;i++){
			switch(hflg){
			case TRUE:
				if(hd[i]*hd[i+1] == FALSE){
					fprintf(fp,"newpath %d %d moveto\n",dptr->x,dptr->y);
					for(j = 1;j<cnt;j++){
						dptr++;
						fprintf(fp,"%d %d lineto\n",dptr->x,dptr->y); 
					}
					fprintf(fp,"stroke\n");
					dptr = &dp[i];
					cnt = 2;
					hflg = FALSE;
				}
				else{
					cnt++;
				}
				break;

			case FALSE:
				if(hd[i]*hd[i+1] == TRUE){
					if(draw_pattern == 2){
						fprintf(fp,"[30] 0 setdash\nnewpath %d %d moveto\n"
						    ,dptr->x,dptr->y);
						for(j = 1;j<cnt;j++){
							dptr++;
							fprintf(fp,"%d %d lineto\n",dptr->x,dptr->y); 
						}
						fprintf(fp,"stroke\n[] 0 setdash\n");
					}
					dptr = &dp[i];
					cnt = 2;
					hflg = TRUE;
				}
				else{
					cnt++;
				}
				break;
			}
		}
		if(hflg == TRUE){
			fprintf(fp,"newpath %d %d moveto\n",dptr->x,dptr->y);
			for(j = 1;j<cnt;j++){
				dptr++;
				fprintf(fp,"%d %d lineto\n",dptr->x,dptr->y); 
			}
			fprintf(fp,"stroke\n");
		}
		else{
			if(draw_pattern == 2){
				fprintf(fp,"[30] 0 setdash\nnewpath %d %d moveto\n"
				    ,dptr->x,dptr->y);
				for(j = 1;j<cnt;j++){
					dptr++;
					fprintf(fp,"%d %d lineto\n",dptr->x,dptr->y); 
				}
				fprintf(fp,"stroke\n[] 0 setdash\n");
			}
		}
	}
}

/*------------------------------------------------------------

  Function : draw_line(FILE *)

-------------------------------------------------------------*/
draw_line(fp)
FILE *fp;
{
	HLine *lp;
	HPoint pnt[20];
	int i;
	int width = NONSELECT;
	double dist;

	lp = &line1[0];

	for(i = 0;i<total_line;i++){
		width = NONSELECT;
		if(select_flg == ON){
			if((select_plane == lp->id1)||(select_plane == lp->id2)){
				width = SELECT_WID;
			}
		}
		if(select_l_flg == ON){
			if(select_line == lp->id){
				width = SELECT_WID;
			}
		}
		if(fp == 0){
			draw_segments(&(lp->bip[0]),lp->pnum,width);
		}
		else{
			print_segments(fp,&(lp->bip[0]),lp->pnum);
		}
		lp++;
	}
}






















