/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  Hcadext.h: Header file for external variable.                */
/*                                                               */
/*                                                               */
/*****************************************************************/

/*** Global variable for window ***/
extern Display      *disp;                   /* display */

extern Window       basewin;                 /* base window */
extern Window       drawin;                  /* window for drawing   */
extern Window       menubar;                 /* menu bar window*/
extern Window       menuwin;                 /* menu window */
extern Window       sub_menuwin;             /* sub menu window */
extern GC           dragc;                   /* graphics context for drawing window */
extern GC           menubargc;               /* graphics context for menu bar window */
extern GC           menugc;                  /* graphics context for menu window */
extern GC           sub_menugc;              /* graphics context for sub menu window */
extern GC           norm_gc;      /* GC - Foreground black,Background white */
extern GC           invert_gc;    /* GC - Foreground white,Background black */
extern XSizeHints   basehint;                /* base window size */
extern XSizeHints   drahint;                 /* drawing window size */
extern XSizeHints   menubarhint;             /* menu bar window size */
extern XSizeHints   menuhint;                /* menu window size */
extern XSizeHints   sub_menuhint;            /* sub menu window size */
extern XEvent       ev;                      /* event */
extern Pixmap       curmap[8];               /* Pixmap for cursor */
extern Pixmap       gray[10];                /* Pixmap for gray level */

extern Font         font;
extern int          font_flg;
extern int          done;                    /* flag for main loop */
extern HPlane       plane[PLANE_MAX];        /* Hyperbolic planes */
extern HLine        line1[LINE_MAX];         /* Edges */
extern HPlane       unit_ball;               /* Unit ball */
extern Cursor       cur[8];                  /* Cursor */
extern KeySym       mykey;                   /* Key symbol */
extern unsigned long white;                  /* White Color */
extern unsigned long black;                  /* Black Color */

/*** Global variable for drawing */
extern int          total_plane;             /* total plane number */
extern int          total_line;              /* total line number */
extern HPoint       coord[3];                /* unit vector */
extern int          indata_style;            /* data input style */

extern int          disp_coord_flg;          /* flag for displaying coordinate */
extern int          pr_coord_flg;            /* flag for printing coordinate */
extern int          disp_unit_flg;           /* flag for displaying unit ball */
extern int          pr_unit_flg;             /* flag for printing unit ball */
extern int          draw_pattern;            /* flag for drawing pattern */
extern int          print_pattern;           /* flag for printing pattern */
extern int          shadow_flg;              /* flag for shadow */
extern int          pr_shadow_flg;           /* flag for printing shadow */
extern int          pr_header;               /* flag for printing header */
extern double       rotation_angle;          /* angle of rotation */
extern double       magnification;           /* magnification */
extern double       cosin[12],sine[12];      /* array of sin cos */
extern HPoint       view_vect;               /* direction of view */
extern int          select_plane;            /* selecting plane */
extern int          select_flg;              /* flag for selecting */
extern int          select_line;             /* selecting line */
extern int          select_l_flg;            /* flag for selecting line */

/*  File  */
extern char         file_name[NAME_MAX];            /* editing file name*/
extern char         ps_file[NAME_MAX];              /* postscript file name*/
extern char         file_path[NAME_MAX];            /* path for edit file */
extern char         work_path[NAME_MAX];            /* path for work file */
extern char         print_com[NAME_MAX];            /* command of printing */
extern char         demo_path[NAME_MAX];            /* path for demo file */

/* menu name */
extern char         *menu_name[MENU_MAX];
extern char         *submenu_name[MENU_MAX][SUBMENU_MAX];

