/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import jde.debugger.Debug;
import jde.debugger.DebuggeeProcess;
import jde.debugger.DebuggeeSIO;
import jde.debugger.JDEException;
import jde.debugger.command.DebugSessionCommand;

public class LaunchApplication
extends DebugSessionCommand {
    public void doCommand() throws JDEException {
        String connectSpec = "com.sun.jdi.CommandLineLaunch";
        LaunchingConnector connector = (LaunchingConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
        Connector.Argument mainArg = argumentMap.get("main");
        String commandLine = "";
        String quote = argumentMap.get("quote").value();
        if (this.args.size() == 0) {
            throw new JDEException("Insufficient arguments");
        }
        String executable = "java";
        while (this.args.size() > 0 && this.args.get(0).toString().startsWith("-")) {
            String arg = this.args.remove(0).toString().toLowerCase();
            if (arg.equals("-vmexec")) {
                if (this.args.size() == 0) {
                    throw new JDEException("Missing argument to 'use_executable'");
                }
                executable = this.args.remove(0).toString();
                Connector.Argument vmexecArg = argumentMap.get("vmexec");
                vmexecArg.setValue(executable);
                continue;
            }
            if (arg.equals("-home")) {
                if (this.args.size() == 0) {
                    throw new JDEException("Missing argument to 'home'");
                }
                String home = this.args.remove(0).toString();
                Connector.Argument homeArg = argumentMap.get("home");
                homeArg.setValue(home);
                continue;
            }
            this.args.add(0, arg);
            break;
        }
        if (this.args.size() == 0) {
            throw new JDEException("Missing arguments: no class specified?");
        }
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.equalsIgnoreCase("-classic")) {
                Connector.Argument optionsArg = argumentMap.get("options");
                String options = optionsArg.value();
                options = "-classic " + options;
                optionsArg.setValue(options);
                this.jde.signal(this.procID, "message", "VM options: '" + options + "'");
                continue;
            }
            commandLine = commandLine + quote + arg + quote + " ";
        }
        mainArg.setValue(commandLine);
        VirtualMachine vm = null;
        try {
            vm = connector.launch(argumentMap);
            this.jde.signal(this.procID, "message", "Launched VM " + vm.description());
        }
        catch (IOException ex) {
            Debug.printIf(ex);
            throw new JDEException("Unable to launch: " + ex.toString().replace('\\', '/'));
        }
        catch (IllegalConnectorArgumentsException ex) {
            throw new JDEException("Invalid or inconsistent connector arguments for connector '" + connector + "'");
        }
        catch (VMStartException ex) {
            throw new JDEException(ex.getMessage().toString().replace('\\', '/'));
        }
        DebuggeeProcess proc = new DebuggeeProcess(this.procID, vm);
        if (this.procRegistry.processExists(this.procID)) {
            proc.shutdown();
            throw new JDEException("An application with the same ID exists.");
        }
        this.procRegistry.addProcess(this.procID, proc);
        DebuggeeSIO procSIO = proc.getSIO();
        int port = procSIO.initConnect(this.cmdID);
    }

    public Object clone() {
        return new LaunchApplication();
    }
}

