/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JdeUtilities {
    private static Hashtable projectCache = new Hashtable();
    private static String currentProjectName = "default";

    public static void setProjectValues(String projectName, String projectClassPath) {
        currentProjectName = projectName;
        CacheEntry ce = (CacheEntry)projectCache.get(projectName);
        if (ce == null) {
            ce = new CacheEntry(projectClassPath);
            projectCache.put(projectName, ce);
        } else if (!ce.classPath.equals(projectClassPath)) {
            ce.classPath = projectClassPath;
            ce.dirty = true;
        }
    }

    public static String getCurrentProjectName() {
        return currentProjectName;
    }

    public static String getCurrentClassPath() {
        return JdeUtilities.getClassPath(currentProjectName);
    }

    public static String getClassPath(String projectName) {
        CacheEntry ce = (CacheEntry)projectCache.get(projectName);
        return ce.classPath;
    }

    public static Vector getCurrentClassList() {
        return JdeUtilities.getClassList(currentProjectName);
    }

    public static Vector getClassList(String projectName) {
        CacheEntry ce = (CacheEntry)projectCache.get(projectName);
        JdeUtilities.buildClassList(false);
        return ce.classList;
    }

    public static void classExists(String fqn) {
        try {
            Class.forName(fqn);
            System.out.println("t");
        }
        catch (NoClassDefFoundError ex1) {
            System.out.println("nil");
        }
        catch (Exception ex2) {
            System.out.println("nil");
        }
    }

    public static void buildClassList(boolean force) {
        String classPathSeparator = File.pathSeparator;
        CacheEntry ce = (CacheEntry)projectCache.get(currentProjectName);
        String classPath = ce.classPath;
        Vector classList = ce.classList;
        boolean dirty = ce.dirty;
        if (force || dirty || classList.size() == 0) {
            StringTokenizer st;
            String extDirs;
            classList.setSize(0);
            String classPath2 = System.getProperty("sun.boot.class.path");
            if (classPath2 != null) {
                classPath = classPath + classPathSeparator + classPath2;
            }
            if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
                st = new StringTokenizer(extDirs, classPathSeparator);
                while (st.hasMoreTokens()) {
                    File[] extFiles = new File(st.nextToken()).listFiles();
                    if (extFiles == null) continue;
                    int i = 0;
                    while (i < extFiles.length) {
                        classPath = classPath + classPathSeparator + extFiles[i].getPath();
                        ++i;
                    }
                }
            }
            st = new StringTokenizer(classPath, classPathSeparator);
            while (st.hasMoreTokens()) {
                String classPathEntry = st.nextToken();
                File classPathFile = new File(classPathEntry);
                if (!classPathFile.exists()) continue;
                if (classPathEntry.toLowerCase().endsWith(".jar")) {
                    JdeUtilities.addClassesFromZip(classList, classPathFile);
                    continue;
                }
                if (classPathEntry.toLowerCase().endsWith(".zip")) {
                    JdeUtilities.addClassesFromZip(classList, classPathFile);
                    continue;
                }
                if (!classPathFile.isDirectory()) continue;
                JdeUtilities.addClassesFromDir(classList, classPathFile, classPathFile);
            }
            ce.dirty = false;
        }
    }

    public static void addClassesFromZip(Vector classList, File classPathFile) {
        try {
            ZipFile zipFile = new ZipFile(classPathFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String current = zipEntry.getName();
                if (!current.toLowerCase().endsWith(".class")) continue;
                current = current.substring(0, current.length() - 6);
                current = current.replace('/', '.');
                current = current.replace('\\', '.');
                classList.addElement(current);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem opening " + classPathFile + " with zip.");
        }
    }

    public static void addClassesFromDir(Vector classList, File rootDir, File currentDir) {
        String[] files = currentDir.list();
        if (files == null) {
            System.err.println("Cannot read contents of " + currentDir + ".");
            return;
        }
        int i = 0;
        while (i < files.length) {
            String current = files[i];
            if (current.toLowerCase().endsWith(".class")) {
                current = current.substring(0, current.length() - 6);
                String rootPath = rootDir.getPath();
                String currentPath = currentDir.getPath();
                if (currentPath.indexOf(rootPath) != 0) {
                    System.err.println("currentPath doesn't start with rootPath!\nrootPath: " + rootPath + "\n" + "currentPath: " + currentPath + "\n");
                } else {
                    String packageName = currentPath.substring(rootPath.length());
                    if (packageName.length() > 0) {
                        packageName = packageName.replace('\\', '.');
                        packageName = packageName.replace('/', '.');
                        classList.addElement(packageName.substring(1) + '.' + current);
                    } else {
                        classList.addElement(current);
                    }
                }
            } else {
                File currentFile = new File(currentDir, current);
                if (currentFile.isDirectory()) {
                    JdeUtilities.addClassesFromDir(classList, rootDir, currentFile);
                }
            }
            ++i;
        }
    }

    public static void getQualifiedName(String className) {
        String qualifiedNameList = "(list";
        Vector classList = JdeUtilities.getCurrentClassList();
        int i = 0;
        while (i < classList.size()) {
            String testName = (String)classList.elementAt(i);
            if ((testName.length() > className.length() && testName.endsWith(className) && testName.charAt(testName.length() - className.length() - 1) == '.' || testName.length() == className.length() && testName.equals(className)) && qualifiedNameList.indexOf(testName = " \"" + testName + "\"") == -1) {
                qualifiedNameList = qualifiedNameList + testName;
            }
            ++i;
        }
        qualifiedNameList = qualifiedNameList + ")";
        System.out.println(qualifiedNameList);
        System.out.flush();
    }

    static {
        projectCache.put(currentProjectName, new CacheEntry(System.getProperty("java.class.path")));
    }

    private static class CacheEntry {
        public Vector classList = new Vector(500);
        public String classPath;
        public boolean dirty;

        CacheEntry(String classPath) {
            this.classPath = classPath;
            this.dirty = true;
        }
    }
}

