;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: help.lisp,v 1.4 1993/06/04 06:27:59 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;;;     Contains definitions for the help window


(defconstant *helpheight* 300 "Height of help window")
(defconstant *totalhelpheight* 4530 "Maximum height of help window")
(defconstant *helpwidth* 650 "Width of help window")
(defconstant *space* 13 "Spacing between entries in window")

(create-instance 'title-font opal:font
		 (:family :fixed)
		 (:face :bold)
		 (:size :large))
(create-instance 'med-bold-font opal:font
		 (:family :fixed)
		 (:face :bold)
		 (:size :medium))

;;; Function to create the help window
(defun make-help ()
  (declare (special help-aggregate))
  (create-instance 'help-window garnet-gadgets:scrolling-window-with-bars
		   (:parent-window nil)
		   (:title "XGinseng Help")
		   (:position-by-hand t)
		   (:width *helpwidth*)
		   (:height *helpheight*)
		   (:total-width *helpwidth*)
		   (:total-height *totalhelpheight*)
		   (:visible T)
		   (:h-scroll-bar-p nil)
		   (:v-scroll-bar-p t)
		   (:h-scroll-on-top-p NIL)
		   (:v-scroll-on-left-p T)
		   (:v-page-incr (o-formula (- (gvl :height) 10)))
		   (:v-scr-incr 100))
  (opal:update help-window) ; Required update call immediately after creation
  (setf help-aggregate (g-value help-window :inner-aggregate))
  (create-instance 'quit-button Garnet-gadgets:Text-Button-Panel
		   (:items '(("Quit Help" Do-Help-Quit)))
		   (:direction :horizontal)
		   (:left 5)
		   (:top 5)
		   (:font Opal:Default-font)
		   (:shadow-offset 5)
		   (:final-feedback-p nil))
  (create-instance 'title opal:text
		   (:left (o-formula (- (floor *helpwidth* 2) 90)))
		   (:top 15)
		   (:font title-font)
		   (:string "XGinseng Help Facility"))
  (mouse-texts)
  (operation-texts)
  (opal:add-component help-aggregate title)
  (opal:add-component help-aggregate quit-button))

(defun mouse-texts ()
  "Function to add text describing button operations to the help-window"
  (declare (special help-aggregate))
  (create-instance 'mouse-title opal:text
		   (:left (o-formula (- (floor *helpwidth* 2) 130)))
		   (:top 70)
		   (:font title-font)
		   (:string "Mouse button operations"))
  (create-instance 'uline opal:line
		   (:x1 (g-value mouse-title :left))
		   (:y1 (+ 24 (g-value mouse-title :top)))
		   (:x2 (+ (g-value mouse-title :left) (g-value mouse-title :width)))
		   (:y2 (+ 24 (g-value mouse-title :top)))
		   (:line-style opal:line-2))
  (create-instance 'left-mouse-title opal:text
		   (:left 3) (:top 110)
		   (:font med-bold-font)
		   (:string "LEFT:"))
  (create-instance 'left-mouse-text opal:multi-text
		   (:left 55) (:top 110) (:justification :left)
		   (:string "1. BUTTON SELECTION.
Clicking with the left mouse button over a button object will perform that
operation.

2. NODE MOVEMENT & DISPLAY.
When you click and drag a node, it will follow the cursor anywhere within
the display window so long as the left button is depressed.  Once it is
released, the node will be placed at the cursor's position at the time of
release.  When creating a new node with \"Display A Node,\" type the node's
name and a carriage return with the mouse over the Dialogue Box.  Then,
when prompted, press the <SHIFT> key and click left over the Display window.
The new node will appear at the point of the click.

3. WINDOW SCROLLBARS.
Clicking on the top-most or bottom-most arrow scrolls the window by a
discrete amount either up or down. Clicking on the double-up or double-down
arrow moves the scrolling window to the top or bottom of the display
window.  To move the scrolling window continuously within the display
window, click and drag on the white scrollbar square."))

(create-instance 'mid-mouse-title opal:text
		 (:left 3)
		 (:top (+ 15 ; Separation between Button texts
			  (g-value left-mouse-text :height)
			  (g-value left-mouse-text :top)))
		 (:font med-bold-font)
		 (:string "MIDDLE:"))
(create-instance 'mid-mouse-text opal:multi-text
		 (:left 55)
		 (:top (g-value mid-mouse-title :top))
		 (:justification :left)
		 (:string "1. NODE SELECTION.
To perform an operation on a node, click on the chosen button with the left
button, then click on the node with the middle button."))

(create-instance 'right-mouse-title opal:text
		 (:left 3)
		 (:top (+ 15 ; Separation between mouse button texts
			  (g-value mid-mouse-text :height)
			  (g-value mid-mouse-text :top)))
		 (:font med-bold-font)
		 (:string "RIGHT:"))
(create-instance 'right-mouse-text opal:multi-text
		 (:left 55)
		 (:top (g-value right-mouse-title :top))
		 (:justification :left)
		 (:string "1. ABORT AN OPERATION.
To abort a `Display A Node' or a `Save As Postscript File' operation, click
right over the dialogue box.  To abort a node selection operation (any of
the bottom five buttons) click on the right button over a node.  No action
will be taken."))

(opal:add-components help-aggregate
		     mouse-title uline left-mouse-title left-mouse-text
		     mid-mouse-title mid-mouse-text
		     right-mouse-title right-mouse-text))

(defun operation-texts ()
  "Function to add text describing the workings of the operation buttons."
  (declare (special help-aggregate))
  (create-instance 'operation-title opal:text
		   (:left (o-formula (- (floor *helpwidth* 2) 140)))
		   (:top (+ 25
			    (g-value right-mouse-text :height)
			    (g-value right-mouse-text :top)))
		   (:font title-font)
		   (:string "Command Button Operations"))
  (create-instance 'uline2 opal:line
		   (:x1 (g-value operation-title :left))
		   (:y1 (+ 22 (g-value operation-title :top)))
		   (:x2 (+ (g-value operation-title :left)
			   (g-value operation-title :width)))
		   (:y2 (+ 22 (g-value operation-title :top)))
		   (:line-style opal:line-2))
  (create-instance 'pause-title opal:text
		   (:left 3)
		   (:top (+ *space*	
			    (g-value operation-title :height)
			    (g-value operation-title :top)))
		   (:font med-bold-font)
		   (:string "PAUSE:"))
  (create-instance 'pause-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value pause-title :height)
			    (g-value pause-title :top)))
		   (:string
		    "    Temporarily suspends XGinseng and returns control to the calling LISP process.
To resume XGinseng, re-execute the SNePSUL function: (xginseng)."))
  (create-instance 'quit-title opal:text
		   (:left 3)
		   (:top (+ *space*  ;extra spacing between title and first description
			    (g-value pause-text :height)
			    (g-value pause-text :top)))
		   (:font med-bold-font)
		   (:string "QUIT:"))
  (create-instance 'quit-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value quit-title :height)
			    (g-value quit-title :top)))
		   (:string
		    "    Terminates XGinseng session, destroys all windows, nodes, and arcs and returns
control to the calling LISP process."))
  (create-instance 'help-title opal:text
		   (:left 3)
		   (:top (+ *space* 
			    (g-value quit-text :height)
			    (g-value quit-text :top)))
		   (:font med-bold-font)
		   (:string "HELP:"))
  (create-instance 'help-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value help-title :height)
			    (g-value help-title :top)))
		   (:string
		    "    Creates this Help window.  At most one Help window can be created at any time.
Iconify this window to remove it temporarily, or click left on the \"Quit Help\"
button in upper left corner of this window to destroy it."))
  (create-instance 'clear-title opal:text
		   (:left 3)
		   (:top (+ *space* 
			    (g-value help-text :height)
			    (g-value help-text :top)))
		   (:font med-bold-font)
		   (:string "CLEAR DISPLAY:"))
  (create-instance 'clear-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value clear-title :height)
			    (g-value clear-title :top)))
		   (:string
"    Removes all nodes and arcs from the Display window, but does not destroy any
windows.  Returns the inner Display window to the initial position over the middle
of the scrollable area.  To abort, click on the \"Cancel\" button of the
confirmation window."))
  (create-instance 'save-title opal:text
		   (:left 3)
		   (:top (+ *space* 
			    (g-value clear-text :height)
			    (g-value clear-text :top)))
		   (:font med-bold-font)
		   (:string "SAVE AS POSTSCRIPT FILE:"))
  (create-instance 'save-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value save-title :height)
			    (g-value save-title :top)))
		   (:string
"    Saves the Display window as a Postscript file.  Type the file's name after
the prompt in the Dialogue Box and press <RETURN>.  The mouse cursor will change
to a `+'.  Click with this cursor over the Display window.  When the button
returns to its normal coloring, the dump is complete."))
  (create-instance 'display-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value save-text :height)
			    (g-value save-text :top)))
		   (:font med-bold-font)
		   (:string "DISPLAY A NODE:"))
  (create-instance 'display-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value display-title :height)
			    (g-value display-title :top)))
		   (:string
"    Builds a graphic representation of an existing SNePS node.  After clicking
on this button, you will be prompted for the name of a node in the current SNePS
network.  Move the mouse to the dialogue box to activate the cursor, and type
the node's name in upper- or lower-case.  Sensory nodes that were initially created
surrounded by double quotes in mixed case should be entered surrounded by double
quotes.  Simple EMACS editing can be done on the string.  When the name is complete, 
hit <RETURN>.  A new prompt will appear in the Dialogue Box, asking you to click 
left over the Display window.  The new ode will be built at the point of the click.  
     This operation can only be aborted BEFORE the carriage return.  To abort,
click right over the Dialogue Box."))

  (create-instance 'enter-network-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value display-text :height)
			    (g-value display-text :top)))
		   (:font med-bold-font)
		   (:string "ENTER THE NETWORK:"))
  (create-instance 'enter-network-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value enter-network-title :height)
			    (g-value enter-network-title :top)))
		   (:string
"     Takes the newly created network that is currently displayed in the display
window, checks for unlabeled arcs or nodes, unasserted top-level nodes, and solitary
nodes.  If any of these conditions are true each offending node or arc will flash
(accompanied by a beep as well) to notify the user to fix the node.  Network entry
is aborted at this point and the user must re-enter the network once the structure
has been made legal.  Should the network pass this initial test all relation labels are
examined to see whether they have yet been defined.  Those that haven't yet been defined
are displayed in the LISP window (there is no way in the current version of Garnet-1.4
to do this in the dialogue window) and the user asked whether a relation is to be defined.
A 'no' response to such a query suggests that the user has made a mistake in typing
the arc label and the function once again aborts to allow the user to edit the
network.  A legal network with defined relations results in the  generation and 
execution of a set of SNEPSUL commands corresponding to the network.  All nodes are
then relabeled to reflect the structure of the newly created SNePS network. "))

  (create-instance '1st-desc-title opal:text
		   (:left 3)
		   (:top (+ *space* 
			    (g-value enter-network-text :height)
			    (g-value enter-network-text :top)))
		   (:font med-bold-font)
		   (:string "1st GENERATION DESCENDANTS:"))
  (create-instance '1st-desc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value 1st-desc-title :height)
			    (g-value 1st-desc-title :top)))
		   (:string
"    Displays the nodes dominated by the selected node together with the arcs.
After clicking on this button, click with the middle mouse button over the node
you wish to select.  When the button returns to its initial coloring, the
operation is complete.  To abort, click with the right mouse button over any node."))
  (create-instance '1st-anc-title opal:text
		   (:left 3)
		   (:top (+ *space* 
			    (g-value 1st-desc-text :height)
			    (g-value 1st-desc-text :top)))
		   (:font med-bold-font)
		   (:string "1st GENERATION ANCESTORS:"))
  (create-instance '1st-anc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value 1st-anc-title :height)
			    (g-value 1st-anc-title :top)))
		   (:string
"    Displays the nodes which dominate the selected node together with the arcs.
For completeness, all 1st generation descendants of the ancestors are displayed.
After clicking on this button, click with the middle mouse button over the node
you wish to select.  When the button returns to its initial coloring, the
operation is complete.  To abort, click with the right mouse button over any node."))
  (create-instance 'all-desc-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value 1st-anc-text :height)
			    (g-value 1st-anc-text :top)))
		   (:font med-bold-font)
		   (:string "ALL DESCENDANTS:"))
  (create-instance 'all-desc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value all-desc-title :height)
			    (g-value all-desc-title :top)))
		   (:string
"    Displays all of the nodes below the selected node in the network.  That is,
all nodes dominated by the selected node, all nodes dominated by those nodes, and
so on until base nodes are displayed. After clicking on this button, click with the
middle mouse button over the node you wish to select.  When the button returns to
its initial coloring, the operation is complete.  To abort, click with the right
mouse button over any node."))
  (create-instance 'all-anc-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value all-desc-text :height)
			    (g-value all-desc-text :top)))
		   (:font med-bold-font)
		   (:string "ALL ANCESTORS:"))
  (create-instance 'all-anc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value all-anc-title :height)
			    (g-value all-anc-title :top)))
		   (:string
"    Displays all of the nodes above the selected node in the network.  That is,
all nodes which dominate the selected node and their first generation descendants,
all nodes which dominate those nodes and their first generation descendants, and
so on until undominated nodes are displayed.  After clicking on this button, click
with the middle mouse button over the node you wish to select.  When the button
returns to its initial coloring, the operation is complete.  To abort, click with
the right mouse button over any node."))
  (create-instance 'hide-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value all-anc-text :height)
			    (g-value all-anc-text :top)))
		   (:font med-bold-font)
		   (:string "HIDE A NODE:"))
  (create-instance 'hide-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value hide-title :height)
			    (g-value hide-title :top)))
		   (:string
"    Removes a node and all outgoing arcs from the Display window.  The selected
node must be undominated.  If the node being hidden is the only displayed node
which dominates another node, that node is also hidden.  After clicking on the
button, click with the middle mouse button over the node you wish to hide.  If the
node is dominated, a message will appear in the Dialogue Box.  To abort, click
with the right mouse button over any node."))

  (create-instance 'erase-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value hide-text :height)
			    (g-value hide-text :top)))
		   (:font med-bold-font)
		   (:string "ERASE A NODE:"))
  (create-instance 'erase-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value erase-title :height)
			    (g-value erase-title :top)))
		   (:string
"    This function is applied only to a node that is currently associated with a 
valid SNePS node.  After this button is selected place the cursor over the node
to be erased and press the middle mouse button down.  This will invoke the snepsul
erase function on the selected node.  If the node is eligible for erasing it and
all other dismantled nodes will disappear from the display window.  If the node
is not eligible for erasing the function will return with no effect.  You may abort
this function by clicking RIGHT down OVER a node. "))

  (create-instance 'assert-a-node-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value erase-text :height)
			    (g-value erase-text :top)))
		   (:font med-bold-font)
		   (:string "ASSERT A NODE:"))
  (create-instance 'assert-a-node-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value assert-a-node-title :height)
			    (g-value assert-a-node-title :top)))
		   (:string
"    This function is applied to molecular nodes that are currently unasserted by
applying the '!' macro to them.  The result of the function is displayed by 
appending a trailing '!' to the node label.  

Warning: The program will crash at the snepsul level should you try applying this
function to a node that may not be asserted.  You should press RIGHT down to 
abort.  ")) 


  (create-instance 'input-command-operations-title opal:text
		   (:left (o-formula (- (floor *helpwidth* 2) 130)))
		   (:top (+ 50 
			    (g-value assert-a-node-text :height)
			    (g-value assert-a-node-text :top)))

		   (:font title-font)
		   (:string "Input Command Operations"))
  (create-instance 'uline3 opal:line
		   (:x1 (g-value mouse-title :left))
		   (:y1 (+ 24 (g-value input-command-operations-title :top)))
		   (:x2 (+ (g-value input-command-operations-title :left) 
			   (g-value input-command-operations-title :width)))
		   (:y2 (+ 24 (g-value input-command-operations-title :top)))
		   (:line-style opal:line-2))



  (create-instance 'make-blank-node-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value uline3 :height)
			    (g-value uline3 :top)))
		   (:font med-bold-font)
		   (:string "MAKE A BLANK NODE:"))
  (create-instance 'make-blank-node-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value make-blank-node-title :height)
			    (g-value make-blank-node-title :top)))
		   (:string
"     After this button is depressed place the cursor over the area of the display
window where you'd like a blank node to be created and depress the RIGHT mouse
button.  After the node is created this function is disabled and must be re-invoked.

NOTE:  This same functionality may be achieved more quickly by selecting a point in
the display window and simultaneously pressing LEFT down and the CTRL key down. "))

  (create-instance 'draw-an-arc-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value make-blank-node-text :height)
			    (g-value make-blank-node-text :top)))
		   (:font med-bold-font)
		   (:string "DRAW AN ARC:"))
  (create-instance 'draw-an-arc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value draw-an-arc-title :height)
			    (g-value draw-an-arc-title :top)))
		   (:string
"     This function allows you to draw an arc between two existing nodes in the 
display window.   After selecting this function by pressing the LEFT mouse button
over it, select the node from which the arc will emanate by pointing to it
with the cursor and depressing the RIGHT mouse button.  Then, without releasing the
button, move the cursor over the destination node and release.   An arc will then
appear between the two nodes.  If you should release the mouse button and the cursor
is not over any node a beep will sound and you may try again.  After a successful
arc creation this function is disabled (the button will turn white again) and you
must re-invoke it.

NOTE:  This same functionality may be achieved more quickly by selecting a source node 
in the display window with the mouse cursor, simultaneously pressing MIDDLE down and
the CTRL key down, and dragging the mouse over to the destination node and releasing.
 "))

  (create-instance 'draw-a-double-arc-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value draw-an-arc-text :height)
			    (g-value draw-an-arc-text :top)))
		   (:font med-bold-font)
		   (:string "DRAW A DOUBLE ARC:"))
  (create-instance 'draw-a-double-arc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value draw-a-double-arc-title :height)
			    (g-value draw-a-double-arc-title :top)))
		   (:string
"     This function is identical to DRAW AN ARC except that a double arc is drawn.

NOTE:  This same functionality may be achieved more quickly by selecting a source node 
in the display window with the mouse cursor, simultaneously pressing MIDDLE, CTRL, and
SHIFT keys down, and dragging the mouse over to the destination node and releasing. "))



  (create-instance 'edit-or-enter-a-label-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value draw-a-double-arc-text :height)
			    (g-value draw-a-double-arc-text :top)))
		   (:font med-bold-font)
		   (:string "EDIT OR ENTER A LABEL:"))
  (create-instance 'edit-or-enter-a-label-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value edit-or-enter-a-label-title :height)
			    (g-value edit-or-enter-a-label-title :top)))
		   (:string
"     When this button is depressed you may enter or edit any text label in any node
or arc that is currently 'unknown' to SNePS, i.e. the node or arc is part of a 
network that has yet to be entered into SNePS.  When you click the RIGHT mouse button
over a label a vertical bar will appear in the label indicating where text will
henceforth be entered.  Note that the following emacs commands are valid: 
            
               <Ctrl-f> to move one character to the right
               <Ctrl-b> to move one character to the left
               <Ctrl-a> to move to the beginning of the label
               <Ctrl-e> to move to the end of the label
               <Ctrl-d> to delete the character immediately to the 
                        right of the vertical bar.
               <delete> to delete the character immediately to the
                        left of the vertical bar

Also, by placing the mouse cursor over any spot in the label and pressing the
LEFT mouse button you may immediately move the vertical bar any place in the
label you wish.  To exit editing just hit <return>. 

NOTE:  This same functionality may be achieved more quickly by selecting a node or
arc label in the display window with the mouse cursor and simultaneously pressing 
the CTRL key and the RIGHT mouse buttons down.  Exit this function by hitting
<RETURN>. "))


  (create-instance 'delete-a-node-or-arc-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value edit-or-enter-a-label-text :height)
			    (g-value edit-or-enter-a-label-text :top)))
		   (:font med-bold-font)
		   (:string "DELETE A NODE OR ARC:"))
  (create-instance 'delete-a-node-or-arc-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value delete-a-node-or-arc-title :height)
			    (g-value delete-a-node-or-arc-title :top)))
		   (:string
"     This function allows you to delete any node or arc by clicking the RIGHT
mouse button over it.  When you click over an arc only the arc is deleted; if
you click over a node the node and all arcs emanating from it or impinging on
it are deleted as well.  Note that this function works only on structures that
are not yet associated with any SNePS structures. 

NOTE:  This same functionality may be achieved more quickly by selecting the node
to be deleted with the mouse cursor and then simultaneously hitting the LEFT, CTRL,
and SHIFT keys. "))



  (create-instance 'mark-node-as-asserted-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value delete-a-node-or-arc-text :height)
			    (g-value delete-a-node-or-arc-text :top)))
		   (:font med-bold-font)
		   (:string "MARK NODE AS ASSERTED:"))
  (create-instance 'mark-node-as-asserted-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value mark-node-as-asserted-title :height)
			    (g-value mark-node-as-asserted-title :top)))
		   (:string
"     This function marks a molecular node in a network to be entered as asserted
when you click RIGHT over it.  The result of this action is displayed as a single
'!' in the node label.  A node like this may be unasserted by simply by re-invoking
this function on the same node. 

NOTE:  This funtion differs significantly from the 'assert a node' function in the
XGINSENG COMMANDS panel.  This one deals soley with a network that has no 
corresponding SNePS network yet, and is equivalent to using an 'assert' instead
of 'build' in snepsul. 

NOTE:  This function may also be invoked simply by pointing to the node with the 
mouse cursor and hitting the F3 key.  The node may be 'unasserted' by re-doing
this action."))

  (create-instance 'mark-node-as-a-base-node-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value mark-node-as-asserted-text :height)
			    (g-value mark-node-as-asserted-text :top)))
		   (:font med-bold-font)
		   (:string "MARK-NODE-AS-A-BASE-NODE:"))
  (create-instance 'mark-node-as-a-base-node-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value mark-node-as-a-base-node-title :height)
			    (g-value mark-node-as-a-base-node-title :top)))
		   (:string
"     This function creates a base node when you click over it with the RIGHT
button.  The node name will appear in the node label.

NOTE: This function may be invoked by placing the cursor over the node and
pressing F2"))


  (create-instance 'mark-node-as-a-variable-node-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value mark-node-as-a-base-node-text :height)
			    (g-value mark-node-as-a-base-node-text :top)))
		   (:font med-bold-font)
		   (:string "MARK-NODE-AS-A-VARIABLE-NODE:"))
  (create-instance 'mark-node-as-a-variable-node-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value mark-node-as-a-variable-node-title :height)
			    (g-value mark-node-as-a-variable-node-title :top)))
		   (:string
"     This function creates a variable node when you click over it with the RIGHT
button.  The node name will appear in the node label.

NOTE: This function may be invoked by placing the cursor over the node and
pressing F4"))


  (create-instance 'copy-a-label-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value mark-node-as-a-variable-node-text :height)
			    (g-value mark-node-as-a-variable-node-text :top)))
		   (:font med-bold-font)
		   (:string "COPY A LABEL:"))
  (create-instance 'copy-a-label-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value copy-a-label-title :height)
			    (g-value copy-a-label-title :top)))
		   (:string
"    This function allows you to copy text over from one arc label (it is assumed that
you have little reason to do this for nodes, but you can) to another instead of re-
typing the same label each time.   After choosing this function place the cursor over
the label from which you want to copy text and press RIGHT down.  The string is copied
over to an internal buffer at this point.  Subsequent presses of RIGHT down over a
label will then copy the contents of this buffer into new labels.  To stop this function,
or to start copying another label, just press the button \"Reset label copying\".

NOTE:  You may achieve the same result by pressing RIGHT down in combination with the
the SHIFT key to load the buffer with label text.  Then press RIGHT down in combination
with SHIFT and CTRL over any label into which you want to copy the text. "))


  (create-instance 'universal-quantifier-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value copy-a-label-text :height)
			    (g-value copy-a-label-text :top)))
		   (:font med-bold-font)
		   (:string "UNIVERSAL QUANTIFIER:"))
  (create-instance 'universal-quantifier-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value universal-quantifier-title :height)
			    (g-value universal-quantifier-title :top)))
		   (:string
"    This function allows you to create a \"ready-made\" case frame instead of
building it from scratch.  Treat this function as you would the node creation
function.  One thing to note, however, is that roughly the middle of the case 
frame will be located where the cursor was located, so make sure that you don't
place the cursor to close to an edge of the display window (the outer window).

NOTE:  You may achieve the same result by placing the cursor over the point
where you want the case frame and then hitting F5 TWICE."
))


  (create-instance 'numerical-entailment-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value universal-quantifier-text :height)
			    (g-value universal-quantifier-text :top)))
		   (:font med-bold-font)
		   (:string "NUMERICAL ENTAILMENT:"))
  (create-instance 'numerical-entailment-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value numerical-entailment-title :height)
			    (g-value numerical-entailment-title :top)))
		   (:string
"    This function allows you to create a \"ready-made\" case frame instead of
building it from scratch.  Treat this function as you would the node creation
function.  One thing to note, however, is that roughly the middle of the case 
frame will be located where the cursor was located, so make sure that you don't
place the cursor to close to an edge of the display window (the outer window).

NOTE:  You may achieve the same result by placing the cursor over the point
where you want the case frame and then hitting F6 TWICE."
))


  (create-instance 'and-or-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value numerical-entailment-text :height)
			    (g-value numerical-entailment-text :top)))
		   (:font med-bold-font)
		   (:string "AND OR:"))
  (create-instance 'and-or-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value and-or-title :height)
			    (g-value and-or-title :top)))
		   (:string
"    This function allows you to create a \"ready-made\" case frame instead of
building it from scratch.  Treat this function as you would the node creation
function.  One thing to note, however, is that roughly the middle of the case 
frame will be located where the cursor was located, so make sure that you don't
place the cursor to close to an edge of the display window (the outer window).

NOTE:  You may achieve the same result by placing the cursor over the point
where you want the case frame and then hitting F7 TWICE."
))



  (create-instance 'thresh-title opal:text
		   (:left 3)
		   (:top (+ *space* ;extra spacing between title and first description
			    (g-value and-or-text :height)
			    (g-value and-or-text :top)))
		   (:font med-bold-font)
		   (:string "THRESH:"))
  (create-instance 'thresh-text opal:multi-text
		   (:left 3)
		   (:top (+ (g-value thresh-title :height)
			    (g-value thresh-title :top)))
		   (:string
"    This function allows you to create a \"ready-made\" case frame instead of
building it from scratch.  Treat this function as you would the node creation
function.  One thing to note, however, is that roughly the middle of the case 
frame will be located where the cursor was located, so make sure that you don't
place the cursor to close to an edge of the display window (the outer window).

NOTE:  You may achieve the same result by placing the cursor over the point
where you want the case frame and then hitting F8 TWICE."
))









(opal:add-components help-aggregate
		     operation-title uline2 quit-title quit-text
		     pause-title pause-text help-title help-text
		     clear-title clear-text save-title save-text
		     1st-desc-text 1st-desc-title 1st-anc-title 1st-anc-text
		     all-desc-title all-desc-text all-anc-title all-anc-text
		     enter-network-title enter-network-text
		     erase-title erase-text
		     assert-a-node-title assert-a-node-text
		     input-command-operations-title
		     uline3
		     make-blank-node-title make-blank-node-text
		     draw-an-arc-title draw-an-arc-text 
		     draw-a-double-arc-title draw-a-double-arc-text 
		     edit-or-enter-a-label-title edit-or-enter-a-label-text
		     delete-a-node-or-arc-title delete-a-node-or-arc-text
		     mark-node-as-asserted-title mark-node-as-asserted-text
		     mark-node-as-a-base-node-title mark-node-as-a-base-node-text 
		     mark-node-as-a-variable-node-title mark-node-as-a-variable-node-text 
		     copy-a-label-title copy-a-label-text
		     display-title display-text hide-title hide-text
		     universal-quantifier-title universal-quantifier-text
		     numerical-entailment-title numerical-entailment-text
		     and-or-title and-or-text
		     thresh-title thresh-text))


(defun Do-Help-Quit (toolkit-obj button-panel-item)
  (declare (ignore toolkit-obj))
  (declare (ignore button-panel-item))
  (opal:destroy help-window)
  (setf help-window nil))


;;;; Error Message

(defconstant *errortextleft* 3 
  ":Left of error message appearing in the Dialogue Box")
(defconstant *errortexttop* 9
  ":Top of error message (second line) appearing in the Dialogue Box")
(defun error-message (error-string &optional (arg nil))
  ;;First, clear the dialogue box of previous messages & destroy it
  (declare (special error-text))
  (if (and (boundp 'error-text) error-text)
      (progn 
	(opal:remove-component dialogue-aggregate error-text)
	(opal:destroy-me error-text)))
  (opal:remove-component dialogue-aggregate prompt)
  (opal:remove-component dialogue-aggregate reply)
  (create-instance 'error-text opal:text
		   (:left *errortextleft*) (:top *errortexttop*)
		   (:string (format nil error-string arg)))
  (opal:add-component dialogue-aggregate error-text)
  (inter:beep)
  (opal:update dialogue-window))

;;;; Confirmation window

(defconstant *confirm-height* 150 "Height of Confirmation window")
(defconstant *confirm-width* 250 "Width of Confirmation window")
(defconstant *confirm-top* 375 "Top of Confirmation window")
(defconstant *confirm-left* 425 "Left of Confirmation window")

(defun make-confirm-box (confirm-string)
  (create-instance 'confirm-box inter:interactor-window
		   (:parent nil)
		   (:left *confirm-left*)
		   (:top *confirm-top*)
		   (:height *confirm-height*)
		   (:width *confirm-width*)
		   (:aggregate
		    (create-instance 'confirm-box-aggregate opal:aggregate)))
  
  (create-instance 'message opal:multi-text
		   (:left (o-formula (floor (- *confirm-width* (gvl :width) 2))))
	      	   (:top 20)
	       	   (:string confirm-string))
  (create-instance 'instructions opal:multi-text
		   (:left (o-formula (floor (- *confirm-width* (gvl :width) 2))))
	      	   (:top 70)
	       	   (:string "Click on CONFIRM to execute
or CANCEL to abort" ))

  (create-instance 'confirm-buttons Garnet-gadgets:Text-Button-Panel
		   (:items '(("Confirm" confirm) ("Cancel" cancel)))
		   (:direction :horizontal)
		   (:left 30)
		   (:top 100)
		   (:font Opal:Default-font)
		   (:shadow-offset 5)
		   (:final-feedback-p t))

  (opal:add-components confirm-box-aggregate instructions message confirm-buttons)
  (inter:beep)
  (opal:update confirm-box))

;;; Functions to signal the selection in CONFIRM-BOX
(defmacro confirm (a b)
  `(return 'confirm))

(defmacro cancel (a b)
  `(return 'cancel))

;;; From ~snwiz/Garnet-1.3/src/gadgets/error-gadget.lisp

;;    This function creates a new priority level and adds them to the front
;; of the interactorts priority level list.  Thus, this level has higher
;; priority than the default inter-levels.
;;    This priority level are needed in case the error-gadget is modal.
;; The idea is to set the ERROR-PRIORITY-LEVEL's :stop-when to :always
;; when the error-gadget is modal, so that the "OK" button is the only gadget
;; that will work in the entire interface while the error-window is visible.
;;    So, the effect is to shut down the rest of the interface until the user
;; clicks on "OK" (if the error-gadget is modal).
;;
(defun ADD-ERROR-PRIORITY-LEVEL ()
  (unless (and (boundp 'ERROR-PRIORITY-LEVEL)
	       (member ERROR-PRIORITY-LEVEL inter:priority-level-list))
    (push (create-instance 'ERROR-PRIORITY-LEVEL inter:priority-level)
	  inter:priority-level-list)))
(add-error-priority-level)
