;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: arcs.lisp,v 1.4 1993/06/04 06:27:52 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;;;   This file contains the definitions of arcs, labels, and arrow-lines.

(defconstant *labelheight* 18 "Height of label box")
(defconstant *textleftoffset* 5 "Offset of text to left edge of background")
(defconstant *texttopoffset* 2 "Offset of text to top edge of background")
(defconstant *centering-y* 8 "Upwards shift of label on arc to center it 
   between the end-points")

;;; Create the prototype for an opaque box framing a string to store the arc labels
(create-instance 'OPAQUE-LABEL opal:aggregadget
   ;Customizable slots
   (:left 0)
   (:top 0)
   (:label "")
   (:parts
    `((:background ,opal:rectangle
		   ;; The numbers here determine the amount of white space around the 
		   ;; arc label.
		   (:left ,(o-formula (gv (kr-path 0 :parent) :left)))
		   (:top ,(o-formula (gv (kr-path 0 :parent) :top)))
		   (:height ,(o-formula *labelheight*))
		   (:width ,(o-formula (+ (gv (kr-path 0 :parent) :thelabel :width) 
				(* 2 *textleftoffset*))))
	 (:filling-style ,opal:white-fill)
	 (:line-style NIL))
      (:thelabel ,opal:cursor-text ;;my-change
	 (:left ,(o-formula (+ (gv (kr-path 0 :parent) :left) *textleftoffset*)))
	 (:top ,(o-formula (+ (gv (kr-path 0 :parent) :top) *texttopoffset*)))
	 (:cursor-index NIL)
	 (:string ,(o-formula (gv (kr-path 0 :parent) :label)))))))

;; Create a prototype for a line with an arrowhead at one end
(create-instance 'ARROW-LINE opal:aggregadget
   ; Customizable slots
   (:X1 0)
   (:Y1 0)
   (:X2 20)
   (:Y2 20)
   ; Components of the arrow-line (non-customizable)
   (:parts
    `((:line ,opal:Line
	 (:x1 ,(o-formula (gv (kr-path 0 :parent) :x1)))
	 (:y1 ,(o-formula (gv (kr-path 0 :parent) :y1)))
	 (:x2 ,(o-formula (gv (kr-path 0 :parent) :x2)))
	 (:y2 ,(o-formula (gv (kr-path 0 :parent) :y2))))
      (:arrowhead ,opal:Arrowhead
	 (:open-p NIL)
	 (:filling-style ,opal:Black-fill)
	 (:from-x ,(o-formula (gv (kr-path 0 :parent) :x1)))
	 (:from-y ,(o-formula (gv (kr-path 0 :parent) :y1)))
	 (:head-x ,(o-formula (gv (kr-path 0 :parent) :x2)))
	 (:head-y ,(o-formula (gv (kr-path 0 :parent) :y2)))))))

;; Prototype definition for an arc: an arrow-line with an opaque-box
;;; holding the label tied to the midpoint of the arrowline.
(create-instance 'ARC opal:aggregadget
   ;Customizable slots
   (:prototype 'arc); my-change		 
   (:from-node nil) ;my-change
   (:to-node nil) ;my-change
   (:x1 0)
   (:y1 0)
   (:x2 10)
   (:y2 10)
   (:label1 "")
   (:label1-symbol (o-formula 
		    (intern 
		     (string-upcase 
		      (string-trim 
		       '(#\newline #\space #\tab)
		       (gvl :label-box :thelabel :string)))))); my-change
					;Components of the node (non-customizable)
   ;Components of the node (non-customizable)
   (:parts
    `((:arrow ,arrow-line
         (:x1 ,(o-formula (gv (kr-path 0 :parent) :x1)))
	 (:y1 ,(o-formula (gv (kr-path 0 :parent) :y1)))
	 (:x2 ,(o-formula (gv (kr-path 0 :parent) :x2)))
	 (:y2 ,(o-formula (gv (kr-path 0 :parent) :y2))))
      (:label-box ,opaque-label
	 (:left ,(o-formula 
		  (- (floor (+ (gv (kr-path 0 :parent) :x1) 
			       (gv (kr-path 0 :parent) :x2)) 2)
		     (floor (gvl :background :width) 2))))
	 (:top ,(o-formula (- (floor (+ (gv (kr-path 0 :parent) :y1) 
					(gv (kr-path 0 :parent) :y2)) 2) *centering-y*)))
	 (:label ,(o-formula (gv (kr-path 0 :parent) :label1)))))))

(defconstant *height-pct* 0.75 "Ratio of height of double arc to width of double arc") 
;;; Prototype for DOUBLE-ARC:Two rounded arcs connecting two nodes,
;;; including arc-labels, and arrowheads attached to the same node of
;;; the connected pair.
;(create-instance 'DOUBLE-ARC opal:aggregadget
;  ;Customizable slots
;  (:left 0) ;  set to the MIDPOINT of the left-most node
;  (:right 0) ; set to the MIDPOINT of the right-most node
;  (:top 0)  ;  set to the MIDPOINT of the nodes
;  (:width 0) ;  set to the horizontal separation of the nodes
;  (:on-right-p T) ; Whether destination node is to right of source node
;  (:top-label "") ; Label attached to top arc in the pair
;  (:bottom-label "") ; Label attached to bottom arc
;  ; Non-customizable slots
;  (:height (o-formula (round (* *height-pct* (gvl :width)))))
;  (:parts
;   `((:arcs ,opal:oval
;       (:left ,(o-formula (gv (kr-path 0 :parent) :left)))
;       (:top ,(o-formula (- (gv (kr-path 0 :parent) :top) (floor (gvl :height) 2))))
;       (:width ,(o-formula (gv (kr-path 0 :parent) :width)))
;       (:height ,(o-formula (round (* *height-pct* (gv (kr-path 0 :parent) :width))))))
;     ; Arrowhead for the top arc always attaches at midpoint of destination node
;     (:top-arrowhead ,opal:Arrowhead
;	(:open-p NIL)
;	(:filling-style ,opal:Black-fill)
;	; These arrow-heads need to be a little wider
;	(:diameter 14)
;	(:head-x ,(o-formula (if (gv (kr-path 0 :parent) :on-right-p)
;				 (+ (gv (kr-path 0 :parent) :right) 4)
;			       (+ (gv (kr-path 0 :parent) :left) 4))))
;	(:head-y ,(o-formula (+ 2 (gv (kr-path 0 :parent) :top) (- *halfnodeheight*))))
;	(:from-x ,(o-formula (gv (kr-path 0 :parent) :top-label-box :left)))
;	(:from-y ,(o-formula (gv (kr-path 0 :parent) :top-label-box :top))))
;     (:bottom-arrowhead ,opal:Arrowhead
;        (:open-p NIL)
;        (:filling-style ,opal:Black-fill)
;	; These arrow-heads need to be a little wider
;	(:diameter 14)
;        (:head-x ,(o-formula (if (gv (kr-path 0 :parent) :on-right-p)
;				 (+ (gv (kr-path 0 :parent) :right) 4)
;			       (+ (gv (kr-path 0 :parent) :left) 4))))
;        (:head-y ,(o-formula (+ -3 (gv (kr-path 0 :parent) :top) *halfnodeheight*)))
;	; Bottom arrowhead looks better angled further right
;        (:from-x ,(o-formula (gv (kr-path 0 :parent) :bottom-label-box :left)))
;	(:from-y ,(o-formula (+ (gv (kr-path 0 :parent) :bottom-label-box :top) 20))))
;     (:top-label-box ,opaque-label
;	(:top ,(o-formula (- (gv (kr-path 0 :parent) :arcs :top)
;			     (floor *labelheight* 2))))
;	(:left ,(o-formula (+ (gv (kr-path 0 :parent) :left)
;			      (floor (gv (kr-path 0 :parent) :width) 2)
;			      (floor (gvl :background :width) -2))))
;	(:label ,(o-formula (gv (kr-path 0 :parent) :top-label))))
;     (:bottom-label-box ,opaque-label
;	(:top ,(o-formula (+ (gv (kr-path 0 :parent) :arcs :height)
;			     (gv (kr-path 0 :parent) :arcs :top) 
;			     (floor *labelheight* -2))))
;	(:left ,(o-formula (+ (gv (kr-path 0 :parent) :left)
;			      (floor (gv (kr-path 0 :parent) :width) 2)
;			      (floor (gvl :background :width) -2))))
;	(:label ,(o-formula (gv (kr-path 0 :parent) :bottom-label)))))))

;; Prototype for DOUBLE-ARC:Two rounded arcs connecting two nodes,
;; including arc-labels, and arrowheads attached to the same node of
;; the connected pair.
(create-instance 'DOUBLE-ARC opal:aggregadget
  ;Customizable slots
  (:quadrant 1) ; represents the Cartesian quadrant of the destination
                ; node, with respect to the source node.
  (:left 0) ;  set to the MIDPOINT of the left-most node
  (:top 0)  ;  set to the MIDPOINT of the top-most node
  (:right 0) ;  set to the MIDPOINT of the right-most node
  (:bottom 0) ;  set to the MIDPOINT of the bottom-most node
  (:width 0) ;  set to the horizontal separation of the nodes
  (:height 0) ;  set to the vertical separation of the nodes
  (:target-width 0) ; set to width of destination node
  (:top-label "") ; Label attached to top arc in the pair
  (:bottom-label "") ; Label attached to bottom arc
  (:prototype 'double-arc) ;my-change
  (:from-node nil) ;my-change
  (:to-node nil) ;my-change
  (:top-label-symbol (o-formula 
		      (intern 
		       (string-upcase 
			(string-trim 
			 '(#\newline #\space #\tab)
			 (gvl :top-label-box :thelabel :string)))))); my-change
  (:bottom-label-symbol (o-formula 
			 (intern 
			  (string-upcase 
			   (string-trim 
			    '(#\newline #\space #\tab)
			    (gvl :bottom-label-box :thelabel :string)))))); my-change
  ; Non-customizable slots
  (:parts
   `((:top-arc ,opal:arc
	(:left ,(o-formula 
		(if (evenp (gv (kr-path 0 :parent) :quadrant))
		    (- (* 2 (gv (kr-path 0 :parent) :left))
		       (gv (kr-path 0 :parent) :right))
		    ;else
		  (gv (kr-path 0 :parent) :left))))
	(:top ,(o-formula (gv (kr-path 0 :parent) :top)))
	; Width and height are double the difference between the nodes
	(:width ,(o-formula (* 2 (gv (kr-path 0 :parent) :width))))
	(:height ,(o-formula (* 2 (gv (kr-path 0 :parent) :height))))
	; ANGLE1 is either 0 or pi/2
	(:angle1 ,(o-formula 
		   (if (evenp (gv (kr-path 0 :parent) :quadrant)) 0 1.57)))
	; ANGLE2 is always pi/2
	(:angle2 1.57))
     (:bottom-arc ,opal:arc
	(:left ,(o-formula 
		 (if (evenp (gv (kr-path 0 :parent) :quadrant))
		     (gv (kr-path 0 :parent) :left)
		     ;else
		   (- (* 2 (gv (kr-path 0 :parent) :left))
		      (gv (kr-path 0 :parent) :right)))))
        ; :top is the :height above the top-most node
	(:top ,(o-formula 
		(- (gv (kr-path 0 :parent) :top) (gv (kr-path 0 :parent) :height))))
        ; Width and height are double the difference between the nodes
	(:width ,(o-formula (* 2 (gv (kr-path 0 :parent) :width))))
	(:height ,(o-formula (* 2 (gv (kr-path 0 :parent) :height))))
	; ANGLE1 is either pi or 3pi/2
	(:angle1 ,(o-formula 
		   (if (evenp (gv (kr-path 0 :parent) :quadrant)) 3.14 4.71)))
	; ANGLE2 is always pi/2
	(:angle2  1.57))
     ; Arrowhead for the top arc always attaches at midpoint of destination node
     (:top-arrowhead ,opal:Arrowhead
	(:open-p NIL)
	(:filling-style ,opal:Black-fill)
	; These arrow-heads need to be a little wider
	(:diameter 14)
	(:head-x ,(o-formula (case (gv (kr-path 0 :parent) :quadrant)
			       (1 (- (gv (kr-path 0 :parent) :right)
				     (floor (gv (kr-path 0 :parent) :target-width) 2)))
			       (2 (+ (gv (kr-path 0 :parent) :left)
				     (floor (gv (kr-path 0 :parent) :target-width) 2)))
			       (3 (gv (kr-path 0 :parent) :left))
			       (t (gv (kr-path 0 :parent) :right)))))
	(:head-y ,(o-formula (case (gv (kr-path 0 :parent) :quadrant)
			       ((1 2) (gv (kr-path 0 :parent) :top))
			       ((3 4) (+ -14 (gv (kr-path 0 :parent) :bottom))))))
	(:from-x ,(o-formula (gv (kr-path 0 :parent) :top-label-box :left)))
	(:from-y ,(o-formula (gv (kr-path 0 :parent) :top-label-box :top))))
     (:bottom-arrowhead ,opal:Arrowhead
	(:open-p NIL)
	(:filling-style ,opal:Black-fill)
	; These arrow-heads need to be a little wider
	(:diameter 14)
	(:head-x ,(o-formula (case (gv (kr-path 0 :parent) :quadrant) 
			       (1 (gv (kr-path 0 :parent) :right))
			       (2 (gv (kr-path 0 :parent) :left))
			       (3 (+ (gv (kr-path 0 :parent) :left)
				     (floor (gv (kr-path 0 :parent) :target-width) 2)))
			       (t (- (gv (kr-path 0 :parent) :right)
				     (floor (gv (kr-path 0 :parent) :target-width) 2))))))
	(:head-y ,(o-formula (case (gv (kr-path 0 :parent) :quadrant)
			       ((1 2) (+ 14 (gv (kr-path 0 :parent) :top)))
			       ((3 4) (gv (kr-path 0 :parent) :bottom)))))
	; Bottom arrowhead looks better angled further right
	(:from-x ,(o-formula (gv (kr-path 0 :parent) :bottom-label-box :left)))
	(:from-y ,(o-formula (+ (gv (kr-path 0 :parent) :bottom-label-box :top) 20))))
     (:top-label-box ,opaque-label
	(:top ,(o-formula (+ (gv (kr-path 0 :parent) :top)
			     (round (* 0.25 (gv (kr-path 0 :parent) :height))))))
	(:left ,(o-formula (+ (gv (kr-path 0 :parent) :left)
			      (round (* (gv (kr-path 0 :parent) :width)
					(if (oddp (gv (kr-path 0 :parent) :quadrant)) 0.15 0.7))))))
	(:label ,(o-formula (gv (kr-path 0 :parent) :top-label))))
     (:bottom-label-box ,opaque-label
	(:top ,(o-formula (+ (gv (kr-path 0 :parent) :top)
			    (round (* 0.65 (gv (kr-path 0 :parent) :height))))))
	(:left ,(o-formula (+ (gv (kr-path 0 :parent) :left)
			      (round (* (gv (kr-path 0 :parent) :width)
					(if (oddp (gv (kr-path 0 :parent) :quadrant)) 0.6 0.3))))))
	(:label ,(o-formula (gv (kr-path 0 :parent) :bottom-label)))))))

(defun make-arc (source dest label)
"Creates an arc from <source> node to <dest> node with  <label>"
  (let ((newarc (create-instance NIL arc
		   ;angle between source and dest
		   (:theta (o-formula (atan (- (gv dest :left) (gv source :left))
					    (- (gv dest :top) (gv source :top)))))
		   ;distance between center of dest and bounding ellipse
		   (:r (o-formula 
			(sqrt (+ (expt (* (cos (gvl :theta))
					  (/ (gv dest :frame :width) 2)) 2)
				 (expt (* *halfnodeheight* 
					  (sin (gvl :theta))) 2)))))
		   (:x1 (o-formula (+ (gv source :left)
				      (floor (gv source :frame :width) 2))))
		   (:y1 (o-formula (+ (gv source :top) *halfnodeheight*)))
		   (:x2 (o-formula 
			 (truncate (+ (gv dest :left)
				      (/ (gv dest :frame :width) 2)
				      (* (- *halfnodeheight*)
					 (/ (gv dest :frame :width) 2)
					 (sin (gvl :theta)) (/ (gvl :r)))))))
		   (:y2 (o-formula 
			 (truncate (+ (gv dest :top) *halfnodeheight*
				      (* (- *halfnodeheight*)
					 (/ (gv dest :frame :width) 2)
					 (cos (gvl :theta)) (/ (gvl :r)))))))
		   (:label1 label))))
    (push (make-cable newarc source) (g-value dest :up-cables))
    (push (make-cable newarc dest) (g-value source :down-cables))
    newarc))

;(defun make-double-arc (source dest-sneps-node label1 label2)
;"Creates two rounded arcs between <source> and <dest> with <label1> on the top-
;most arc and <label2> on the bottom-most arc"
;(let ((node-name (intern (stringify.gn dest-sneps-node) 'xginseng)))
;  (set node-name
;       (create-instance NIL node
;	      (:box (o-formula (list (+ (gv source :left) 100))))
;	      (:left (o-formula (first (gvl :box))))
;	      ; :top formula constrains this node to same :top as <source>
;	      (:top (o-formula (second (gv source :box))))
;	      (:sneps-node dest-sneps-node)
;	      (:name (format nil "~A" (sneps:node dest-sneps-node)))))
;  (opal:add-component display-aggregate (eval node-name))
;  (setf newarcs (create-instance NIL double-arc
;                  (:left (o-formula (if (gvl :on-right-p)
;					(+ (gv source :left) *halfnodeheight*)
;				      (+ (gv (eval node-name) :left) *halfnodeheight*))))
;		  (:top (o-formula (+ (gv source :top) *halfnodeheight*)))
;		  (:right (o-formula (if (gvl :on-right-p)
;					(+ (gv (eval node-name) :left) *halfnodeheight*)
;				      (+ (gv source :left) *halfnodeheight*))))
;		  (:width (o-formula (abs (- (gv source :left) (gv (eval node-name) :left)))))
;		  (:on-right-p (o-formula (< (gv source :left) (gv (eval node-name) :left))))
;		  (:top-label label1)
;		  (:bottom-label label2)))
;  (opal:add-component display-aggregate newarcs :back)
;  (opal:update display-window)))

;; MAKE-DOUBLE-ARC for unconstrained arcs
(defun make-double-arc (source dest label1 label2)
"Creates two rounded arcs between <source> and <dest> with <label1> on the top-
most arc and <label2> on the bottom-most arc"
  (declare (special display-aggregate))
  (let ((newarcs (create-instance NIL double-arc
		   (:quadrant (o-formula 
			       (if (> (gv source :top) (gv dest :top))
				   (if (< (gv source :left) (gv dest :left))
				       1	; dest is in source's 1st quadrant
				       2)	; else dest is in its 2nd quadrant
				   (if (> (gv source :left) (gv dest :left))
				       3	; dest is in source's 3rd quadrant
				       4))))	; else dest is in its 4th quadrant
		   (:left (o-formula 
			   (case (gvl :quadrant)
			     ((1 4) (+ (gv source :left) (floor (gv source :width) 2)))
			     (t (+ (gv dest :left) (floor (gv dest :width) 2))))))
		   (:top (o-formula 
			  (case (gvl :quadrant)
			    ((1 2) (+ *halfnodeheight* (gv dest :top)))
			    (t (+ *halfnodeheight* (gv source :top))))))
		   (:right (o-formula 
			    (case (gvl :quadrant)
			      ((1 4) (+ (gv dest :left) (floor (gv dest :width) 2)))
			      (t (+ (gv source :left) (floor (gv source :width) 2))))))
		   (:bottom (o-formula 
			     (case (gvl :quadrant)
			       ((1 2) (+ *halfnodeheight* (gv source :top)))
			       (t (+ *halfnodeheight* (gv dest :top))))))
		   (:width (o-formula (abs (- (+ (gv source :left) (floor (gv source :width) 2))
					      (+ (gv dest :left) (floor (gv dest :width) 2))))))
		   (:height (o-formula (abs (- (gv source :top) (gv dest :top)))))
		   (:target-width (o-formula (gv dest :width)))
		   (:top-label label1)
		   (:bottom-label label2))))
    (push (make-cable newarcs dest) (g-value source :down-cables))
    (push (make-cable newarcs source) (g-value dest :up-cables))
    (opal:add-component display-aggregate newarcs :back)
    (opal:update display-window)))






