;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: sindexing.lisp,v 1.1 1993/07/17 02:16:40 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;------------------------------------------------------------------------
;    get-rule-use-info by using s-indexing
;------------------------------------------------------------------------

(defun get-rule-use-info-sindexing (report cqch)
  "Modified 'get-rule-use-info' for the S-indexing method that is applied 
   when a rule's antecedents have the same set of variables. 
   It returns the set of rule-use-infos which are compatible with
   the reported instance.
   The data structure of cqch for S-indexing is:
      <cqch> = (<channel> <antecedents> <sindex-ruiset>)
      <sindex-ruiset> = ((<sindex> <rui>) (<sindex> <rui>) ...)
            sindex-ruiset is initially empty.                       "
  
  (let* ((ant (signature.rep report))
	 (sbst (subst.rep report))
	 (sign (sign.rep report))
	 (supp (support.rep report))
	 (ch (channel.cqch cqch))
	 (ants (ants.cqch cqch))
	 (sindex-ruiset (ruiset.cqch cqch))
	 ; sindex is obtained from variable substiutions.
	 ; e.g., sbst = ((v1 . a) (v2 . b))
	 ;       sindex = (a b)
	 (sindex (mapcar #'cdr (restrict.sbst sbst (sneps::all-vars.n *NODE*))))
	 (ruis (rest (assoc sindex sindex-ruiset :test 'equal)))
	 (result nil))

    ; build an initial (skeleton) rui for a given sindex
    ; if there is no corresponding rui associated with the sindex

    (when (null ruis)
      (setq ruis
	    (request-all
	     (makeone.ruis
	      (make.rui (filter.ch ch)
			0
			0
			(nodeset-to-fnodeset ants)
			nil))))
      (setq sindex-ruiset (acons sindex ruis sindex-ruiset)))

    ; update existing rui with the current instance
    (let* ((rui (choose.ruis ruis))
	   (flag (flag.fns ant (fns.rui rui))))
      (cond ((or (null (fns.rui rui))
		 (eq flag 'UNKNOWN) (eq flag 'REQUESTED))
	     (setq ruis
		   (makeone.ruis
		     (update.rui
		       (make.rui (union.sbst (subst.rui rui) sbst)
				 (poscount.rui rui)
				 (negcount.rui rui)
				 (fns.rui rui)
				 (remarkedp.rui rui))
		       ant supp sign)))
	     (rplacd (assoc sindex sindex-ruiset :test 'equal) ruis)
	     (setq result ruis))

	    (t (setq ruis
		     (makeone.ruis
		       (make.rui (subst.rui rui)
				 (poscount.rui rui)
				 (negcount.rui rui)
				 (update.fns (fns.rui rui) ant supp flag)
				 (remarkedp.rui rui))))
	       (rplacd (assoc sindex sindex-ruiset :test 'equal) ruis)
	       (setq result nil))))
    
    ; update the *rule-use-channels* register with new sindex-ruiset
    (setq *RULE-USE-CHANNELS*
	  (update.cqchset
	   (make.cqch ch ants sindex-ruiset)
	   *RULE-USE-CHANNELS*)) 
    result))


