;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: nor.lisp,v 1.4 1993/06/04 06:27:08 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;  nor functions
;
(defun rule-handler.nor (ant-report cqch)
  (let ((updated-ruiset (ruiset.cqch cqch)))
    (do.set (rui (get-rule-use-info ant-report cqch) t)
      (case (sign.rep ant-report)
	(POS  (let ((restr (make.restr (subst.rui rui)))
		    (ch (channel.cqch cqch)))
		(unless-remarkedp.rui
		  rui (remark '"~%I know it is not the case that"
			      (makeone.ns (destination.ch ch))
			      restr))
		(send-reports
		  (makeone.repset
		    (make.rep
		      (restrict.sbst (subst.rui rui)
				     (freevars.n (destination.ch ch)))
		      (compute-new-support.nor ch rui ant-report)
		      'NEG
		      *NODE*
		      nil
		      (context.ch ch)
		      ))
		  ch)))
	(NEG (let ((restr (make.restr (subst.rui rui)))
		   (ch (channel.cqch cqch)))
	       (unless-remarkedp.rui
		 rui (remark '"~%It is the case that"
			     (makeone.ns (destination.ch ch))
			     restr))
	       (send-reports
		 (makeone.repset
		   (make.rep  
		     (restrict.sbst (subst.rui rui)
				    (freevars.n (destination.ch ch)))
		     (compute-new-support.nor ch rui ant-report)
		     'POS
		     *NODE*
		     nil
		     (context.ch ch)
		     ))
		 ch))))
      (setq updated-ruiset (update.ruis rui updated-ruiset))
      (setq *RULE-USE-CHANNELS*
	    (update.cqchset (make.cqch (channel.cqch cqch)
				       (ants.cqch cqch)
				       updated-ruiset)
			    *RULE-USE-CHANNELS*)))))

; =============================================================================
;

(defun usability-test.nor (sign)
  (declare (ignore sign))
  (or (isnew.ns (quantified-vars.n *NODE*))
      (not (isnew.ns (nodeset.n *NODE* 'sneps::forall)))))


;
;
; =============================================================================
;
; compute-new-support.nor
; -------------------------
;
;       arguments     : ch     - <channel>
;                       rui    - <rule-use-info>
;                       antrep - <report>
;
;       returns       : <support>
;
;       description   : Computes a new support based on:
;                        1- the support of the rule node if it is asserted;
;                        2- the support of the instances (of the rule) which
;                           are asserted in the 'ch' context and has the 
;                           appropriate substitution. 
;
;
;
;                                        written :  cpf/njm  10/25/88
;                                        modified: 
;
;
(defun compute-new-support.nor (ch rui antrep)
  (let ((crntct (context.ch ch))
	(newsupport (new.sup))
	(freevars (freevars.n *NODE*)))
    (if (and (isassert.n *NODE*)
    	     (eql (cardinality.ns (nodeset.n *NODE* 'sneps:arg)) 1)
	     (eq (sign.rep antrep) 'POS))
	(setq newsupport (support.rep antrep))
	(setq newsupport (change-tag-support (support.rep antrep))))
    (when *KNOWN-INSTANCES*
      (do.set (inst *KNOWN-INSTANCES*)
	(let* ((instnode (match::applysubst *NODE* (subst.inst inst)))
	       (supinstnode (filter.sup (sneps:node-asupport instnode) crntct)))
	  (when (and (not (isnew.sup supinstnode))
		     (match:issubset.sbst (restrict.sbst (subst.rui rui) freevars)
					  (restrict.sbst (subst.inst inst) freevars)))
	    (setq newsupport (merge.sup newsupport
					(compute-new-support1.nor (support.rep antrep)
								  supinstnode)))))))
    newsupport))
;
; =============================================================================
;
; compute-new-support1.nor
; -----------------------
;
;       arguments     : sup  - <support>
;                       supr - <support>
;
;       returns       : <support>
;
;       description   : receives as arguments:
;                        'sup'  -- the support of the report
;                        'supr' -- the support of the rule node
;                       Computes a new support based on 'sup' and on the support
;                       of the `supr'.
;
;
;
;                                        written :  cpf/njm  10/25/88
;                                        modified: 
;
;
(defun compute-new-support1.nor (sup supr)
  (let ((newsupport (new.sup)))
    (do* ((s1 supr (others.sup s1))
	  (ot1 (ot.sup s1) (ot.sup s1))
	  (cts1 (ctset.sup s1) (ctset.sup s1)))
	 ((isnew.sup s1) newsupport)
      (dolist (ct1 cts1)
	(do* ((s2 sup (others.sup s2))
	      (ot2 (ot.sup s2) (ot.sup s2))
	      (cts2 (ctset.sup s2) (ctset.sup s2)))
	     ((isnew.sup s2) t)
	  (dolist (ct2 cts2)
	    (setq newsupport
		  (insert.sup (combine-ots ot1 ot2)
			      (fullbuildcontext (new.ns) (make.cts ct1 ct2))
			      newsupport))))))))


; 
;
; =============================================================================
;
; change-tag-support
; ------------------
;
;       arguments     : sup - <support>
;                       
;       returns       : <support>
;
;       description   : receives as arguments:
;                        'sup'  -- the support of the rule node
;                       Changes the tags of support 'sup':
;
;
;
;                                        written :  njm  11/20/88
;                                        modified: 
;
;
(defun change-tag-support (sup)
  (let ((newsupport (new.sup)))
    (do* ((s sup (others.sup s))
	  (ot (ot.sup s) (ot.sup s))
	  (cts (ctset.sup s) (ctset.sup s)))
	 ((isnew.sup s) newsupport)
      (dolist (ct cts)
	(setq newsupport
	      (insert.sup (if (equal ot 'sneps:HYP) 'sneps:DER ot)
			  ct
			  newsupport))))))





