;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: add.lisp,v 1.6 1993/07/20 06:25:30 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; add
; ---
;
;       arguments     : snd - <snepsul node description>
;
;       returns       : <node set>
;
;       description   : top-level SNePSUL function which adds a node to the
;                       network and then tries to do forward inference
;                       using it.
;
;       side-effects  : may build new nodes in the network.
;                       Initiates the variable 'crntctname' with the name given
;                       by the user to the context where the inference must be 
;                       done.
;
;                                        written :  rgh  4/20/86
;                                        modified:  scs  3/24/88
;                                        modified:  njm/cpf 10/19/88
;                                        modified:  njm 11/24/88
;                                                   hc  07/18/93
;
(defsnepscom add ((&rest snd) (top ns bns fns))
  (let* ((crntct (sneps:processcontextdescr snd))
	 (crntctname crntct))
    (declare (special crntct crntctname))
    (values (add* (sneps::nseval (cons 'sneps:assert snd)))
	    crntctname)))

;
; =============================================================================
;
; add*
; ----
;
;       arguments     : new-nodes - <nodefun set>
;
;       returns       : <nodefun set>
;
;       description   : see add
;
;       side-effects  : see add
;
;                                        written :  rgh  4/20/86
;                                        modified:  scs  4/20/88
;                                        modified:  njm/cpf 10/19/88
;                                                   hc/njm  04/26/89
;
(defun add* (new-nodes)
  (declare (special *ADDED-NODES* crntct))
  (let ((inference-context (sneps:value.sv crntct))
	new-nodefun pr)
    (when-intensional-contexts
     ;; Use the context name
     (setq inference-context crntct))
    (setq *ADDED-NODES* new-nodes)	;special var
    (if (isnew.ns new-nodes) *ADDED-NODES*)
    (setq new-nodefun (choose.ns new-nodes))
    (when (ismol.n new-nodefun)
      (activate.n new-nodefun)
      (setq pr (activation.n new-nodefun))
      (regstore pr '*REPORTS*
		(insert.repset
		 (make.rep (new.sbst)
			   (filter.sup (sneps:node-asupport new-nodefun)
				       (sneps:value.sv crntct))
			   'POS
			   'USER
			   new-nodefun
			   inference-context)
		 (regfetch pr '*REPORTS*)))
      (regstore pr '*PRIORITY* 'HIGH)
      (multip (dequeue:insert-rear pr (dequeue:new)) (dequeue:new)))
    *ADDED-NODES*))
;
;
; =============================================================================
