;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: toplevel.lisp,v 1.8 1993/07/17 07:53:30 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


(defvar *snepslog-prompt* '\:)


(defun snepslog (&key 
		 (inunit *standard-input*)
		 (outunit *standard-output*)
		 (hello-text
		  (format
		   nil
		   "~%   Welcome to SNePSLOG (A logic interface to SNePS)~
    ~2%Copyright (C) 1984, 88, 89, 93 by Research Foundation of State~
     ~%University of New York. SNePS comes with ABSOLUTELY NO WARRANTY!~
     ~%Type `copyright' for detailed copyright information.~
     ~%Type `demo' for a list of example applications.~%"))
		 (bye-text "Bye"))
"Enters in the  SNePSLOG environment"
  (in.environment
    :variables ((*package* (find-package 'snepsul))
		(*print-length* nil)
		(*print-level* nil)
		(*print-pretty* t)
		(old-infertrace snip:*infertrace*))
    :functions ((surface 'snepslog:surface)
		(slight-surface #'snepslog:slight-surface)
		(node-intern #'snepslog:node-intern)
		(sneps-node? #'snepslog:sneps-node?))
    :eval (progn
	    (setq snip:*infertrace* :surface)
	    (snepslog-init hello-text) 
	    (snepslog-loop)
	    (format outunit "~%~A~%" Bye-text))
    :always.do.this (progn (setq snip:*infertrace* old-infertrace)
			   (snepslog:snepslogreadoff)
			   nil)))


(defun snepslog-init (hello)
  "Initializes the sneps environment"
  (format outunit "~%~A~%" hello)
  ;; There is a new canonical relation that should be kept.
  (setq *initial-relations*
	(adjoin 'snepsul:r *initial-relations*))
  (when *sneps-setup-flag*
    (sneps-setup)
    (setq *sneps-setup-flag* nil)))


(Defun Snepslog-Loop ()
  "Executes a read eval print loop"
  (let (command demo-start-time oldtime newtime result eof?)
    (declare (special demo-start-time))
    (with-demo-control (inunit ((snepslog:snepslog-read nil)
			        (pseudolisp-read nil)))
      (unwind-protect
	  (catch :snepslog-end
	    (loop
	      (catch 'sneps-error
		(format outunit "~A " *snepslog-prompt*)
		(setq demo-start-time nil)
		(multiple-value-setq (command eof?)
		  (snepslog:snepslog-read inunit))
		;; GC time=0 until function found.
		(setq oldtime (or demo-start-time
				  (list (get-internal-run-time) 0))
		      result (topsneval command)
		      newtime (list (get-internal-run-time) 0))
		(format outunit "~&~%")
		(snepslog:snepslog-print result outunit)
		(set.sv 'lastcommand command)
		(sneps-timer oldtime newtime))
	      ;;(when eof? (return))
	      ))))))

