;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: packages.lisp,v 1.9 1993/07/21 08:47:49 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :user)


(defvar *sneps-packages*
  '(:logical-pathnames
    :sneps
    :dequeue
    :multi
    :match
    :snip
    :snebr
    :snepslog
    :englex
    :parser
    #+explorer :ginseng
    :xginseng
    :snepsul)
  "The list of packages used by the SNePS system")


;; Create all packages:
;;
(dolist (package *sneps-packages*)
  (unless (find-package package)
    (make-package package :use '(:lisp))))

#+explorer
(use-package '(:ticl) :ginseng)

;; Shadow various symbols inherited from the LISP package:
;;
(shadow '(find describe + - * ^ = > assert
          #+clisp !)
	(find-package 'sneps))

(shadow '(print delete)
	(find-package 'dequeue))

(shadow '(conjugate getf)
	(find-package 'englex))

(shadow '(* call getf push pop)
	(find-package 'parser))
