;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MATCH; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: supmatchingset.lisp,v 1.3 1993/06/04 06:22:22 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :match)


;;; -----------------------------------------------------------------------------
;;;       Ported from Franz Lisp to Common Lisp:   KEB  Summer 1987
;;; -----------------------------------------------------------------------------
;;;
;;;
;;; =============================================================================
;;; Data Type:  <supmatching set> ::=  { <supmatching>  <supmatching> ... <supmatching> }
;;;
;;; =============================================================================
;;;
;;; new.supmatchingset
;;; ------------------
;;;
;;;       arguments     : none 
;;;
;;;       returns       : <supmatching set> 
;;;
;;;       description   : makes a new <supmatching set> 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro new.supmatchingset ()
  "Makes a new <supmatching set>"
  `())
;;;
;;; ============================================================================= 
;;;
;;; makeone.supmatchingset
;;; ----------------------
;;;
;;;       arguments     : supmatching - <supmatching> 
;;;
;;;       returns       : <supmatching set> 
;;;
;;;       description   : makes a singleton <supmatching set> from 'supmatching'. 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro makeone.supmatchingset (supmatching)
  "Makes a singleton <supmatching set> from 'supmatching'."
  `(list ,supmatching))
;;;
;;; ============================================================================= 
;;;
;;; putin.supmatchingset
;;; --------------------
;;;
;;;       arguments     : supmatching    - <supmatching>
;;;                       supmatchingset - <supmatching set>
;;;
;;;       returns       : <supmatching set>
;;;
;;;       description   : Returns a new <supmatching set> with 'supmatching' 
;;;                       inserted in 'supmatchingset'.
;;;
;;;                                        written   :  cpf/njm 10/19/88 
;;;
;;;
(defmacro putin.supmatchingset (supmatching supmatchingset)
  "Returns a new <supmatching set> with 'supmatching' inserted in
   'supmatchingset'"
  `(cons ,supmatching ,supmatchingset))   
;;;
;;;
;;; =============================================================================
;;;
;;; choose.supmatchingset
;;; ---------------------
;;;
;;;       arguments     : supmatchingset - <supmatching set> 
;;;
;;;       returns       : <supmatching> 
;;;
;;;       description   : returns a <supmatching> from <supmatching set> 
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro choose.supmatchingset (supmatchingset)
  "Returns a <supmatching> from <supmatching set>."
  `(first ,supmatchingset))
;;;
;;;
;;; =============================================================================
;;;
;;; others.supmatchingset
;;; ---------------------
;;;
;;;       arguments     : supmatchingset - <supmatching set> 
;;;
;;;       returns       : <supmatching set> 
;;;
;;;       description   : returns a <supmatching set> like 'supmatchingset', except
;;;                       that the element that would be chosen by
;;;                       choose.supmatchingset is removed.
;;;
;;;                                        written :  cpf/njm 10/19/88
;;;                                        modified:
;;;
;;;
(defmacro others.supmatchingset (supmatchingset)
  "Returns a <supmatching set> like 'supmatchingset', except
   that the element that would be chosen by
   choose.supmatchingset is removed."
  `(rest ,supmatchingset))
;;;
;;;
;;; =========================================================================== 

(defmacro do.supmatchingset ((var supmatchingsetform &optional resultform) &body forms)
  `(dolist (,var ,supmatchingsetform ,resultform) ,@forms))

; =============================================================================
;
; isnew.supmatchingset
; --------------------
;
;       arguments     : ms - <supmatching set>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "ms" is a <new supmatching set>,
;                               "false" otherwise
;
;                                        written :  cpf/njm 10/19/88
;                                        modified:
;
;
(defmacro isnew.supmatchingset (ms)
  `(null ,ms))
;
;
; =============================================================================
;
; matchingset-to-supmatchingset
; -----------------------------
;
;       arguments     : ms - <matching set>
;                       ct - <context>
;
;       returns       : <supmatching>
;
;       description   : returns "true" if "ms" is a <new supmatching set>,
;                               "false" otherwise
;
;                                        written :  njm 10/19/88
;                                        modified:
;
;
(defmacro matchingset-to-supmatchingset (ms ct)
  `(let ((newsupmatch (new.supmatchingset)))
     (do.matchingset (m ,ms newsupmatch)
       (setq newsupmatch
	     (putin.supmatchingset
	       (make.supmatching (tnode.matching m) 
				 (target-sub.matching m)
				 (snip:filter.sup
				   (sneps:node-asupport (tnode.matching m))
				   ,ct)
				 (source-sub.matching m))
	       newsupmatch)))))
;
;
; =============================================================================
