;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MATCH; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: matchingset.lisp,v 1.3 1993/06/04 06:22:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :match)


;;; -----------------------------------------------------------------------------
;;;       Ported from Franz Lisp to Common Lisp:   KEB  Summer 1987
;;; -----------------------------------------------------------------------------
;;;
;;;
;;;
;;; =============================================================================
;;; Data Type:  <matching set> ::=  { <matching>  <matching> ... <matching> }
;;;
;;; =============================================================================
;;;
;;; makeone.matchingset
;;; -------------------
;;;
;;;       arguments     : matching - <matching> 
;;;
;;;       returns       : <matching set> 
;;;
;;;       description   : makes a singleton <matching set> from 'matching'. 
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:
;;;
;;;
#|
(defmacro makeone.matchingset (matching)

  "Makes a singleton <matching set> from 'matching'."

  `(list ,matching))
|#
;;;
;;; ============================================================================= 
;;;
;;; make.matchingset
;;; ----------------
;;;
;;;       arguments     : uniset - <unification set>
;;;                       tnode - <target node>     <- added:  KEB 06/20/87
;;;
;;;       returns       : <matching set>
;;;
;;;       description   : Builds a <matching set> from <matching>s made
;;;                       by combining each <unification> from uniset with
;;;                       the one <target node> tnode.
;;;
;;;                                        written   :   vhs [I guess]
;;;                          converted and commented :   KEB 06/20/87
#|
(defun make.matchingset (uniset tnode)
  "Builds a <matching set> from <matching>s made
   by combining each <unification> from uniset with
   the one <target node> tnode."
  (declare (special *RENAMESUB* *CHANGED* *MNRS* *SUB*))
  (mapcan
   (function
    (lambda (uni)
      (let ((*SUB* (substitution.uni uni))
	    (*MNRS* (mnoderepset.uni uni))
	    (*CHANGED* (mnodeset.uni uni)))
	(makeone.matchingset 
		(make.matching tnode
		     (make.srcsub *RENAMESUB*)
		     (complete.targetsub *SUB*))))))
   uniset))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; choose.matchingset
;;; ------------------
;;;
;;;       arguments     : matchingset - <matching set> 
;;;
;;;       returns       : <matching> 
;;;
;;;       description   : returns a <matching> from <matching set> 
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:
;;;
;;;
#|
(defmacro choose.matchingset (matchingset)

  "Returns a <matching> from <matching set>."

  `(first ,matchingset))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; others.matchingset
;;; ------------------
;;;
;;;       arguments     : matchingset - <matching set> 
;;;
;;;       returns       : <matching set> 
;;;
;;;       description   : returns a <matching set> like 'matchingset', except
;;;                       that the element that would be chosen by
;;;                       choose.matchingset is removed.
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:
;;;
;;;
#|
(defmacro others.matchingset (matchingset)

  "Returns a <matching set> like 'matchingset', except
   that the element that would be chosen by
   choose.matchingset is removed."

  `(rest ,matchingset))
|#
;;;
;;;
;;; =========================================================================== 

(defmacro do.matchingset ((var matchingsetform &optional resultform) &body forms)
  `(dolist (,var ,matchingsetform ,resultform) ,@forms))

; =============================================================================
;
; isnew.matchingset
; -----------------
;
;       arguments     : ms - <matching set>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "ms" is a <new matching set>,
;                               "false" otherwise
;
;                                        written :  rgh 07/30/85
;                                        modified:
;
;
(defmacro isnew.matchingset (ms)
  `(null ,ms))
;
;
;================================================================================
