;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MATCH; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: matching.lisp,v 1.3 1993/06/04 06:22:10 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :match)


;;; --------------------------------------------------------------------------
;;;       Ported from Franz Lisp to Common Lisp:   KEB  Summer 1987
;;; --------------------------------------------------------------------------
;;;
;;;
;;; =============================================================================
;;; Data Type:  <matching> ::= (<target node> <target substitution> <source substitution>)
;;;
;;; =============================================================================
;;;
;;; make.matching
;;; -------------
;;;
;;;       arguments     : tnode - <target node>
;;;                       srcsub - <source substitution>
;;;                       tsub - <target substitution>
;;;                        
;;;       returns       : <matching> 
;;;
;;;       description   : makes a <matching> from 'tnode', 'srcsub', and 'tsub'
;;;
;;;                                        written :  vhs 04/09/85
;;;                                        modified:  scs 02/11/88
;;;                                        modified:  scs 05/12/88
;;;
;;;
#|
(defmacro make.matching (tnode srcsub tsub)
  "Makes a <matching> from 'tnode', 'srcsub', and 'tsub'."
  `(list ,tnode ,tsub ,srcsub))
|#
;;;
;;;
;;; =============================================================================
;;;
;;; tnode.matching
;;; --------------
;;;
;;;       arguments     : matching - <matching> 
;;;
;;;       returns       : <node> 
;;;
;;;       description   : returns the <tnode> of 'matching'
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:
;;;
;;;
(defmacro tnode.matching (matching)
  "Returns the <tnode> of 'matching'."
  `(first ,matching))
;;;
;;;
;;; =============================================================================
;;;
;;; source-sub.matching
;;; -------------------
;;;
;;;       arguments     : matching - <matching> 
;;;
;;;       returns       : <source substitution> 
;;;
;;;       description   : returns the <source substitution> of 'matching'. 
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:  rgh 07/10/85
;;;
;;;
(defmacro source-sub.matching (matching)
  "Returns the <source substitution> of 'matching'."
  `(third ,matching))
;;;
;;;
;;; =============================================================================
;;;
;;; target-sub.matching
;;; -------------------
;;;
;;;       arguments     : matching - <matching>
;;;
;;;       returns       : <target substitution> 
;;;
;;;       description   : returns the <target substitution> of 'matching'. 
;;;
;;;                                        written :  vhs 06/08/85
;;;                                        modified:  rgh 07/10/85
;;;
;;;
(defmacro target-sub.matching (matching)
  "Returns the <target substitution> of 'matching'."
  `(second ,matching))
;;;
;;; ==========================================================================
