;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: USER; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: load-sneps.lisp,v 1.22 1993/09/17 08:51:38 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :user) 


;; Key to Features:
;;
;;   unix      --      UNIX operating system
;;   lm-unix   --      Lisp-Machine using a Unix file server
;;   explorer  --      Texas Instruments Explorer
;;   symbolics --      Symbolics Lisp Machine
;;   vms       --      VAX/VMS operating system
;;   allegro   --      Allegro Common-Lisp (Franz Inc.)
;;   lucid     --      Lucid (or Sun) Common-Lisp
;;   cmu       --      CMU Common-Lisp
;;   clisp     --      CLISP by Bruno Haible and Michael Stoll
;;   multimax  --      Kyoto Common Lisp running on an Encore Multimax


;; Installation instructions (short version, for details see `README'):

;; - Edit `*sneps-directory' (below) to reflect the location (top-level
;;   directory) of your SNePS directory tree.
;; - If you have GARNET installed at your site edit `*sneps-garnet-directory*'
;;   to reflect the directory in which your GARNET load files reside.
;; - If you did rename all Lisp files to conform to the default extension
;;   of your Common-Lisp then edit `*sneps-lisp-extension*' accordingly
;;   (renaming Lisp files is not mandatory even if your Common-Lisp does not
;;   use `.lisp' as its default extension).
;; - Invoke your Common-Lisp and load this file (if you have GARNET installed
;;   at your site make sure your DISPLAY variable is set properly).
;; - Select option `e' (the installation option) from the initial menu.
;; - Ignore all the warnings you'll get during compilation.
;; - If the compilation completed successfully then you are done with the
;;   installation, exit your Common-Lisp.
;; - Optionally set `*sneps-noquery*' (below) to T and `*sneps-verbose*' to NIL
;; - To load SNePS simply load this file and select option `a' from the
;;   initial menu (if you set `*sneps-noquery*' to T you won't be asked).
;; - Run `(sneps)' or `(snepslog)' once SNePS is loaded.


#+allegro (excl:set-case-mode :case-insensitive-upper)

;;;;;;;;;;;;;;;;;;;; User customization section ;;;;;;;;;;;;;;;;;;;;

;; Edit the following pathname definitions according to the
;; system you are using (do not include final directory delimiters,
;; be careful with case for Unix pathnames):

(defvar *sneps-directory*
    #+unix      "/sneps/release"
    #+explorer  "sneps:sneps.release"
    #+symbolics "sneps:>sneps>release"
    #+vms       "sneps:[sneps.release"
    "The root of the SNePS directory tree.")

(defvar *sneps-garnet-directory*
    #+unix      "/garnet"
    #+explorer  "sys:garnet"
    #+symbolics "sys:>garnet"
    #+vms       "sys:[garnet"
    "The directory that contains the load files of your GARNET installation.
Ignore this variable if you do not have GARNET installed at your site.")

(defvar *sneps-patch-directory* *sneps-directory*
  "The directory used in the definition of the logical host `sneps-p'.
It allows one to load SNePS with user supplied patches that do not
reside in `*sneps-directory*'. Ignore this variable unless you make
modifications to SNePS.")

(defvar *sneps-lisp-extension* "lisp"
  "File extension used for Lisp files of the SNePS distribution.
The default corresponds to the extension that comes with the standard
SNePS distribution. Ignore this variable unless you decided to rename all
Lisp files to conform to the default extension used by your Common-Lisp.")

(defvar *sneps-default-lisp-extension* nil
  "If non-NIL the default extension used for Lisp files at your site.
The defaults provided should probably be ok. Ignore this variable unless
you run into problems with the loading of GARNET files.")

(defvar *sneps-binary-extension* nil
  "If non-NIL this is the file extension used for compiled Lisp files.
Because these files are generated by your compiler the defaults provided
will probably be ok. Ignore this variable unless you run into problems
with the loading of compiled Lisp files.")

(defvar *sneps-noquery* nil
  "If this is non-NIL SNePS is loaded without any user interaction.
Use only once the system has been installed and compiled properly.")

(defvar *sneps-verbose* *load-verbose*
  "Set this to T if you want verbose loading of SNePS files.")

(defvar *sneps-load-old-englex* nil
  "If this is T the old englex package is loaded instead of
Chris Lusardi's new implementation (for compatibility with old stuff).")

(defvar *sneps-load-snip22* t
  "If this is T Choi's new version of SNIP will be loaded.
This is a temporary kludge until his stuff is properly merged with
the standard SNePS release.")

(defvar *sneps-user-translations* nil
  "List of user supplied logical pathname translations (see below).
Changing the value of this variable after this file was loaded
will not have any effect.")

;;;;;;;; end of user customization (below at your own risk) ;;;;;;;;


;; Deal with an old Allegro-3.x problem:
#+allegro (proclaim '(notinline LAST))

;; Symbolic version information (the revision name should match the
;; CVS tag that was used to tag this release):
(defparameter *sneps-version*
  (format nil "1.400 (~a)"
	  (let ((date-string "$Date: 1993/09/17 08:51:38 $"))
	    (if (char-equal (aref date-string 0) #\$)
		(subseq date-string 7 26)
		date-string))))

(defvar *sneps-make-option* :load
  "Used as a value for the MODE parameter of `make-simple-system'.")

(defvar *sneps-optional-systems*
    '("sneps:xginseng;load-xginseng.LISP"
      "sneps:demo;snactor;load-snactor.LISP"
      "sneps:demo;snactor;blocksworld;load-blocks-snactor.LISP"
      "sneps:demo;snactor;arcinfo;load-arc-snactor.LISP"
      "sneps:demo;activation;load-activation.LISP")
  "List of optional SNePS system files that need to be installed.")

(defun sneps-startup-query ()
  (format t 
	  "~%~%Do you want to load SNePS

    a) FAST (i.e., just load compiled files)
    b) by compiling source files that are newer than their 
       compiled version before they get loaded
    c) by compiling all source files before they get loaded
    d) by loading uncompiled source files only
    e) by compiling all source files before they get loaded plus
       compiling and loading all optional systems (installation option)

    Type a, b, c, d or e: ")

  ;; Reset options (might be set from previous runs):
  (setq *sneps-make-option* :load)

  (case (read *terminal-io*)
    (a (format t "~2%  Loading SNePS...~2%")
       (setq *sneps-make-option* :load))
    (b (format t "~2%  Changed source files will be compiled ~
                       before they are loaded....~2%")
       (setq *sneps-make-option* :compile))
    (c (format t "~2%  All source files will be compiled ~
                       before they are loaded....~2%")
       (setq *sneps-make-option* :recompile))
    (d (format t "~2%  All source files will be loaded uncompiled....~2%")
       (setq *sneps-make-option* :load-uncompiled))
    (e (format t "~2%  Compiling and loading SNePS and all ~
                       optional systems....~2%")
       (setq *sneps-make-option* :install))
    (t (format t "~2%  Loading SNePS....~2%")))
  )

;; Backward compatibility: Tell users about changed variable names:
(let ((bound-old-vars
       (remove-if-not
	#'boundp
	'(*sneps21-packages* *sneps21-noquery*
	  *sneps21-load-old-englex* *sneps21-patch-directory*
	  *sneps21-directory* *sneps21-system-definition*
	  *sneps21-logical-pathname-translations* *sneps21-version*
	  *sneps21-garnet-translations* *sneps21-verbose*
	  *sneps21-garnet-directory* *sneps21-user-translations*
	  *sneps21-patch-translations* *sneps21-make-option*))))
  (if bound-old-vars
      (warn "You bind the following `*sneps21-XXX*' variables:~
           ~%  ~a~
           ~%Please change their names to `*sneps-XXX*' in your setup files."
	    bound-old-vars)))

(unless *sneps-noquery*
  (sneps-startup-query))

(defun sneps-load (file)
  (let ((*load-verbose* *sneps-verbose*)
	#+allegro
	(*enable-package-locked-errors* nil)
	#+allegro
	(*redefinition-warnings* *sneps-verbose*)
	#+lucid
	(*redefinition-action* *sneps-verbose*)
	#+(or explorer symbolics)
        (si:inhibit-fdefine-warnings t))
    (load file)))


;; Logical Pathnames:

;; Boot the logical pathname system. This is the only place where we have
;; to use a physical pathname in a load statement. From here on logical
;; pathnames can be used in most Common-Lisp and SNePS commands that
;; take files as parameters (e.g., `open', `compile-file', `demo',
;; `atnin', etc.).
;; See the file `logical-pathnames.lisp' or refer to Guy Steele's
;; "Common Lisp: The Language" (2nd Edition), section 23.1.5 "Logical
;; Pathnames" for more information on logical pathnames.

(unless (find-package 'LOGICAL-PATHNAME)
  (make-package 'LOGICAL-PATHNAME :nicknames '("LP")))

(sneps-load
 (format nil
	 #+unix      "~a/~a~a"
	 #+lm-unix   "~a/~a~a"
	 #+(and explorer (not lm-unix))  "~a;~a~a"
	 #+(and symbolics (not lm-unix)) "~a>~a~a"
	 #+vms       "~a]~a~a"
	 *sneps-directory*
	 "logical-pathnames"
	 ;; Make sure we load the source code when necessary (in
	 ;; particular when we have a Allegro libfasl version of
	 ;; this file which gets overwritten during recompilation,
	 ;; or ALWAYS in CLISP because that generates a bad compiled
	 ;; version if the source was loaded before the compilation):
	 (if (or (member *sneps-make-option*
			 '(:recompile :load-uncompiled :install))
		 #+clisp t)
	     (concatenate 'string "." *sneps-lisp-extension*)
	   "")))

(defvar *sneps-logical-pathname-translations*
  `(;; User translations first
    ,@*sneps-user-translations*
    ("before-sneps-load-hook" "sneps:load-before.LISP")
    ("after-sneps-load-hook" "sneps:load-after.LISP")
    ("snactor" "sneps:demo;snactor;load-snactor.LISP")
    ("**;*.*.*" ,(format nil #+unix      "~a/**/"
			     #+lm-unix   "~a/**/"
		             #+(and explorer (not lm-unix))  "~a.**;"
		             #+(and symbolics (not lm-unix)) "~a>**>"
		             #+vms       "~a...]"
		             *sneps-directory*))
    ("*.*.*" ,(format nil #+unix      "~a/"
		          #+lm-unix   "~a/"
	                  #+(and explorer (not lm-unix))  "~a;"
	                  #+(and symbolics (not lm-unix)) "~a>"
	                  #+vms       "~a]"
	                  *sneps-directory*))
    ))

(defvar *sneps-patch-translations*
  `(("**;*.*.*" ,(format nil #+unix      "~a/**/"
			     #+lm-unix   "~a/**/"
		             #+(and explorer (not lm-unix))  "~a.**;"
		             #+(and symbolics (not lm-unix)) "~a>**>"
		             #+vms       "~a...]"
		             *sneps-patch-directory*))
    ("*.*.*" ,(format nil #+unix      "~a/"
		          #+lm-unix   "~a/"
	                  #+(and explorer (not lm-unix))  "~a;"
	                  #+(and symbolics (not lm-unix)) "~a>"
	                  #+vms       "~a]"
	                  *sneps-patch-directory*))
    ))

(defvar *sneps-garnet-translations*
  `(("**;*.*.*" ,(format nil #+unix      "~a/**/"
			     #+lm-unix   "~a/**/"
		             #+(and explorer (not lm-unix))  "~a.**;"
		             #+(and symbolics (not lm-unix)) "~a>**>"
		             #+vms       "~a...]"
		             *sneps-garnet-directory*))
    ("*.*.*" ,(format nil #+unix      "~a/"
		          #+lm-unix   "~a/"
	                  #+(and explorer (not lm-unix))  "~a;"
	                  #+(and symbolics (not lm-unix)) "~a>"
	                  #+vms       "~a]"
	                  *sneps-garnet-directory*))
    ))

(setf (lp:logical-pathname-translations "sneps")
      *sneps-logical-pathname-translations*)

(setf (lp:logical-pathname-translations "sneps-p")
      *sneps-patch-translations*)

(setf (lp:logical-pathname-translations "garnet")
      *sneps-garnet-translations*)

;; For backward compatibility:
(setf (lp:logical-pathname-translations "sneps21")
      *sneps-logical-pathname-translations*)

;; Define type of default host
(setf (lp:physical-host-type nil)
      #+unix :unix
      #+lm-unix :unix
      #+(and explorer (not lm-unix)) :explorer
      #+(and symbolics (not lm-unix)) :symbolics
      #+vms :vms)

;; Define type of host sys used in default garnet pathnames:
#+(or explorer symbolics vms)
  (setf (lp:physical-host-type "sys")
	#+explorer :explorer
	#+symbolics :symbolics
	#+vms :vms)

;; In case the various physical directories contain a host itself
;; we must define its type; assume it is the same as for the default
;; host -- this assumption might be wrong!!
(dolist (dir `(,*sneps-directory*
	       ,*sneps-garnet-directory*
	       ,*sneps-patch-directory*))
  (let ((host (lp::get-host-string dir)))
    (when (and host (null (lp:physical-host-type host)))
      (setf (lp:physical-host-type host)
	    (lp:physical-host-type nil)))))

;; make logical pathnames case sensitive
(lp:define-translation-rule :logical :case nil)

;; define translations for canonical lisp extension:
(lp:define-canonical type :lisp "LISP" 
		     (#+unix :unix
		      #+vms :vms
		      #+symbolics :symbolics
		      #+explorer :explorer
		      #.*sneps-lisp-extension*))
		  
;; define default translations for canonical fasl extension:
(lp:define-canonical type :fasl "FASL" 
		     (:unix #+lucid "sbin"
			    #+(or ibcl kcl) "o"
			    #+allegro "fasl"
			    #+cmu "sparcf"
			    #+explorer "XLD"
			    #+symbolics "BIN"
			    #+clisp "fas"
			    "fasl" "bin" "BN")
		     (:vms "FAS" "BIN")
		     (:explorer "XLD")
		     (:symbolics "BIN"))

;; now redefine it if user explicitly provided a binary extension:
(if *sneps-binary-extension*
    (lp:define-canonical type :fasl "FASL"
			 (#+unix :unix
			  #+vms :vms
			  #+symbolics :symbolics
			  #+explorer :explorer
			  #.*sneps-binary-extension*)))

;; define translations for canonical default lisp extension (the default
;; `lisp' extension used by the local Common-Lisp):
(lp:define-canonical type :dlisp "DLISP" 
		     (:unix-ucb "LISP")
		     (:unix #+(or ibcl kcl) "lsp"
			    #+clisp "lsp"
			    "lisp" "L")
		     (:vms "LSP" "LISP")
		     ((:tops-20 :tenex) "LISP" "LSP"))

;; now redefine it if user explicitly provided a default lisp extension:
(if *sneps-default-lisp-extension*
    (lp:define-canonical type :dlisp "DLISP"
			 (#+unix :unix
			  #+vms :vms
			  #+symbolics :symbolics
			  #+explorer :explorer
			  #.*sneps-default-lisp-extension*)))

;; End of Logical Pathnames


;; Load simple system utilities:
(sneps-load (format nil "sneps:system-utils.~a"
		    (if (member *sneps-make-option*
				'(:recompile :load-uncompiled :install))
			"LISP"
		      "FASL")))

;; Load before hook file if it exists:
(if (probe-file "sneps:before-sneps-load-hook")
    (sneps-load "sneps:before-sneps-load-hook"))

;; Compile/load SNePS:
(cond ((eq *sneps-make-option* :install)
       (setq *sneps-make-option* :recompile)
       (sneps-load "sneps:system.LISP")
       (dolist (system *sneps-optional-systems*)
	 (sneps-load system)))
      (t (sneps-load "sneps:system.LISP")))

(defun sneps ()
  (let ((*package* (find-package 'snepsul)))
    (sneps:sneps)))

(defun snepslog (&rest args)
  (apply #'sneps:snepslog args))

;; Load after hook file if it exists:
(if (probe-file "sneps:after-sneps-load-hook")
    (sneps-load "sneps:after-sneps-load-hook"))

(format t "~&SNePS-2.1 ~a loaded.~
           ~%Type `(sneps)' or `(snepslog)' to get started."
	*sneps-version*)
