;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: ginseng.lisp,v 1.2 1993/06/04 06:21:56 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(defun ginseng ()
  (cond (*window*
	 (send *window* :expose))
	(t
	 (setq *window*
	       (tv:make-window
		 'graph-window			;This is the flavor specification   
		 :edges-from :mouse
		 :blinker-p nil
		 :save-bits t
		 :label '( :bottom
			  :character-style (:sans-serif :roman :very-large))
		 :item-type-alist *alist-alpha*))
	 (send *window* :set-label "SNePS-2 Ginseng Window")
	 (setq *window-width* (send *window* :width)
	       *window-height* (send *window* :height)
	       *viewport-position* (list 2000	; left X
					 2000	; top Y
					 (+ 2000 *window-width*)	; right X
					 (+ 2000 *window-height*) )	; bottom Y
	       *window-centerx* (- (third *viewport-position*) (// *window-width* 2))
	       *window-centery* (+ (second *viewport-position*) (// *window-height* 2))
	       *display-bounds* (list *window-centerx* *window-centery*
				      *window-centerx* *window-centery*)
	       )
	 (scl:process-run-function "GINSENG-Mouse-Driver" #'mouse-driver)))
  (send *window* :select))


(defun mouse-driver (&optional (window *window*))
  "This is the main drive loop for Ginseng."
  (tv:window-call-relative (window :deactivate)
    (let (blip)
      (loop (setq blip (send window ':any-tyi))	;Set blip to the value of ANY input.
	    ;; Invoke the operation returned by the blip
	    ;;  unless the operation is EXIT.
	    (when (listp blip)
	      (case (second blip)
		(move (if (eq 'node (type-of (third blip)))
			  (gi-move (third blip))
			  (gi-arc-bend (third blip))))
		(desc (when (eq 'node (type-of (third blip)))
			(gi-desc (sneps::makeone.ns
				   (send (third blip) :the-node)))))
		(dump (when (eq 'node (type-of (third blip)))
			(gi-dump (sneps::makeone.ns
				   (send (third blip) :the-node)))))
		(erase (when (eq 'node (type-of (third blip)))
			 (gi-erase (sneps::makeone.ns
				     (send (third blip) :the-node)))))
		(delete (when (eq 'node (type-of (third blip)))
			  (gi-delete (sneps::makeone.ns
				       (send (third blip) :the-node)))))
		(conv (when (eq 'arc (type-of (third blip)))
			(send (third blip) :make-converse)))
		(pan  (if *pan-flag*
			  (disable-panning)
			  (enable-panning)))
		(attrib  (gi-attributes))
		(refresh	      (send *window* :clear-screen)
				      (send window :display))
		(reset (when
			 (tv:mouse-y-or-n-p
			   (format
			     nil
			     "Delete current drawing and reset Ginseng to its initial state."))
			 (reset-all)))
		(exit (when (tv:mouse-y-or-n-p
			      (format
				nil
				"Delete current drawing and EXIT Ginseng."))
			(reset-all)(return t))))))))
  ;; Reset global variables for next invokation of Ginseng.
  (setq *window* nil
	*pan-flag* nil))
	  


(defun reset-all ()
  "Resets Ginseng to it's original state."
  (setq *viewport-position* (list 2000	; left X
				  2000	; top Y
				  (+ 2000 *window-width*)	; right X
				  (+ 2000 *window-height*))	; bottom Y
	*window-centerx* (- (third *viewport-position*) (// *window-width* 2))
	*window-centery* (+ (second *viewport-position*) (// *window-height* 2))
	*display-bounds* (list *window-centerx* *window-centery*
			       *window-centerx* *window-centery*)
	*displayed-nodes* nil
	*mouse-sensitive* nil
	current-zoom-factor 1
	sn-flag nil
	*drawn-arcs1* nil
	*drawn-arcs* nil
	*node-list* nil)
  (when (boundp '*window*)
    (send *window* :expose)
    (send *window* :clear-screen)))

;;;******************************************************************************




















