;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: ds.lisp,v 1.4 1993/07/20 06:26:25 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


(export '(ginseng))

(defun ginseng ()
  (cond ((null window) 
         (setq window-name (string-append "GINSENG WINDOW " (format nil "~S" windowcount)))
         (setq windowcount (+ windowcount 1))
	 (setq window (make-instance 'graph-window
				     :edges (create-ginseng-window)
				     :save-bits t
				     :name window-name
				     :expose-p t))
         (send window :select)
         (setq centerx (/ (send window :width) 2))
	 (setq centery (/ (send window :height) 2))
         (setq *xresolution* (send window :width))
         (setq current-zoom-factor 1)
         (setq sn-flag nil)
         (setq *drawn-arcs1* nil)
         (setq *drawn-arcs* nil)
         (setq *node-list* nil)
	 (setq world (send window :world)))
	(t (send window :expose) (send window :select))))

(defun get-window-edges ()
  (multiple-value-bind (x1 y1 x2 y2)
      (send window :edges)
    (values 
      x1
      y1
      (+ x1 x2)
      (+ y1 y2))))

(defun create-ginseng-window ()
  (multiple-value-bind (x1 y1 x2 y2) (tv:mouse-specify-rectangle)
    (list x1 y1 x2 y2)))


(defun add-to-oblist (item flavor)
  (putprop 'oblist flavor item))

(defun get-from-oblist (flavor)
  (get 'oblist flavor))


(defun // (a b)
  (floor (/ a b)))


(defun expose-if-not ()
  (cond ((null (send window :exposed-p)) (send window :expose))
	(t nil)))


(defun typeof-object (instance)
  (send instance :typeof-object))

(defun graph-window-top-level-function (dummy)
  (declare (ignore dummy))
  (setq click (send window :any-tyi)))



(defmethod (graph-window :mouse-click) (buttons mx my)
  (declare (special buttons))
  (let ((x (floor (+ (/ (- mx centerx) current-zoom-factor) centerx)))
	(y (floor (+ (/ (- my centery) current-zoom-factor) centery))))
    (setq sn-clicked-x mx)
    (setq sn-clicked-y my)
    (setq clicked-object (get-from-oblist (send world :pick x y)))
    (cond ((eq move-flag t) (setq move-flag nil))
	  (t (cond
	       ((null (send world :pick x y))
		(process-run-function "pan" #'eval-pan-menu))
	       ((eq (typeof-object clicked-object) 'node)
		(process-run-function "nodes" #'eval-nodes))
	       (t (ticl:beep) (process-run-function "arcs" #'eval-arcs)))))))

(defun eval-nodes ()
  (declare (special node-menu))
  (tv:menu-choose node-menu "Ginseng NODE Menu" '(:mouse) nil window))

(setq node-menu '(("Dump "
		   :funcall dump-shownode
		   :documentation "Dump this sneps node.")
		  ("Describe"
		   :funcall desc-shownode
		   :documentation "Describe this sneps node.")
                  ("Describe-1"
                   :funcall desc1-shownode
                   :documentation "Describe one level down.")
		  ("Move"
		   :funcall gi-move
		   :documentation "Drag this sneps node.")
		  ("Delete Node"
		   :funcall gi-delete
		   :documentation "Remove the node from window.")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;funcall
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun dump-shownode ()
  (gi-dump (sneps:nseval (send clicked-object :the-node))))

(defun desc-shownode ()
  (gi-desc (sneps:nseval (send clicked-object :the-node))))

(defun desc1-shownode ()
  (gi-desc1 (sneps:nseval (send clicked-object :the-node))))

(defun gi-move ()
  (setq move-flag t)
  (send window :set-mouse-position sn-clicked-x sn-clicked-y)
  (gi-move-1 clicked-object))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun mystring (sym)
  (format nil "~A" sym))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun zoom-in ()
  (send window :zoom zoomin zoomin)
  (Setq current-zoom-factor (* current-zoom-factor zoomin))
  (send window :refresh))

(defun zoom-out ()
  (send window :zoom zoomout zoomout)
  (setq current-zoom-factor (* current-zoom-factor zoomout))
  (send window :refresh))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq arc-menu '(("NO OPERATION ON ARC"
		  :funcall nothing
		  :documentation "OPERATIONS ON ARC UNAVAILABLE NOW")))

(defun eval-arcs ()
  (declare (special arc-menu))
  (tv:menu-choose arc-menu "Ginseng ARC menu" '(:mouse) nil window))

(defun nothing ())























