/*
 * Copyright 1987, 1988, 1989, by Geoff Kuenning, Manhattan Beach, CA
 * Permission for non-profit use is hereby granted.
 * All other rights reserved.
 * See "version.h" for a more complete copyright notice.
 */

/*
 * This is the configuration file for ispell.  Thanks to Bob McQueer
 * for creating it and making the necessary changes elsewhere to
 * support it, and to George Sipe for figuring out how to make it easier
 * to use.
 *
 * WARNING:  The Makefile edits this file (config.X) to produce config.h.
 * If you are looking at config.h, you're in the wrong file.
 *
 * Look through this file from top to bottom.  If anything needs changing,
 * create the header file "local.h" and define the correct values there;
 * they will override this file.  If you don't make any changes to this
 * file, future patching will be easier.
 *
 * There are also five or six variables in the Makefile that you must edit
 * to complete the configuration.
 *
 * Don't change the funny-looking lines with !!'s in them;  see the
 * Makefile!
 */

/*
 * $Id: config.X,v 1.42 91/09/12 00:01:28 geoff Exp $
 *
 * $Log:	config.X,v $
 * Revision 1.42  91/09/12  00:01:28  geoff
 * Increase the language-size defaults to values suitable for German (and
 * thus for most other languages), since they don't really cost that much
 * in hash-file space.  Add the new defaults to TEXSPECIAL.
 * 
 * Revision 1.41  91/09/11  23:22:29  geoff
 * Add the SUN4_IS_STUPID symbol.
 * 
 * Revision 1.40  91/07/15  19:26:40  geoff
 * Get the BSD egrep from /usr/bin, since that's where the BSD folks
 * actually put it.
 * 
 * Revision 1.39  91/07/05  19:53:18  geoff
 * Add some #undef's as prototypes for system selection in local.h.
 * Change all commented-out #define's to be #ifndef'ed-out #undef's, just
 * for consistency.
 * 
 * Revision 1.38  91/07/03  18:20:17  geoff
 * Include param.h, types.h, and (if needed) dir.h, so that we will be
 * sure to have the definition of MAXNAMLEN.  Make the default
 * SIGNAL_TYPE be void, since that's the most common definition on modern
 * machines.
 * 
 * Revision 1.37  91/05/27  21:34:41  geoff
 * Add commentary pointing out that NO8BIT is a good thing because it makes
 * ispell more space- and time-efficient.
 * 
 * Revision 1.36  89/12/27  22:24:13  geoff
 * Add MINWORD.
 * 
 * Revision 1.35  89/12/26  23:26:52  geoff
 * Make the return type of signal() configurable (Israel Pinkas).
 * 
 * Revision 1.34  89/07/11  00:19:29  geoff
 * Add Amiga support, and regex support based on that from luis@rice.edu.
 * 
 * Revision 1.33  89/06/09  15:52:05  geoff
 * Fix some lint complaints.  Move the isXXXX stuff to ispell.h, since
 * they shouldn't be modified during porting.
 * 
 * Revision 1.32  89/04/28  01:07:06  geoff
 * Change Header to Id;  nobody cares about my pathnames.
 * 
 * Revision 1.31  89/04/03  01:54:38  geoff
 * Add support for boundary characters and the stringchar stuff.  Also fix some
 * lint complaints, and add some comments warning that NO8BIT might not work so
 * well.
 * 
 * Revision 1.30  89/02/27  02:20:56  geoff
 * Add MINIMENU.
 * 
 * Revision 1.29  89/02/22  23:12:35  geoff
 * Add the three variables that control the size of the context display.
 * 
 * Revision 1.28  89/02/06  02:22:05  geoff
 * Fix the definition of the default TEX special characters, where the
 * curly braces appeared twice and the parens were omitted.
 * 
 * Revision 1.27  89/01/06  00:13:46  geoff
 * Add MAX_SCREEN_SIZE for windowed workstations (Keith Cantrell).
 * 
 * Revision 1.26  88/12/26  02:23:17  geoff
 * Add a copyright notice.
 * 
 * Revision 1.25  88/10/20  20:51:03  geoff
 * Split the default personal dictionary into two pieces, DEFPDICT and
 * DEFPAFF, so that it can change based on the language.  (Ole Bjoern
 * Hessen).
 * 
 * 
 * Revision 1.24  88/06/25  17:46:25  geoff
 * Add Ole Bjoern Hessen's latest suggestions:  TEXSPECIAL and NRSPECIAL,
 * plus my own DEFNOBACKUPFLAG and DEFTEXFLAG.
 * 
 * Revision 1.23  88/05/25  11:49:41  geoff
 * Correctly define rindex as strrchr (Thos Sumner)
 * 
 * Revision 1.22  88/04/04  01:30:45  geoff
 * Integrate Ken Stevens' IGNOREBIB option
 * 
 * Revision 1.21  88/02/20  23:09:59  geoff
 * Change CAPITALIZE to CAPITALIZATION to better distinguish it from the
 * CAPITALIZED flag.  Add MASKBITS and MAX_HITS.
 * 
 * Revision 1.20  87/09/26  15:52:53  geoff
 * Change WORDLEN to INPUTWORDLEN, and add MAXAFFIXLEN.
 * 
 * Revision 1.19  87/09/09  00:15:48  geoff
 * Change SORTPERSONAL comments to reflect that you now disable it by
 * setting it to zero.  Add MALLOC_INCREMENT.
 * 
 * Revision 1.18  87/09/03  23:00:05  geoff
 * Add George Sipes configurability changes.  Also fix a bug in myupper/lower
 * in 8-bit mode, and be more paranoid about sign bits in that mode.
 * 
 * Revision 1.17  87/07/20  23:20:50  geoff
 * Add support for the language tables (mostly DEFLANG).
 * 
 * Revision 1.16  87/05/25  21:09:59  geoff
 * Add INCSTRVAR, DEFINCSTR, and MAXINCLUDEFILES
 * 
 * Revision 1.15  87/04/19  22:51:02  geoff
 * Remove a duplicate definition of MAGIC.  Add CAPITALIZE and SORTPERSONAL.
 * 
 * Revision 1.14  87/04/07  19:04:01  geoff
 * Add #ifndef's around every define, and add BAKEXT (George Sipe)
 * 
 * Revision 1.13  87/04/06  23:41:38  geoff
 * Add EQUAL_COLUMNS
 * 
 * Revision 1.12  87/04/01  15:22:01  geoff
 * Integrate Joe Orost's V7/register changes into the main branch
 * 
 * Revision 1.11  87/03/31  16:40:08  geoff
 * Add a USG definition for rindex as well as index.
 * 
 * Revision 1.10  87/03/28  19:22:52  geoff
 * Make the personal dictionary into a dot file
 * 
 * Revision 1.9  87/03/26  00:42:11  geoff
 * Add explanatory comments at top, as per Israel Pinkas's request
 * 
 * Revision 1.8  87/03/26  00:30:34  geoff
 * Integrate Rich Salz's changes/improvements
 * 
 * Revision 1.7  87/03/22  23:56:05  geoff
 * Fix minor bugs found by Dave Mason
 * 
 * Revision 1.6  87/03/10  23:32:54  geoff
 * Bump the big personal dictionary size to 29000, since that's the size
 * of the full munched dictionary.
 * 
 * Revision 1.5  87/03/08  20:29:56  geoff
 * Add BIG_DICT and MAXPCT.
 * 
 * Revision 1.4  87/02/28  01:05:22  geoff
 * Configure for my system, also get rid of some patching mistakes.
 * 
 * Revision 1.3  87/02/26  00:49:19  geoff
 * Integrate McQueer's, Randle's, and Ries's fixes into the main branch
 * 
 * Revision 1.2  87/02/26  00:46:30  geoff
 * Add RCS ID keywords
 * 
 */

/* You may wish to specify your local definitions in this file: */

#include "local.h"	/* local definitions for options */

/*
** Major-differences selection.  The default system is BSD;  for USG
** systems or Amigas you should add the appropriate #define to local.h.
*/
#ifndef USG
#undef USG		/* Define this in local.h for System V machines */
#endif /* USG */
#ifndef AMIGA
#undef AMIGA		/* Define this for the Amiga */
#endif /* AMIGA */

#ifndef AMIGA
#include <sys/param.h>
#include <sys/types.h>
#ifndef USG
#include <sys/dir.h>
#endif /* USG */
#endif /* AMIGA */

/*
** library directory for hash table(s) / default hash table name
** If you intend to use multiple dictionary files, I would suggest
** LIBDIR be a directory which will contain nothing else, so sensible
** names can be constructed for the -d option without conflict.
**
** NOTE:  Don't change these here;  change them in the Makefile.
*/
#ifndef LIBDIR
#define LIBDIR "!!LIBDIR!!"
#endif
#ifndef DEFHASH
#define DEFHASH "!!DEFHASH!!"
#endif

/* Aliases for some routines */
#ifdef USG
extern char *memcpy ();
extern char *memset ();

#define bcopy(s, d, n)	(void) memcpy (d, s, n)
#define bzero(d, n)	(void) memset (d, 0, n)
#define index strchr
#define rindex strrchr
#endif

/* type given to signal() by signal.h */
#ifndef SIGNAL_TYPE
#define SIGNAL_TYPE void
#endif

/* environment variable for user's word list */
#ifndef PDICTVAR
#define PDICTVAR "WORDLIST"
#endif

/* prefix part of default word list */
#ifndef DEFPDICT
#define DEFPDICT ".ispell_"
#endif

/*
** suffix part of default word list - you may want to make this
** a language name, such as "english", "norsk", or "deutsch".
*/
#ifndef DEFPAFF
#define DEFPAFF "words"
#endif

/* environment variable for include file string */
#ifndef INCSTRVAR
#define INCSTRVAR "INCLUDE_STRING"
#endif

/* default include string */
#ifndef DEFINCSTR
#define DEFINCSTR "&Include_File&"
#endif

/* mktemp template for temporary file - MUST contain 6 consecutive X's */
#ifndef TEMPNAME
#define TEMPNAME "/tmp/ispellXXXXXX"
#endif

/* default language tables */
#ifndef DEFLANG
#define DEFLANG	"!!DEFLANG!!"
#endif

/* default dictionary file */
#ifndef DEFDICT
#define DEFDICT "!!DEFDICT!!"
#endif

/*
** If REGEX_LOOKUP is undefined, the lookup command (L) will use the look(1)
** command (if available) or the egrep command.  If REGEX_LOOKUP is defined,
** the lookup command will use the internal dictionary and the
** regular-expression library (which you must supply separately.  There is
** a public-domain library available;  libraries are also distributed with
** both BSD and System V.
**
** The advantage of no REGEX_LOOKUP is that it is often much faster, especially
** if the look(1) command is available, that the words found are presented
** in alphabetical order, and that the list of words searched is larger.
** The advantage of REGEX_LOOKUP is that ispell doesn't need to spawn another
** program, and the list of words searched is exactly the list of (root) words
** that ispell will accept.  (However, note that words formed with affixes will
** not be found;  this can produce some artifacts.  For example, since
** "brother" can be formed as "broth+er", a lookup command might fail to
** find "brother.")
*/
#ifndef REGEX_LOOKUP
#undef REGEX_LOOKUP
#endif /* REGEX_LOOKUP */

/*
** Choose the proper type of regular-expression routines here.  BSD
** and public-domain systems have routines called re_comp and re_exec;
** System V uses regcmp and regex.
*/
#ifdef REGEX_LOOKUP
#ifndef REGCMP
#ifdef USG
extern char *regcmp ();
extern char *regex ();
#define REGCMP(str)		regcmp (str, (char *) 0)
#define REGEX(re, str, dummy)	regex (re, str, dummy, dummy, dummy, dummy, \
				    dummy, dummy, dummy, dummy, dummy, dummy)
#else /* USG */
extern char *re_comp ();
extern char *re_exec ();
#define REGCMP(str)		re_comp (str)
#define REGEX(re, str, dummy)	re_exec (str)
#endif /* USG */
#endif /* REGCMP */
#endif /* REGEX_LOOKUP */

/* look command (if look(1) MAY BE available - ignored if not) */
#ifndef REGEX_LOOKUP
#ifndef LOOK
#define	LOOK	"look -df"
#endif
#endif /* REGEX_LOOKUP */

/* path to egrep (use speeded up version if available) */
#ifndef EGREPCMD
#ifdef AMIGA
#define EGREPCMD "/usr/bin/egrep"
#else /* AMIGA */
#ifdef	USG
#define EGREPCMD "/bin/egrep"
#else
#define EGREPCMD "/usr/bin/egrep -i"
#endif
#endif /* AMIGA */
#endif

/* path to wordlist for Lookup command (typically /usr/dict/{words|web2}) */
#ifndef WORDS
#define WORDS	"/usr/dict/words"
#endif

/* buffer size to use for file names if not in sys/param.h */
#ifndef MAXPATHLEN
#define MAXPATHLEN 240
#endif

/* max file name length (will truncate to fit BAKEXT) if not in sys/param.h */
#ifndef MAXNAMLEN
#define MAXNAMLEN 14
#endif

/* define if you want .bak file names truncated to MAXNAMLEN characters */
#ifndef TRUNCATEBAK
#undef TRUNCATEBAK
#endif /* TRUNCATEBAK */

/* largest word accepted from a file by any input routine, plus one */
#ifndef	INPUTWORDLEN
#define INPUTWORDLEN 100
#endif

/* largest amount that a word might be extended by adding affixes */
#ifndef MAXAFFIXLEN
#define MAXAFFIXLEN 20
#endif

/*
** Define the following to suppress the 8-bit character feature.
** Unfortunately, this doesn't work as well as it might, because ispell
** only strips the 8th bit in some places.  For example, it calls strcmp()
** quite often without first stripping parity.  However, I really wonder
** about the utility of this option, so I haven't bothered to fix it.  If
** you think the stripping feature of NO8BIT is useful, you might let me
** (Geoff Kuenning) know.
**
** Nevertheless, NO8BIT is a useful option for other reasons.  If NO8BIT
** is defined, ispell will probably use 8-bit characters internally;
** this improves time efficiency and saves a small amount of space
** in the hash file.  Thus, I recommend you specify NO8BIT unless you
** actually expect to be spelling files which use a 256-character set.
*/ 
#ifndef NO8BIT
#undef NO8BIT
#endif /* NO8BIT */

/*
** number of mask bits (affix flags) supported.  Must be 32, 64, 128, or
** 256.  If MASKBITS is 32 or 64, there are really only 26 or 58 flags
** available, respectively.  If it is 32, the flags are named with the
** 26 English uppercase letters;  lowercase will be converted to uppercase.
** If MASKBITS is 64, the 58 flags are named 'A' through 'z' in ASCII
** order, including the 6 special characters from 'Z' to 'a': "[\]^_`".
** If MASKBITS is 128 or 256, all the 7-bit or 8-bit characters,
** respectively, are theoretically available, though a few (newline, slash,
** null byte) are pretty hard to actually use successfully.
*/
#ifndef MASKBITS
#define MASKBITS	32
#endif

/* maximum number of include files supported by xgets;  set to 0 to disable */
#ifndef MAXINCLUDEFILES
#define MAXINCLUDEFILES	5
#endif

/*
** Maximum hash table fullness percentage.  Larger numbers trade space
** for time.
**/
#ifndef MAXPCT
#define MAXPCT	70		/* Expand table when 70% full */
#endif

/*
** Maximum number of "string" characters that can be defined in a
** language (affix) file.  Don't forget that an upper/lower string
** character counts as two!
*/
#ifndef MAXSTRINGCHARS
#define MAXSTRINGCHARS 100
#endif /* MAXSTRINGCHARS */

/*
** Maximum length of a "string" character.  The default is appropriate for
** nroff-style characters starting with a backslash.
*/
#ifndef MAXSTRINGCHARLEN
#define MAXSTRINGCHARLEN 10
#endif /* MAXSTRINGCHARLEN */

/*
** the NOPARITY mask is applied to user input characters from the terminal
** in order to mask out the parity bit.
*/
#ifdef NO8BIT
#define NOPARITY 0x7f
#else
#define NOPARITY 0xff
#endif


/*
** the terminal mode for ispell, set to CBREAK or RAW
**
*/
#ifndef TERM_MODE
#define TERM_MODE	CBREAK
#endif

/*
** Define this if you want your columns of words to be of equal length.
** This will spread short word lists across the screen instead of down it.
*/
#ifndef EQUAL_COLUMNS
#undef EQUAL_COLUMNS
#endif /* EQUAL_COLUMNS */

/*
** This is the extension that will be added to backup files
*/
#ifndef	BAKEXT
#define	BAKEXT	".bak"
#endif

/*
** Define this if you want the capitalization feature.  This will increase
** the size of the hashed dictionary on most 16-bit and some 32-bit machines.
*/
#ifndef CAPITALIZATION
#undef CAPITALIZATION
#endif /* CAPITALIZATION */

/*
** Define this if you want your personal dictionary sorted.  This may take
** a long time for very large dictionaries.  Dictionaries larger than
** SORTPERSONAL words will not be sorted.  Define SORTPERSONAL as zero
** to disable this feature.
*/
#ifndef SORTPERSONAL
#define SORTPERSONAL	1000
#endif

/*
** Define this if you want to use the shell for interpretation of commands
** issued via the "L" command, "^Z" under System V, and "!".  If this is
** not defined then a direct fork()/exec() will be used in place of the
** normal system().  This may speed up these operations greately on some
** systems.
*/
#ifndef USESH
#undef USESH
#endif /* USESH */

/*
** Maximum language-table search size.  Smaller numbers make ispell
** run faster, at the expense of more memory (the lowest reasonable value
** is 2).  If a given character appears in a significant position in
** more than MAXSEARCH suffixes, it will be given its own index table.
** If you change this, define INDEXDUMP in lookup.c to be sure your
** index table looks reasonable.
*/
#ifndef MAXSEARCH
#define MAXSEARCH 4
#endif

/*
** Define this if you want to be able to type any command at a "type space
** to continue" prompt.
*/
#ifndef COMMANDFORSPACE
#undef COMMANDFORSPACE
#endif /* COMMANDFORSPACE */

/*
** Memory-allocation increment.  Buildhash allocates memory in chunks
** of this size, and then subdivides it to get its storage.  This saves
** much malloc execution time.  A good number for this is the system
** page size less the malloc storage overhead.
**
** Define this to zero to revert to using malloc/realloc.  This is normally
** useful only on systems with limited memory.
*/
#ifndef MALLOC_INCREMENT
#define MALLOC_INCREMENT	(4096 - 8)
#endif

/*
** Maximum number of "hits" expected on a word.  This is basically the
** number of different ways different affixes can produce the same word.
** For example, with "english.aff", "brothers" can be produced 3 ways:
** "brothers," "brother+s", or "broth+ers".  If this is too low, no major
** harm will be done, but ispell may occasionally forget a capitalization.
*/
#ifndef MAX_HITS
#define MAX_HITS	10
#endif

/* Define this to ignore spelling check of entire LaTeX bibliography listings */
#ifndef IGNOREBIB
#undef IGNOREBIB
#endif

/*
** Default nroff and TeX special characters.  Normally, you won't want to
** change this;  instead you would override it in the language-definition
** file.
*/
#ifndef TEXSPECIAL
#define TEXSPECIAL	"()[]{}<>\\$*.%"
#endif

#ifndef NRSPECIAL
#define NRSPECIAL	"().\\*"
#endif

/*
** Defaults for certain command-line flags.
*/
#ifndef DEFNOBACKUPFLAG
#define DEFNOBACKUPFLAG	0		    /* Don't suppress backup file */
#endif
#ifndef DEFTEXFLAG
#define DEFTEXFLAG	0		    /* Default to nroff mode */
#endif

/*
** Define this if you want ispell to place a limitation on the maximum
** size of the screen.  On windowed workstations with very large windows,
** the size of the window can be too much of a good thing, forcing the
** user to look back and forth between the bottom and top of the screen.
** If MAX_SCREEN_SIZE is nonzero, screens larger than this will be treated
** as if they have only MAX_SCREEN_SIZE lines.  A good value for this
** variable is 24 or 30.  Define it as zero to suppress the feature.
*/
#ifndef MAX_SCREEN_SIZE
#define MAX_SCREEN_SIZE 0
#endif

/*
** The next three variables are used to provide a variable-size context
** display at the bottom of the screen.  Normally, the user will see
** a number of lines equal to CONTEXTPCT of his screen, rounded down
** (thus, with CONTEXTPCT == 10, a 24-line screen will produce two lines
** of context).  The context will never be greater than MAXCONTEXT or
** less than MINCONTEXT.  To disable this feature entirely, set MAXCONTEXT
** and MINCONTEXT to the same value.  To round context percentages up,
** define CONTEXTROUNDUP.
*/
#ifndef CONTEXTPCT
#define CONTEXTPCT	10	/* Use 10% of the screen for context */
#endif
#ifndef MINCONTEXT
#define MINCONTEXT	2	/* Always show at least 2 lines of context */
#endif
#ifndef MAXCONTEXT
#define MAXCONTEXT	10	/* Never show more than 10 lines of context */
#endif
#ifndef CONTEXTROUNDUP
#undef CONTEXTROUNDUP		/* Don't round context up */
#endif

/*
** Define this if you want the "mini-menu," which gives the most important
** options at the bottom of the screen, to be the default (in any case, it
** can be controlled with the "-M" switch).
*/
#ifndef MINIMENU
#undef MINIMENU
#endif

/*
** You might want to change this to zero if your users want to check
** single-letter words against the dictionary.  However, you should try
** some sample runs using the -W switch before you try it out;  you'd
** be surprised how many single letters appear in documents.  If you increase
** MINWORD beyond 1, don't say I didn't warn you that it was a bad idea.
*/
#ifndef MINWORD
#define MINWORD		1	/* Words this short and shorter are always ok */
#endif

/*
** Symbols below this point are needed to provide workarounds for the
** incredibly buggy implementations of Unix and the C language found
** on some machines.  I have a philosophical objection to catering to
** these braindamaged implementations, but the reality is that in some
** cases there are so many out there that it's not fair to make all
** the poor users suffer due to the incompetence of their vendors.
**
** Define SUN4_IS_STUPID if you are running Sun OS 4.1.1 (or possibly
** other versions;  that's the only version I'm sure of) on a Sun 4.
** You will also have to make sure that NO8BIT is *not* defined.
*/
#ifndef SUN4_IS_STUPID
#define SUN4_IS_STUPID
#endif /* SUN4_IS_STUPID */
