This is a copy of one chapter from the Info file gnus-1.  For full
information on installing GNUS, refer to the GNUS manual.


Installing GNUS
***************

  Installation of GNUS and some initialization of your computing
environment are described in this chapter.  Please read the following
sections carefully before getting started with GNUS.

* Menu:

* Files of GNUS::       How many files of GNUS are there?
* Compilation::         How to byte-compile lisp sources.
* Autoloading::         How to define autoload entries.
* Environment::         How to define your environment.
* Texinfo Manual::      How to install an Info file and print the manual.


Files of GNUS
=============

  Unpacking the shar files will produce the following files.  They are
the Emacs lisp sources, a C source, a Texinfo manual of GNUS, and a
Makefile.

`gnus.el'
     Main part of GNUS newsreader.

`gnuspost.el'
     Post news commands.

`gnusmail.el'
     Mail reply commands.

`gnusmisc.el'
     Miscellaneous commands.

`nntp.el'
     NNTP package.

`nnspool.el'
     A package accessing local news spool like NNTP.

`mhspool.el'
     A package accessing private directory like NNTP.

`tcp.el'
     Patches to some versions of GNU Emacs which do not have the
     function `open-network-stream'.

`tcp.c'
     C program for external TCP/IP implementation.  This is used with
     `tcp.el'.

`gnus.texinfo'
     Texinfo manual of GNUS.

`Makefile'
     Makefile to byte-compile the lisp files using the `make' command.


Byte-Compilation
================

  Move the lisp files, the C file, and `Makefile' to the appropriate
directory in the search path defined by the variable `load-path'.
Before actually byte-compiling the lisp files, make sure there are no
byte-compiled files of older versions of GNUS in that directory.  Remove
or rename such files as the byte-compiler may be confused by old macro
definitions.  If you can use the `make' command, you don't have to take
care of the dependencies.

  The C file `tcp.c' should be compiled with a C compiler and installed
in a directory in the search path defined by the variable `exec-path',
if this is required.

  If you can use the `make' command, just type `make' in a Unix shell.
All the lisp files will be byte-compiled.  Otherwise, byte-compile lisp
files in the following order according to your computing environment by
yourself:

  1. Byte-compile `nntp.el', `gnus.el', `gnuspost.el', `gnusmail.el',
     and `gnusmisc.el' in this order.

  2. Byte-compile `nnspool.el' if you want to use the local news spool
     of your machine instead of NNTP (*Note Local News Spool::).

  3. Byte-compile `mhspool.el' if you want to read articles or mail in
     your private directory using GNUS (*Note Private Directory::).

  4. Compile and install `tcp.el' and `tcp.c' if TCP/IP is not supported
     by Emacs but is supported by your operating system.

  `tcp.el' defines the function `open-network-stream', and `tcp.c' is an
emulation program for the stream used by the function.  If you modified
`tcp.c' for your system, please send the author the diffs.  Some of them
will be included in the future releases of GNUS.


Autoloading
===========

  It is useful to define autoload entries in `.emacs', `site-init.el' or
`default.el' as follows:

     (autoload 'gnus "gnus" "Read network news." t)
     (autoload 'gnus-post-news "gnuspost" "Post a new news." t)


Environment
===========

  The NNTP server and its service name, your domain and organization,
and other important definitions of your computing environment are
described in this section.  Since these definitions depend heavily on
your environment, you'd better be familiar with the operating system you
are using. Knowledge of the USENET software is also important.

* Menu:

* Server:  NNTP Server.         How to define NNTP server.
* Service: NNTP Service.        How to define NNTP service.
* Domain::                      How to define your domain and organization.
* GENERICFROM::                 How to use GENERICFROM feature.
* GENERICPATH::                 How to use GENERICPATH feature.
* Startup File::                About the startup files of GNUS.


NNTP Server
-----------

  The variable `gnus-nntp-server' specifies the default NNTP server.  To
define the server `flab', put the following code in `.emacs',
`site-init.el' or `default.el':

     (setq gnus-nntp-server "flab")

  The variable `gnus-nntp-server' is initialized from the `NNTPSERVER'
environment variable.  To define the server using the `NNTPSERVER'
environment variable, put the following code in `.login':

     setenv NNTPSERVER "flab"

  If an NNTP server is preceded by a colon such as `:Mail', the user's
private directory `~/Mail' is used as the news spool.  This makes it
possible to read mail stored in MH folders or articles saved by GNUS.
*Note Private Directory::, for more information.

  GNUS will ask you for the NNTP server at start up time unless it is
defined.  Even if the default server is defined, it is possible to
choose another server by invoking GNUS with a prefix argument like `C-u
M-x gnus' (*Note Getting Started::).


NNTP Service
------------

  The default service name of NNTP is `"nntp"'.  You may, however, have
to define the service name as the number `119' as follows:

     (setq gnus-nntp-service 119)

  If you'd like to use a local news spool of your machine directly
instead of NNTP, set the variable to `nil' as follows:

     (setq gnus-nntp-service nil)

In this case, the NNTP server must be a local host name returned by the
function `system-name' (*Note Local News Spool::).


Domain and Organization
-----------------------

  "Domain" and "organization" must be defined before you post your first
article, because they are included in all articles you post and will be
used for identifying who you are.

  "Domain" is the domain part of your mail address excluding the local
host name.  For example, if your mail address is
`umerin@photon.stars.flab.Fujitsu.CO.JP' and the local host name is
`photon', your domain is `stars.flab.Fujitsu.CO.JP'.  If the function
`system-name' of your Emacs returns the full Internet name, you do not
have to define the domain.

  "Organization" is the organization you belong to.  It must be defined
unless it is defined in the file `/usr/lib/news/organization'.

  To define the domain `stars.flab.Fujitsu.CO.JP' and the organization
`Fujitsu Laboratories Ltd., Kawasaki, Japan.' using lisp variables, put
the following code in `.emacs', `site-init.el' or `default.el'.  If you
are a system administrator and are installing GNUS for other users,
`site-init.el' is the best place to define this because the domain and
organization are common to all users of the system.

     (setq gnus-your-domain "stars.flab.Fujitsu.CO.JP")
     (setq gnus-your-organization
           "Fujitsu Laboratories Ltd., Kawasaki, Japan.")

  The `DOMAINNAME' and `ORGANIZATION' environment variables are used
instead, if defined.  To define these variables, put the following code
in `.login'.

     setenv DOMAINNAME   "stars.flab.Fujitsu.CO.JP"
     setenv ORGANIZATION "Fujitsu Laboratories Ltd., Kawasaki, Japan."

  If the value of the `ORGANIZATION' environment variable or the
variable `gnus-your-organization' begins with a slash, it is taken as
the name of a file whose contents are read for the value.  If neither of
these is defined, and a file `~/.organization-DISTRIBUTION' or
`~/.organization' exists, the contents of that file are used.  If
neither of them does not exist, and the file
`/usr/lib/news/organization' exists, its contents are used.


GENERICFROM
-----------

  If the variable `gnus-use-generic-from' is non-`nil', the local host
name of your machine will not appear in the `From:' field of article
headers you post.  This is called the "GENERICFROM" feature in the Bnews
system.  This may be useful if there are many workstations connected to
each other in a local area network, and aliases service or automatic
forwarding of mail is supported between the workstations.

  To use the GENERICFROM, put the following code in `.emacs',
`site-init.el' or `default.el'.  If you are a system administrator and
are installing GNUS for other users, `site-init.el' is the best place to
define it because the definition is common to all users of the system
having the same domain and organization (*Note Domain and Organization:
Domain.).

     (setq gnus-use-generic-from t)

  As a special case of the GENERICFROM feature, if the variable
`gnus-use-generic-from' is a string, it is used as your domain instead
of the definition of the environment variable `DOMAINNAME' or the
variable `gnus-your-domain' (*Note Domain and Organization: Domain.).


GENERICPATH
-----------

  If the variable `gnus-use-generic-path' is `nil', the NNTP server name
followed by the user login name is used in the `Path:' field of article
headers you post.  If it is a string, the string followed by the user
login name is used instead.  Otherwise, if it is non-`nil', only the
user login name is used.  This is called the "GENERICPATH" feature in
the Bnews system.

  For example, to define the generic path `flab', put the following
codes in `.emacs', `site-init.el' or `default.el'.  If you are a system
administrator and are installing GNUS for other users, `site-init.el' is
the best place to define it because the definition is common to all
users of the system having the same domain and organization (*Note
Domain and Organization: Domain.).

     (setq gnus-use-generic-path "flab")

In this case, the `Path:' field will be generated as `Path: flab!USER'.


Startup File
------------

  "Startup file" is a file recording information on articles you have
already read.  GNUS uses `.newsrc' for the startup file as in the Bnews
system.  If you think you will talk to exactly one NNTP server, you can
use it without any problems.  Otherwise, if you want to talk to several
NNTP servers, you'd better use server specific startup files since
startup files are not portable between servers.  The server specific
startup file for an NNTP server on a machine SERVER is a file named
`.newsrc-SERVER'.  For example, `.newsrc-photon' is for an NNTP server
on a machine named `photon'.  The primary name of the startup file,
`.newsrc', is specified by the variable `gnus-startup-file' (*Note
Variables::).

  GNUS automatically adds newly created newsgroups to a startup file
when getting started.  To prevent adding the newsgroups under some
newsgroup hierarchies, you can use the options line in the startup file
or the variable `gnus-subscribe-newsgroup-method' provided for
subscription method customization.  *Note Variables::, for more
information on the variable customization.

  Option `-n' of the options line in the startup file is recognized
properly the same as for the Bnews system.  For example, if the options
line is `options -n !talk talk.rumors', newsgroups under the `talk'
hierarchy except for `talk.rumors' are ignored while checking new
newsgroups.  These ignored newsgroups can be added manually using the
command `U' (`gnus-Group-unsubscribe-group') in the Newsgroup buffer.
Use the command `C-k' (`gnus-Group-kill-group') to kill newsgroups from
the startup file per a newsgroup basis.  *Note Maintenance::, for more
information.

  Once a startup file is updated by GNUS, the "quick startup file" of
which the file name is generated by appending `.el' to that of the raw
startup file is also created.  The quick startup file can be read by
Emacs faster than the raw startup file since all information in the file
is in lisp form.  If there is a quick startup file and it is newer than
the raw startup file, the quick startup file is loaded instead of the
raw startup file.  If the raw startup file is newer, it is normally read
after loading the quick startup file.  You should not remove the quick
startup file because it contains additional information.  Instead, make
the raw startup file newer than that by touching it or force GNUS to
read it by using the command `R' (`gnus-Group-restart') in the Newsgroup
buffer if you want to reflect the changes of the raw startup file to
GNUS.


Texinfo Manual
==============

  `gnus.texinfo' is a manual of GNUS written in Texinfo format.  This
file can be printed using TeX, and also can be read using Info Mode of
Emacs.

  *Note Creating an Info File: (texinfo)Creating an Info File, to create
an on-line Info file from the Texinfo manual.  If you are not allowed to
create the Info file in the standard Info directory specified by the
variable `Info-directory', create it in your private directory and set
the variable `gnus-Info-directory' to the directory.

  If this Info file is installed, you can read the documentation of GNUS
according to the current major mode of GNUS.  The command
`gnus-Info-find-node' for reading appropriate Info nodes of the Info
file is assigned to `C-c C-i' in all major modes of GNUS.

  *Note Printing Hardcopy: (texinfo)Printing Hardcopy, to print a
hardcopy of the manual.
