/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassManagerImpl
extends BshClassManager {
    private BshClassPath baseClassPath;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;
    static /* synthetic */ Class class$bsh$Interpreter;

    public ClassManagerImpl() {
        this.reset();
    }

    public Class getClassForName(String string) {
        ClassLoader classLoader;
        Class<?> clazz = (Class<?>)BshClassManager.absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (BshClassManager.absoluteNonClasses.get(string) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string);
        }
        if ((classLoader = this.getLoaderForClass(string)) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (clazz == null) {
            if (string.startsWith("bsh.")) {
                try {
                    clazz = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = ClassManagerImpl.class$("bsh.Interpreter")) : class$bsh$Interpreter).getClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (this.baseLoader != null) {
                try {
                    clazz = this.baseLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    clazz = BshClassManager.plainClassForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        BshClassManager.cacheClassInfo(string, clazz);
        return clazz;
    }

    public Class getPlainClassForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return Class.forName(string, true, classLoader);
        }
        return Class.forName(string);
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    public ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader(this.baseClassPath);
    }

    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object;
        Object object2;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            this.baseClassPath.insureInitialized();
            object = this.baseClassPath.getClassSource((String)object2);
            if (object == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                object = BshClassPath.getUserClassPath().getClassSource((String)object2);
            }
            if (object == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object2);
            }
            if (!(object instanceof BshClassPath.DirClassSource)) {
                throw new ClassPathException("Cannot reload class: " + (String)object2 + " from source: " + object);
            }
            classSourceMap.put((String)object2, ((BshClassPath.DirClassSource)object).getDir());
            ++n;
        }
        object2 = new DiscreteFilesClassLoader(classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), object2);
        }
        this.classLoaderChanged();
    }

    public void reloadPackage(String string) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    public void doSuperImport() throws EvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new EvalError("Error importing classpath " + classPathException);
        }
    }

    public String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    protected void classLoaderChanged() {
        this.clearCaches();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)weakReference.get();
            if (listener == null) {
                this.listeners.removeElement(weakReference);
                continue;
            }
            listener.classLoaderChanged();
        }
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

